/*
 * Copyright (C) 1993-2005 Robert & Jeremy Lain
 * See AUTHORS file for a full list of contributors.
 * 
 * $Id: sailcutqt.cpp,v 1.12 2005/12/06 17:44:30 jeremy_laine Exp $
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "sailcutqt.h"
#include <QFile>
#include <QDir>
#include <QTranslator>
#include "sailreader-xml.h"
#include "sailwriter-xml.h"

using namespace std;

/**
 * Creates an new Sailcut application.
 *
 * @param argc
 * @param argv
 */
CSailApp::CSailApp(int argc, char* argv[]) :
        QApplication(argc, argv)
{
    // create and install translators
    transApp = new QTranslator( this );
    transQt = new QTranslator( this );

    // the file containing the user's preferences
    prefsfile = QDir::home().filePath(".sailcutrc");
}


/**
 * The destructor.
 */
CSailApp::~CSailApp()
{
}


/**
 * Tries to locate the Sailcut Handbook.
 */
QString CSailApp::findHandbook(const QString locale)
{
    QString handbook;
    QStringList locales(locale);
    if (locale != "en") 
      locales.append("en"); 

    // look for handbook in different languages
    for (int i = 0; i < locales.size(); i++)
    {
        handbook = "html" + QDir::separator() + locales.at(i) + QDir::separator() + "index.html";
        if (QFile::exists(handbook)) return handbook;

        handbook = "docs" + QDir::separator() + locales.at(i) + QDir::separator() + "index.html";
        if (QFile::exists(handbook)) return handbook;
        
#ifdef SAILCUT_DOCDIR
        handbook = SAILCUT_DOCDIR + QDir::separator() + "html" + QDir::separator() + locales.at(i) + QDir::separator() + "index.html";
        if (QFile::exists(handbook)) return handbook;
#endif
    }
    
    return "";
}


/**
 * Loads translation strings for a given language.
 */
void CSailApp::loadTranslation(const QString locale)
{
    // translation file for Qt
    transQt->load( QString( "qt_" ) + locale, "." );
    installTranslator(transQt);

    // translation file for application strings
    QString qm = QString("sailcut.") + locale;
    transApp->load(qm, ".")
        || transApp->load(qm, "ts")
#ifdef SAILCUT_DATADIR
        || transApp->load(qm, SAILCUT_DATADIR)
#endif
    ;    
    installTranslator(transApp);
}


/**
 * Try to read the user's preferences
 */
void CSailApp::readPrefs()
{
    try
    {
        if (QFile(prefsfile).exists())
            prefs = CPrefsXmlReader("prefs").read(prefsfile);
    }
    catch (CException e)
    {
        qDebug("Could not read preferences");
    }
}


/**
 * Try to write the user's preferences.
 */
void CSailApp::writePrefs()
{
    try
    {
        CPrefsXmlWriter(prefs,"prefs").write(prefsfile);
    }
    catch (CException e)
    {
        qDebug("Could not write preferences");
    }
}
