//  Copyright (C) 2007-2008  CEA/DEN, EDF R&D, OPEN CASCADE
//
//  Copyright (C) 2003-2007  OPEN CASCADE, EADS/CCR, LIP6, CEA/DEN,
//  CEDRAT, EDF R&D, LEG, PRINCIPIA R&D, BUREAU VERITAS
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
//
//  See http://www.salome-platform.org/ or email : webmaster.salome@opencascade.com
//
//  File   : VISU_DeformationPL.hxx
//  Author : 
//  Module : SALOME
//
#ifndef VISU_DeformationPL_HeaderFile
#define VISU_DeformationPL_HeaderFile

#include "VISUPipeline.hxx"
#include "VISU_MapperHolder.hxx"
#include <vtkSmartPointer.h>

class vtkDataSet;
class VISU_MergeFilter;
class vtkPassThroughFilter;
class vtkWarpVector;
class vtkCellDataToPointData;

class VISU_PIPELINE_EXPORT VISU_DeformationPL {
  
public:
  VISU_DeformationPL();
  virtual ~VISU_DeformationPL();

  //-----------------------------------------------------------
  virtual void SetScale(vtkFloatingPointType theScaleFactor);
  virtual void SetMapScale(vtkFloatingPointType theMapScaleFactor);
  virtual vtkFloatingPointType GetScale();

  //-----------------------------------------------------------
  virtual void SetVectorialField(VISU::PUnstructuredGridIDMapper theIdMapper) = 0;
  virtual VISU::PUnstructuredGridIDMapper getVectorialField() = 0;


  //-----------------------------------------------------------
  virtual 
  unsigned 
  long int
  GetMTime();

  static vtkFloatingPointType GetDefaultScaleFactor(VISU_DeformationPL *thePipeLine);

  void SetWarpVectorInput(vtkDataSet *theInput);
  vtkDataSet* GetWarpVectorOutput();

  //-----------------------------------------------------------
  void SetMergeFilterInput(vtkDataSet* ScalarInput,
                           vtkDataSet* VectorialInput);

  vtkDataSet* GetMergeFilterOutput();

protected:

  VISU::PUnstructuredGridIDMapper myVectorialField;
  vtkWarpVector *myWarpVector;
  vtkSmartPointer<VISU_MergeFilter> myVectorMergeFilter;
  vtkPassThroughFilter *myInputPassFilter;
  vtkPassThroughFilter *myOutputPassFiler;
  vtkCellDataToPointData *myCellDataToPointData;

private:
  vtkFloatingPointType myScaleFactor;
  vtkFloatingPointType myMapScaleFactor;

};

#endif
