# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XAttributeTestCase(unittest.TestCase):
    def test_argslen(self):
        self.failUnlessRaises(XAttributeError, XAttribute, "toto", None)
        x= XAttribute("toto", default_value=None)
        return
    def test_name(self):
        self.failUnlessRaises(XValueError, XAttribute, 2.3, default_value=None)
        self.failUnlessRaises(XValueError, XAttribute, "", default_value=None)
        name = "x"
        x = XAttribute(name, default_value=None)
        self.failUnlessEqual(name, x.name)
        self.failUnlessEqual(name, x.getName())
        return
    def test_noargs(self):
        x = XAttribute("aaa", xtype=XString())
        self.failUnlessEqual(x.hasDefaultValue(), 0)
        self.failUnlessRaises(XValueError, x.getDefaultValue)
        self.failUnlessEqual(x.xtype("toto"), "toto")
        return
    def test_default_value_without_xtype(self):
        default_value = 123
        x = XAttribute("aaa", default_value=default_value)
        self.failUnlessEqual(x.hasDefaultValue(), 1)
        self.failUnlessEqual(x.getDefaultValue(), default_value)
        self.failUnlessEqual(x.xtype("256"), 256)
        self.failUnlessEqual(x.xtype(default_value), default_value)
        self.failUnlessRaises(XValueError, x.xtype, 1.2)
        self.failUnlessRaises(XValueError, x.xtype, "toto")
        #
        x = XAttribute("a", default_value=None)
        self.failUnlessEqual(x.hasDefaultValue(), 1)
        self.failUnlessEqual(x.getDefaultValue(), None)
        #
        return
    def test_xtype(self):
        self.failUnlessRaises(XValueError, XAttribute, "aa", xtype="toto")
        name = "toto"
        x = XAttribute(name, xtype=XFloat(min=0.5))
        self.failUnlessRaises(XValueError, x.xtype, "toto")
        self.failUnlessRaises(XValueError, x.xtype, -2.3)
        return
    def test_default_value_with_types(self):
        # particuliar case when default_value is None
        x = XAttribute("x", default_value=None, xtype=XString())
        self.failUnlessEqual(x.xtype("toto"), "toto")
        self.failUnlessEqual(x.xtype("None"), None)
        # imcompatibility between "toto" and XFloat()
        self.failUnlessRaises(XValueError, XAttribute, "x", default_value="toto", xtype=XFloat())
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
