# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class A(XObject):
    __init__xattributes__ = [
        XAttribute("x", xtype=XInt(min=0)),
        ]
    pass

class ATestCase(unittest.TestCase):
    def test__init__(self):
        self.failUnlessRaises(XAttributeError, A)
        self.failUnlessRaises(XAttributeError, A, 1, 2)
        self.failUnlessRaises(XAttributeError, A, y=2)
        a = A(1)
        a = A(x=3)
        return
    def test_accessors(self):
        a = A(0)
        self.failUnlessEqual(a.x, 0)
        self.failUnlessEqual(a.getX(), 0)
        a.x = 1
        self.failUnlessEqual(a.x, 1)
        a.setX(2)
        self.failUnlessEqual(a.getX(), 2)
        a.x = "2+5+3"
        self.failUnlessEqual(a.x, 10)
        return
    def test_value(self):
        self.failUnlessRaises(XValueError, A, -1)
        self.failUnlessRaises(XValueError, A, "toto")
        a = A(0)
        self.failUnlessRaises(XValueError, a.setX, -1)
        self.failUnlessRaises(XValueError, a.__setattr__, "x", -1)
        self.failUnlessRaises(XValueError, setattr, a, "x", -1)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
