# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xdata import *

class XIntWithMultiple(XInt):
    __init__xattributes__ = XInt.__init__xattributes__ + [
        XAttribute("multiple", xtype=XInt(not_into=[0]), default_value=None),
        ]
    def __call__(self, value):
        value = XInt.__call__(self, value)
        multiple = self.multiple
        if multiple is not None:
            residual = value%multiple
            if residual != 0:
                msg = "%s is not a multiple of %s"%(value, multiple)
                raise XValueError(msg)
            pass
        return value
    pass

class XIntWithMultipleTestCase(unittest.TestCase):
    def test(self):
        x = XIntWithMultiple(multiple=5)
        self.failUnlessEqual(x(10), 10)
        self.failUnlessEqual(x(0), 0)
        self.failUnlessEqual(x("15"), 15)
        self.failUnlessRaises(XValueError, x, 1)
        return
    def test_multiple(self):
        self.failUnlessRaises(XValueError, XIntWithMultiple, multiple="toto")
        self.failUnlessRaises(XValueError, XIntWithMultiple, multiple=0)
        return
    def testwithmin(self):
        x = XIntWithMultiple(multiple=5, min=1)
        self.failUnlessEqual(x(10), 10)
        self.failUnlessEqual(x("15"), 15)
        self.failUnlessRaises(XValueError, x, 0)
        self.failUnlessRaises(XValueError, x, 1)
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
