# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

import unittest

from xsalome import XSalomeSession

salome = XSalomeSession(modules=["DATATEST1"])

class TestCase(unittest.TestCase):
    def test(self):
        from DATATEST1listmenu import AAA
        a = AAA()
        self.failUnlessEqual(a.getL1(), [])
        self.failUnlessEqual(a.getL1(), [0])
        self.failUnlessEqual(a.getL1(), [0, 1])
        self.failUnlessEqual(a.getL2(), [1, "a", 2, "b"])
        a.sendL3([1, "a", 2, "b"])
        a.sendL4([ [1, "a", 2, "b"] ])
        a.sendL5([ [1, 2, 3, 4] ])
        a.sendL6([ [1., 2., 3., 4.] ])
        a.sendL7([ ["a", "b", "c", "d"] ])
        return
    pass

if __name__ == '__main__':
    unittest.main()
    pass
