# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --
# -----------------------------------------------

def isXList(xattr):
    isList = 0
    list_seq = None
    xlist = None

    if xattr is None:
        return isList, list_seq
    
    from xtypes import XList, XTuple, XMulTypes, XNone
    
    if isinstance(xattr.getXtype(), (XList, XTuple)):
        isList = 1
        xlist = xattr.getXtype()
    elif isinstance(xattr.getXtype(), XMulTypes):
        classes = xattr.getXtype().getXtypes()
        if isinstance(classes[0], XNone) and isinstance(classes[1], (XList, XTuple)):
            isList = 1
            xlist = classes[1]
            pass
        pass

    if isList:
        list_seq = xlist.getSequence()
        pass
    
    return isList, list_seq

def inplaceCreationMenu(parent, qt_menu, inplace_handler, classes):
    from xdatagui import XGUIMenu
    menu = XGUIMenu(parent, qt_menu, inplace_handler)            

    isOk = 0
    
    from xutilities import getModule
    for cls in classes:
        from inspect import isclass
        from xobject import XObject
        if not isclass(cls) or not issubclass(cls, XObject):
            continue

        name = cls.__name__ 

        isModule = 0
        isClass = 0
                
        try:
            m = getModule("menu_%s"%(name.lower()))
            isModule = 1
        except ImportError:
            m = None
            for b in cls.__bases__:
                try:
                    m = getModule("menu_%s"%(b.__name__.lower()))
                except ImportError:
                    m = None
                    pass

                if m is not None:
                    if name in m.__xdata__items__:
                        isClass = 1
                        break
                    pass
                pass
            pass
        except AttributeError:
            pass

        if isModule:
            menu.insertXDataModule("menu_%s"%(name.lower()))
            isOk = 1
            pass
        elif isClass:
            menu.insertXDataClass(cls)
            isOk = 1
            pass
        pass
    return isOk
