# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xqt import *
from xutilities import message

_main_window = None

def setMainWindow(qt_window):
    message(qt_window, verbose_level_min=5)
    # --
    # E.A. : with --test runSalome option, the qt_class is None
    # on the really first time we go here
    # --
    if qt_window is None:
        return
    #
    global _main_window
    _main_window = qt_window
    #
    qt_class = qt_window.__class__
    qt_class.updateObjectBrowser = updateObjectBrowser
    qt_class.newObjectCreated = newObjectCreated
    qt_class.oldObjectModified = oldObjectModified
    qt_class.displayException = displayException
    qt_class.browserSelectionChanged = browserSelectionChanged
    qt_class.selectedNodes = selectedNodes
    qt_class.selectedXTrees = selectedXTrees
    #
    qt_class.moveActivated = moveActivated
    qt_class.putInBuffer = putInBuffer
    qt_class.deleteNodes = deleteNodes
    qt_class.specialPaste = specialPaste
    #
    qt_window.disconnect(qt_window, PYSIGNAL("new_object_created"),
                         qt_window.newObjectCreated)
    qt_window.connect(qt_window, PYSIGNAL("new_object_created"),
                      qt_window.newObjectCreated)
    qt_window.disconnect(qt_window, PYSIGNAL("old_object_modified"),
                         qt_window.oldObjectModified)
    qt_window.connect(qt_window, PYSIGNAL("old_object_modified"),
                      qt_window.oldObjectModified)
    #
    qt_class.getVtkRenderer = getVtkRenderer
    qt_class.getVtkRenderWindow = getVtkRenderWindow
    qt_class.getVtkRenderWindowInteractor = getVtkRenderWindowInteractor
    #
    return

def getMainWindow():
    return _main_window

class DisplayExceptionQMessageBox(QMessageBox):
    
    def __init__(self, parent):
        from xutilities import exception_informations
        exc_type, exc_value, exc_traceback, msg, full_msg = exception_informations()
        #
        if exc_value is None:
            caption = "Warning:"
        else:
            caption = "Warning: %s"%(exc_type.__name__)
            pass
        #
        messages = [msg, full_msg]
        texts = ["Details", "No details"]
        #
        index = 0
        while 1:
            button2 = QMessageBox.NoButton
            QMessageBox.__init__(self,
                                 caption,
                                 messages[index],
                                 QMessageBox.Warning,
                                 QMessageBox.Ok | QMessageBox.Default | QMessageBox.Escape,
                                 QMessageBox.No,
                                 button2,
                                 parent,
                                 )
            self.setButtonText(QMessageBox.No, texts[index])
            #
            res = self.exec_loop()
            if res == QMessageBox.No:
                index = 1-index
                pass
            if res == QMessageBox.Ok:
                break
            #
            pass
        return
    
    pass

def displayException(self, parent=None, long=1):
    if parent is None:
        parent = getMainWindow()
        pass
    dialog = DisplayExceptionQMessageBox(parent)
    return

def updateObjectBrowser(self):
    # --
    # E.A. : Erreur:
    # ...
    # File ".../lib/python2.4/site-packages/xdata/xmainwindow.py", line 62, in updateObjectBrowser
    # from xpythongui import XGUIQMainWindow
    # File ".../lib/python2.4/site-packages/salome/import_hook.py", line 156, in import_hook
    # module= original_import(name, globals, locals, fromlist)
    # RuntimeError: cannot unmarshal code objects in restricted execution mode
    # ...
    # Then, try: ... except: return !!
    # --
    try:
        from xpythongui import XGUIQMainWindow
    except:
        return
    # --
    if isinstance(self, XGUIQMainWindow):
        from xtree import getMainXTree
        xtree = getMainXTree()
        self.xtree = xtree
        self.emit(PYSIGNAL("update_with_xtree"), (xtree, ))
        return
    import salome
    salome.sg.updateObjBrowser(0)
    return

def newObjectCreated(self, obj):
    message(obj)
    if hasattr(obj, '__corba__component__'):
        import salome
        myStudyId = salome.sg.getActiveStudyId()
        myStudy = salome.myStudyManager.GetStudyByID(myStudyId)
        corba_object = obj.__corba__object__
        try:
            name_in_study = obj.__instance__name__
        except:
            name_in_study = None
            pass
        if name_in_study is None and hasattr(corba_object, "_narrow"):
            # --
            # Perhaps, a composite attribute is being edited
            # It has empty __instance__name__
            # So trying to find its current name in the study
            #
            ior = salome.orb.object_to_string(corba_object)
            mySObject = myStudy.FindObjectIOR(ior)
            if mySObject is not None:
                name_in_study = mySObject.GetName()
                pass
            pass
        if name_in_study is None:
            return
        #
        try:
            from os import getenv
            publish_without_content = int(getenv('XDATA_PUBLISH_IN_STUDY_WITHOUT_CONTENT'))
        except:
            publish_without_content = 0
            pass
        if publish_without_content:
            obj.__corba__component__.PublishInStudyWithoutContent(myStudy, None, corba_object, name_in_study)
        else:
            obj.__corba__component__.PublishInStudy(myStudy, None, corba_object, name_in_study)
            pass
        #
        salome.sg.updateObjBrowser(0)
        pass
    else:
        self.updateObjectBrowser()
        pass

    # --
    # Need to try catch for object which are not local
    # but push in study ...
    
    try:
        cp = obj.__code__percentage__
    except AttributeError:
        cp = None
        pass
    if cp is not None:
        message("emit code_percentage with cp :", cp)
        self.emit(PYSIGNAL("code_percentage"), (cp, ))
        pass
    
    return

def oldObjectModified(self, obj):
    message(obj)
    self. newObjectCreated(obj)
    return

def browserSelectionChanged(self, objs):
    from xutilities import message
    message(self, objs)
    if hasattr(self, "__nodes2move__"):
        nodes2move = self.__nodes2move__
        delattr(self, "__nodes2move__")
        selection = objs
        if len(selection) == 0:
            from xmetaclass import __xobjects__
            __xobjects__.remove(nodes2move)
            __xobjects__.append(nodes2move)
            self.updateObjectBrowser()
        elif len(selection) == 1:
            item = selection[0]
            if item.xtree.depth == 1:
                node = item.xtree.node
                if node != nodes2move:
                    from xmetaclass import __xobjects__
                    __xobjects__.remove(nodes2move)
                    __xobjects__.insert(__xobjects__.index(node), nodes2move)
                    self.updateObjectBrowser()
                    pass
                pass
            pass
        QApplication.restoreOverrideCursor()
        pass
    self.emit(PYSIGNAL("browser_selection_changed"), (objs, ))
    self.__selection__ = objs
    return

def selectedXTrees(self):
    try:
        selection = self.__selection__
    except:
        selection = []
        pass
    return [ item.xtree for item in selection ]

def selectedNodes(self):
    return [ xtree.node for xtree in self.selectedXTrees() ]

def moveActivated(self, nodes):
    message(nodes)
    node = nodes[0]
    if hasattr(node, '__corba__component__'):
        msg = "Not implemented yet in Salome ..."
        QMessageBox.warning(getMainWindow(), "Warning", msg)
        return
    self.__nodes2move__ = nodes[0]
    QApplication.setOverrideCursor(Qt.pointingHandCursor)
    return

def putInBuffer(self, nodes, buffer_type):
    message(nodes)
    node = nodes[0]
    if hasattr(node, '__corba__component__'):
        msg = "Not implemented yet in Salome ..."
        QMessageBox.warning(getMainWindow(), "Warning", msg)
        return
    self.__buffer__ = nodes
    self.__buffer__type__ = buffer_type
    return

def deleteNodes(self, nodes):
    for node in nodes:
        if not hasattr(node, "__corba__object__"):
            from xmetaclass import removeXObject
            removeXObject(node)
            getMainWindow().updateObjectBrowser()
        else:
            import salome
            myStudyId = salome.sg.getActiveStudyId()
            myStudy = salome.myStudyManager.GetStudyByID(myStudyId)
            myBuilder = myStudy.NewBuilder()
            myBuilder.NewCommand()
            selection = salome.sg.getAllSelected()
            for sel in selection:
                sobj = myStudy.FindObjectID(sel)
                myBuilder.RemoveObjectWithChildren(sobj)
                pass
            salome.sg.updateObjBrowser(1)
            pass
        pass
    return

def specialPaste(self, nodes, paste_type):
    message(nodes, paste_type)
    selection = nodes
    nodes = self.__buffer__
    message(nodes)
    key = paste_type
    # --
    if key == "Usual":
        copy = None
        getMainWindow().__buffer__type__ = "Copy"
    elif key == "Shallow":
        from copy import copy
    else:
        from copy import deepcopy
        copy = deepcopy
        pass
    for n in nodes:
        #
        if copy:
            n_copy = copy(n)
        else:
            n_copy = n
            pass
        #
        set_name = 0
        if copy:
            set_name = 1
        else:
            name = n_copy.__instance__name__
            if name == "":
                set_name = 1
                pass
            pass
        #
        if set_name:
            cls = n.__class__
            prefix = cls.getInstancePrefix()
            from xdata import getXObjects
            names = [ x.__instance__name__ for x in getXObjects() ]
            num = 0
            while 1:
                num += 1
                name = "%s_%s"%(prefix, num)
                if name not in names: break
                pass
            n_copy.__instance__name__ = name
            n_copy.__code__next__operation__ = "STORE_NAME"
            pass
        #
        if len(selection) == 0:
            from xmetaclass import __xobjects__
            __xobjects__.append(n_copy)
        elif len(selection) == 1:
            node = selection[0]
            from xmetaclass import __xobjects__
            index = __xobjects__.index(node)
            __xobjects__.insert(index, n_copy)
            pass
        pass
    #
    self.updateObjectBrowser()
    #
    return


##def copyActivated(self, nodes):
##    message(nodes)
##    self.__nodes2copy__ = nodes
##    QApplication.setOverrideCursor(Qt.pointingHandCursor)
##    return

##def deepcopyActivated(self, nodes):
##    message(nodes)
##    node = nodes[0]
##    if hasattr(node, '__corba__component__'):
##        msg = "Not implemented yet in Salome ..."
##        QMessageBox.warning(getMainWindow(), "Warning", msg)
##        return
##    self.__nodes2deepcopy__ = nodes
##    QApplication.setOverrideCursor(Qt.pointingHandCursor)
##    return

def getVtkContainer(self):
    from xpythongui import XGUIQMainWindow
    if isinstance(self, XGUIQMainWindow):
        qvtkwidget = self.qvtkwidget
        from QVTKRenderWindowInteractor import QVTKRenderWindowInteractor
        if isinstance(qvtkwidget, QVTKRenderWindowInteractor):
            return qvtkwidget
        return None
    module = __import__("libSalomePy")
    return module

def getVtkRenderer(self):
    container = getVtkContainer(self)
    if container is None : return
    return container.getRenderer()

def getVtkRenderWindow(self):
    container = getVtkContainer(self)
    if container is None : return
    return container.getRenderWindow()

def getVtkRenderWindowInteractor(self):
    container = getVtkContainer(self)
    if container is None : return
    return container.getRenderWindowInteractor()
