#include "../librpc/gen_ndr/ndr_wmi.h"
#ifndef __CLI_IWBEMCLASSOBJECT__
#define __CLI_IWBEMCLASSOBJECT__
NTSTATUS rpccli_Delete(struct rpc_pipe_client *cli,
		       TALLOC_CTX *mem_ctx,
		       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		       struct ORPCTHIS ORPCthis /* [in]  */,
		       const char *wszName /* [in] [ref,charset(UTF16)] */,
		       WERROR *werror);
#endif /* __CLI_IWBEMCLASSOBJECT__ */
#ifndef __CLI_IWBEMSERVICES__
#define __CLI_IWBEMSERVICES__
NTSTATUS rpccli_OpenNamespace(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct BSTR strNamespace /* [in]  */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer **ppWorkingNamespace /* [in,out] [unique] */,
			      struct MInterfacePointer **ppResult /* [in,out] [unique] */,
			      WERROR *werror);
NTSTATUS rpccli_CancelAsyncCall(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct MInterfacePointer *pSink /* [in] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_QueryObjectSink(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer **ppResponseHandler /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_GetObject(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strObjectPath /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppObject /* [in,out] [unique] */,
			  struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			  WERROR *werror);
NTSTATUS rpccli_GetObjectAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror);
NTSTATUS rpccli_PutClass(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 struct MInterfacePointer *pObject /* [in] [ref] */,
			 int32_t lFlags /* [in]  */,
			 struct MInterfacePointer *pCtx /* [in] [ref] */,
			 struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			 WERROR *werror);
NTSTATUS rpccli_PutClassAsync(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      struct MInterfacePointer *pObject /* [in] [ref] */,
			      int32_t lFlags /* [in]  */,
			      struct MInterfacePointer *pCtx /* [in] [ref] */,
			      struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			      WERROR *werror);
NTSTATUS rpccli_DeleteClass(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct BSTR strClass /* [in]  */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror);
NTSTATUS rpccli_DeleteClassAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct BSTR strClass /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror);
NTSTATUS rpccli_CreateClassEnum(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strSuperclass /* [in]  */,
				int32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer **ppEnum /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_CreateClassEnumAsync(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				     struct ORPCTHIS ORPCthis /* [in]  */,
				     struct BSTR strSuperclass /* [in]  */,
				     int32_t lFlags /* [in]  */,
				     struct MInterfacePointer *pCtx /* [in] [ref] */,
				     struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				     WERROR *werror);
NTSTATUS rpccli_PutInstance(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    struct MInterfacePointer *pInst /* [in] [ref] */,
			    int32_t lFlags /* [in]  */,
			    struct MInterfacePointer *pCtx /* [in] [ref] */,
			    struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			    WERROR *werror);
NTSTATUS rpccli_PutInstanceAsync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 struct MInterfacePointer *pInst /* [in] [ref] */,
				 int32_t lFlags /* [in]  */,
				 struct MInterfacePointer *pCtx /* [in] [ref] */,
				 struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				 WERROR *werror);
NTSTATUS rpccli_DeleteInstance(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strObjectPath /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			       WERROR *werror);
NTSTATUS rpccli_DeleteInstanceAsync(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				    struct ORPCTHIS ORPCthis /* [in]  */,
				    struct BSTR strObjectPath /* [in]  */,
				    int32_t lFlags /* [in]  */,
				    struct MInterfacePointer *pCtx /* [in] [ref] */,
				    struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				    WERROR *werror);
NTSTATUS rpccli_CreateInstanceEnum(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				   struct ORPCTHIS ORPCthis /* [in]  */,
				   struct BSTR strFilter /* [in]  */,
				   int32_t lFlags /* [in]  */,
				   struct MInterfacePointer *pCtx /* [in] [unique] */,
				   struct MInterfacePointer **ppEnum /* [out] [ref] */,
				   WERROR *werror);
NTSTATUS rpccli_CreateInstanceEnumAsync(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					struct ORPCTHIS ORPCthis /* [in]  */,
					struct BSTR strSuperClass /* [in]  */,
					int32_t lFlags /* [in]  */,
					struct MInterfacePointer *pCtx /* [in] [ref] */,
					struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					WERROR *werror);
NTSTATUS rpccli_ExecQuery(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  struct BSTR strQueryLanguage /* [in]  */,
			  struct BSTR strQuery /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppEnum /* [out] [ref] */,
			  WERROR *werror);
NTSTATUS rpccli_ExecQueryAsync(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       struct BSTR strQueryLanguage /* [in]  */,
			       struct BSTR strQuery /* [in]  */,
			       int32_t lFlags /* [in]  */,
			       struct MInterfacePointer *pCtx /* [in] [ref] */,
			       struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
			       WERROR *werror);
NTSTATUS rpccli_ExecNotificationQuery(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				      struct ORPCTHIS ORPCthis /* [in]  */,
				      struct BSTR strQueryLanguage /* [in]  */,
				      struct BSTR strQuery /* [in]  */,
				      int32_t lFlags /* [in]  */,
				      struct MInterfacePointer *pCtx /* [in] [unique] */,
				      struct MInterfacePointer **ppEnum /* [out] [ref] */,
				      WERROR *werror);
NTSTATUS rpccli_ExecNotificationQueryAsync(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct BSTR strQueryLanguage /* [in]  */,
					   struct BSTR strQuery /* [in]  */,
					   int32_t lFlags /* [in]  */,
					   struct MInterfacePointer *pCtx /* [in] [ref] */,
					   struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
					   WERROR *werror);
NTSTATUS rpccli_ExecMethod(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			   struct ORPCTHIS ORPCthis /* [in]  */,
			   struct BSTR strObjectPath /* [in]  */,
			   struct BSTR strMethodName /* [in]  */,
			   int32_t lFlags /* [in]  */,
			   struct MInterfacePointer *pCtx /* [in] [unique] */,
			   struct MInterfacePointer *pInParams /* [in] [unique] */,
			   struct MInterfacePointer **ppOutParams /* [in,out] [unique] */,
			   struct MInterfacePointer **ppCallResult /* [in,out] [unique] */,
			   WERROR *werror);
NTSTATUS rpccli_ExecMethodAsync(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				struct BSTR strObjectPath /* [in]  */,
				struct BSTR strMethodName /* [in]  */,
				uint32_t lFlags /* [in]  */,
				struct MInterfacePointer *pCtx /* [in] [ref] */,
				struct MInterfacePointer *pInParams /* [in] [ref] */,
				struct MInterfacePointer *pResponseHandler /* [in] [ref] */,
				WERROR *werror);
#endif /* __CLI_IWBEMSERVICES__ */
#ifndef __CLI_IENUMWBEMCLASSOBJECT__
#define __CLI_IENUMWBEMCLASSOBJECT__
NTSTATUS rpccli_Reset(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      WERROR *werror);
NTSTATUS rpccli_IEnumWbemClassObject_Next(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					  struct ORPCTHIS ORPCthis /* [in]  */,
					  int32_t lTimeout /* [in]  */,
					  uint32_t uCount /* [in]  */,
					  struct MInterfacePointer **apObjects /* [out] [ref,length_is(*puReturned),size_is(uCount)] */,
					  uint32_t *puReturned /* [out] [ref] */,
					  WERROR *werror);
NTSTATUS rpccli_NextAsync(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  uint32_t uCount /* [in]  */,
			  struct MInterfacePointer *pSink /* [in] [ref] */,
			  WERROR *werror);
NTSTATUS rpccli_IEnumWbemClassObject_Clone(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ORPCTHAT *ORPCthat /* [out] [ref] */,
					   struct ORPCTHIS ORPCthis /* [in]  */,
					   struct MInterfacePointer **ppEnum /* [out] [ref] */,
					   WERROR *werror);
NTSTATUS rpccli_Skip(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     int32_t lTimeout /* [in]  */,
		     uint32_t nCount /* [in]  */,
		     WERROR *werror);
#endif /* __CLI_IENUMWBEMCLASSOBJECT__ */
#ifndef __CLI_IWBEMCONTEXT__
#define __CLI_IWBEMCONTEXT__
NTSTATUS rpccli_Clone(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppNewCopy /* [out] [ref] */,
		      WERROR *werror);
NTSTATUS rpccli_GetNames(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror);
NTSTATUS rpccli_BeginEnumeration(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 int32_t lFlags /* [in]  */,
				 WERROR *werror);
NTSTATUS rpccli_Next(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     WERROR *werror);
NTSTATUS rpccli_EndEnumeration(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			       struct ORPCTHIS ORPCthis /* [in]  */,
			       WERROR *werror);
NTSTATUS rpccli_SetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror);
NTSTATUS rpccli_GetValue(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 WERROR *werror);
NTSTATUS rpccli_DeleteValue(struct rpc_pipe_client *cli,
			    TALLOC_CTX *mem_ctx,
			    struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			    struct ORPCTHIS ORPCthis /* [in]  */,
			    WERROR *werror);
NTSTATUS rpccli_DeleteAll(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  WERROR *werror);
#endif /* __CLI_IWBEMCONTEXT__ */
#ifndef __CLI_IWBEMLEVEL1LOGIN__
#define __CLI_IWBEMLEVEL1LOGIN__
NTSTATUS rpccli_EstablishPosition(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  const char *wszLocaleList /* [in] [unique,charset(UTF16)] */,
				  uint32_t dwNumLocales /* [in]  */,
				  uint32_t *reserved /* [out] [ref] */,
				  WERROR *werror);
NTSTATUS rpccli_RequestChallenge(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				 struct ORPCTHIS ORPCthis /* [in]  */,
				 const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
				 const char *wszUser /* [in] [unique,charset(UTF16)] */,
				 uint8_t *Nonce /* [out] [ref,length_is(16),size_is(16)] */,
				 WERROR *werror);
NTSTATUS rpccli_WBEMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  uint8_t *AccessToken /* [in] [unique,length_is(16),size_is(16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [ref] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror);
NTSTATUS rpccli_NTLMLogin(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  const char *wszNetworkResource /* [in] [unique,charset(UTF16)] */,
			  const char *wszPreferredLocale /* [in] [unique,charset(UTF16)] */,
			  int32_t lFlags /* [in]  */,
			  struct MInterfacePointer *pCtx /* [in] [unique] */,
			  struct MInterfacePointer **ppNamespace /* [out] [ref] */,
			  WERROR *werror);
#endif /* __CLI_IWBEMLEVEL1LOGIN__ */
#ifndef __CLI_IWBEMWCOSMARTENUM__
#define __CLI_IWBEMWCOSMARTENUM__
NTSTATUS rpccli_IWbemWCOSmartEnum_Next(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				       struct ORPCTHIS ORPCthis /* [in]  */,
				       struct GUID *gEWCO /* [in] [ref] */,
				       uint32_t lTimeOut /* [in]  */,
				       uint32_t uCount /* [in]  */,
				       uint32_t unknown /* [in]  */,
				       struct GUID *gWCO /* [in] [ref] */,
				       uint32_t *puReturned /* [out] [ref] */,
				       uint32_t *pSize /* [out] [ref] */,
				       uint8_t **pData /* [out] [noprint,ref,size_is(,*pSize)] */,
				       WERROR *werror);
#endif /* __CLI_IWBEMWCOSMARTENUM__ */
#ifndef __CLI_IWBEMFETCHSMARTENUM__
#define __CLI_IWBEMFETCHSMARTENUM__
NTSTATUS rpccli_Fetch(struct rpc_pipe_client *cli,
		      TALLOC_CTX *mem_ctx,
		      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		      struct ORPCTHIS ORPCthis /* [in]  */,
		      struct MInterfacePointer **ppEnum /* [out] [ref] */,
		      WERROR *werror);
NTSTATUS rpccli_Test(struct rpc_pipe_client *cli,
		     TALLOC_CTX *mem_ctx,
		     struct ORPCTHAT *ORPCthat /* [out] [ref] */,
		     struct ORPCTHIS ORPCthis /* [in]  */,
		     struct MInterfacePointer **ppEnum /* [out] [ref] */,
		     WERROR *werror);
#endif /* __CLI_IWBEMFETCHSMARTENUM__ */
#ifndef __CLI_IWBEMCALLRESULT__
#define __CLI_IWBEMCALLRESULT__
NTSTATUS rpccli_GetResultObject(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct MInterfacePointer **ppResultObject /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_GetResultString(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				struct ORPCTHIS ORPCthis /* [in]  */,
				int32_t lTimeout /* [in]  */,
				struct BSTR *pstrResultString /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_GetResultServices(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
				  struct ORPCTHIS ORPCthis /* [in]  */,
				  int32_t lTimeout /* [in]  */,
				  struct MInterfacePointer **ppServices /* [out] [ref] */,
				  WERROR *werror);
NTSTATUS rpccli_GetCallStatus(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			      struct ORPCTHIS ORPCthis /* [in]  */,
			      int32_t lTimeout /* [in]  */,
			      int32_t *plStatus /* [out] [ref] */,
			      WERROR *werror);
#endif /* __CLI_IWBEMCALLRESULT__ */
#ifndef __CLI_IWBEMOBJECTSINK__
#define __CLI_IWBEMOBJECTSINK__
NTSTATUS rpccli_SetStatus(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			  struct ORPCTHIS ORPCthis /* [in]  */,
			  int32_t lFlags /* [in]  */,
			  WERROR hResult /* [in]  */,
			  struct BSTR strParam /* [in]  */,
			  struct MInterfacePointer *pObjParam /* [in] [ref] */,
			  WERROR *werror);
NTSTATUS rpccli_Indicate(struct rpc_pipe_client *cli,
			 TALLOC_CTX *mem_ctx,
			 struct ORPCTHAT *ORPCthat /* [out] [ref] */,
			 struct ORPCTHIS ORPCthis /* [in]  */,
			 int32_t lObjectCount /* [in]  */,
			 struct MInterfacePointer **apObjArray /* [in] [ref,size_is(lObjectCount)] */,
			 WERROR *werror);
#endif /* __CLI_IWBEMOBJECTSINK__ */
