/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_eventlog.h"

struct rpccli_eventlog_ClearEventLogW_state {
	struct eventlog_ClearEventLogW orig;
	struct eventlog_ClearEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ClearEventLogW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ClearEventLogW_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct lsa_String *_backupfile /* [in] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ClearEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ClearEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.backupfile = _backupfile;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ClearEventLogW, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_CLEAREVENTLOGW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ClearEventLogW_done, req);
	return req;
}

static void rpccli_eventlog_ClearEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ClearEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ClearEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ClearEventLogW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ClearEventLogW_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_eventlog_ClearEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ClearEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ClearEventLogW(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct lsa_String *backupfile /* [in] [unique] */)
{
	struct eventlog_ClearEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.backupfile = backupfile;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ClearEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CLEAREVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ClearEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_BackupEventLogW_state {
	struct eventlog_BackupEventLogW orig;
	struct eventlog_BackupEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_BackupEventLogW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_BackupEventLogW_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct policy_handle *_handle /* [in] [ref] */,
							struct lsa_String *_backup_filename /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_BackupEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_BackupEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.backup_filename = _backup_filename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_BackupEventLogW, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_BACKUPEVENTLOGW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_BackupEventLogW_done, req);
	return req;
}

static void rpccli_eventlog_BackupEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_BackupEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_BackupEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_BackupEventLogW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_BackupEventLogW_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_eventlog_BackupEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_BackupEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_BackupEventLogW(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 struct lsa_String *backup_filename /* [in] [ref] */)
{
	struct eventlog_BackupEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.backup_filename = backup_filename;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_BackupEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_BACKUPEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_BackupEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_CloseEventLog_state {
	struct eventlog_CloseEventLog orig;
	struct eventlog_CloseEventLog tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_CloseEventLog_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_CloseEventLog_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_CloseEventLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_CloseEventLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_CloseEventLog, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_CloseEventLog_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_CLOSEEVENTLOG,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_CloseEventLog_done, req);
	return req;
}

static void rpccli_eventlog_CloseEventLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_CloseEventLog_state *state = tevent_req_data(
		req, struct rpccli_eventlog_CloseEventLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_CloseEventLog, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_CloseEventLog_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_eventlog_CloseEventLog_state *state = tevent_req_data(
		req, struct rpccli_eventlog_CloseEventLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_CloseEventLog(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in,out] [ref] */)
{
	struct eventlog_CloseEventLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_CloseEventLog, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CLOSEEVENTLOG,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_CloseEventLog, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_DeregisterEventSource_state {
	struct eventlog_DeregisterEventSource orig;
	struct eventlog_DeregisterEventSource tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_DeregisterEventSource_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_DeregisterEventSource_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_DeregisterEventSource_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_DeregisterEventSource_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_DeregisterEventSource, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_DeregisterEventSource_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_DEREGISTEREVENTSOURCE,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_DeregisterEventSource_done, req);
	return req;
}

static void rpccli_eventlog_DeregisterEventSource_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_DeregisterEventSource_state *state = tevent_req_data(
		req, struct rpccli_eventlog_DeregisterEventSource_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_DeregisterEventSource, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_DeregisterEventSource_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct rpccli_eventlog_DeregisterEventSource_state *state = tevent_req_data(
		req, struct rpccli_eventlog_DeregisterEventSource_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_DeregisterEventSource(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in,out] [ref] */)
{
	struct eventlog_DeregisterEventSource r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_DeregisterEventSource, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_DEREGISTEREVENTSOURCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_DeregisterEventSource, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_GetNumRecords_state {
	struct eventlog_GetNumRecords orig;
	struct eventlog_GetNumRecords tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_GetNumRecords_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_GetNumRecords_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct policy_handle *_handle /* [in] [ref] */,
						      uint32_t *_number /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_GetNumRecords_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_GetNumRecords_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.number = _number;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetNumRecords, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_GetNumRecords_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_GETNUMRECORDS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_GetNumRecords_done, req);
	return req;
}

static void rpccli_eventlog_GetNumRecords_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_GetNumRecords_state *state = tevent_req_data(
		req, struct rpccli_eventlog_GetNumRecords_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.number = *state->tmp.out.number;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetNumRecords, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_GetNumRecords_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_eventlog_GetNumRecords_state *state = tevent_req_data(
		req, struct rpccli_eventlog_GetNumRecords_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_GetNumRecords(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       uint32_t *number /* [out] [ref] */)
{
	struct eventlog_GetNumRecords r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetNumRecords, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_GETNUMRECORDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetNumRecords, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*number = *r.out.number;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_GetOldestRecord_state {
	struct eventlog_GetOldestRecord orig;
	struct eventlog_GetOldestRecord tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_GetOldestRecord_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_GetOldestRecord_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t *_oldest_entry /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_GetOldestRecord_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_GetOldestRecord_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.oldest_entry = _oldest_entry;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetOldestRecord, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_GetOldestRecord_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_GETOLDESTRECORD,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_GetOldestRecord_done, req);
	return req;
}

static void rpccli_eventlog_GetOldestRecord_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_GetOldestRecord_state *state = tevent_req_data(
		req, struct rpccli_eventlog_GetOldestRecord_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.oldest_entry = *state->tmp.out.oldest_entry;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetOldestRecord, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_GetOldestRecord_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_eventlog_GetOldestRecord_state *state = tevent_req_data(
		req, struct rpccli_eventlog_GetOldestRecord_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_GetOldestRecord(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 uint32_t *oldest_entry /* [out] [ref] */)
{
	struct eventlog_GetOldestRecord r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetOldestRecord, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_GETOLDESTRECORD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetOldestRecord, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*oldest_entry = *r.out.oldest_entry;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_ChangeNotify_state {
	struct eventlog_ChangeNotify orig;
	struct eventlog_ChangeNotify tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ChangeNotify_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ChangeNotify_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ChangeNotify_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ChangeNotify_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ChangeNotify, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_CHANGENOTIFY,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ChangeNotify_done, req);
	return req;
}

static void rpccli_eventlog_ChangeNotify_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ChangeNotify_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ChangeNotify_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ChangeNotify, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ChangeNotify_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct rpccli_eventlog_ChangeNotify_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ChangeNotify_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ChangeNotify(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct eventlog_ChangeNotify r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ChangeNotify, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CHANGENOTIFY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ChangeNotify, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_OpenEventLogW_state {
	struct eventlog_OpenEventLogW orig;
	struct eventlog_OpenEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_OpenEventLogW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_OpenEventLogW_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
						      struct lsa_String *_logname /* [in] [ref] */,
						      struct lsa_String *_servername /* [in] [ref] */,
						      uint32_t _major_version /* [in]  */,
						      uint32_t _minor_version /* [in]  */,
						      struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_OpenEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_OpenEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.unknown0 = _unknown0;
	state->orig.in.logname = _logname;
	state->orig.in.servername = _servername;
	state->orig.in.major_version = _major_version;
	state->orig.in.minor_version = _minor_version;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenEventLogW, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_OpenEventLogW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_OPENEVENTLOGW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_OpenEventLogW_done, req);
	return req;
}

static void rpccli_eventlog_OpenEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_OpenEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenEventLogW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_OpenEventLogW_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_eventlog_OpenEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_OpenEventLogW(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct eventlog_OpenUnknown0 *unknown0 /* [in] [unique] */,
				       struct lsa_String *logname /* [in] [ref] */,
				       struct lsa_String *servername /* [in] [ref] */,
				       uint32_t major_version /* [in]  */,
				       uint32_t minor_version /* [in]  */,
				       struct policy_handle *handle /* [out] [ref] */)
{
	struct eventlog_OpenEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = unknown0;
	r.in.logname = logname;
	r.in.servername = servername;
	r.in.major_version = major_version;
	r.in.minor_version = minor_version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_RegisterEventSourceW_state {
	struct eventlog_RegisterEventSourceW orig;
	struct eventlog_RegisterEventSourceW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_RegisterEventSourceW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_RegisterEventSourceW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli,
							     struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
							     struct lsa_String *_module_name /* [in] [ref] */,
							     struct lsa_String *_reg_module_name /* [in] [ref] */,
							     uint32_t _major_version /* [in]  */,
							     uint32_t _minor_version /* [in]  */,
							     struct policy_handle *_log_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_RegisterEventSourceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_RegisterEventSourceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.unknown0 = _unknown0;
	state->orig.in.module_name = _module_name;
	state->orig.in.reg_module_name = _reg_module_name;
	state->orig.in.major_version = _major_version;
	state->orig.in.minor_version = _minor_version;

	/* Out parameters */
	state->orig.out.log_handle = _log_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterEventSourceW, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_RegisterEventSourceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_REGISTEREVENTSOURCEW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_RegisterEventSourceW_done, req);
	return req;
}

static void rpccli_eventlog_RegisterEventSourceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_RegisterEventSourceW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_RegisterEventSourceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.log_handle = *state->tmp.out.log_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterEventSourceW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_RegisterEventSourceW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   NTSTATUS *result)
{
	struct rpccli_eventlog_RegisterEventSourceW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_RegisterEventSourceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_RegisterEventSourceW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct eventlog_OpenUnknown0 *unknown0 /* [in] [unique] */,
					      struct lsa_String *module_name /* [in] [ref] */,
					      struct lsa_String *reg_module_name /* [in] [ref] */,
					      uint32_t major_version /* [in]  */,
					      uint32_t minor_version /* [in]  */,
					      struct policy_handle *log_handle /* [out] [ref] */)
{
	struct eventlog_RegisterEventSourceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = unknown0;
	r.in.module_name = module_name;
	r.in.reg_module_name = reg_module_name;
	r.in.major_version = major_version;
	r.in.minor_version = minor_version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterEventSourceW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REGISTEREVENTSOURCEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterEventSourceW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*log_handle = *r.out.log_handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_OpenBackupEventLogW_state {
	struct eventlog_OpenBackupEventLogW orig;
	struct eventlog_OpenBackupEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_OpenBackupEventLogW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_OpenBackupEventLogW_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli,
							    struct eventlog_OpenUnknown0 *_unknown0 /* [in] [unique] */,
							    struct lsa_String *_backup_logname /* [in] [ref] */,
							    uint32_t _major_version /* [in]  */,
							    uint32_t _minor_version /* [in]  */,
							    struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_OpenBackupEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_OpenBackupEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.unknown0 = _unknown0;
	state->orig.in.backup_logname = _backup_logname;
	state->orig.in.major_version = _major_version;
	state->orig.in.minor_version = _minor_version;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenBackupEventLogW, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_OpenBackupEventLogW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_OPENBACKUPEVENTLOGW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_OpenBackupEventLogW_done, req);
	return req;
}

static void rpccli_eventlog_OpenBackupEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_OpenBackupEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenBackupEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenBackupEventLogW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_OpenBackupEventLogW_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  NTSTATUS *result)
{
	struct rpccli_eventlog_OpenBackupEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenBackupEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_OpenBackupEventLogW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     struct eventlog_OpenUnknown0 *unknown0 /* [in] [unique] */,
					     struct lsa_String *backup_logname /* [in] [ref] */,
					     uint32_t major_version /* [in]  */,
					     uint32_t minor_version /* [in]  */,
					     struct policy_handle *handle /* [out] [ref] */)
{
	struct eventlog_OpenBackupEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.unknown0 = unknown0;
	r.in.backup_logname = backup_logname;
	r.in.major_version = major_version;
	r.in.minor_version = minor_version;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenBackupEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENBACKUPEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenBackupEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_ReadEventLogW_state {
	struct eventlog_ReadEventLogW orig;
	struct eventlog_ReadEventLogW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ReadEventLogW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ReadEventLogW_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct policy_handle *_handle /* [in] [ref] */,
						      uint32_t _flags /* [in]  */,
						      uint32_t _offset /* [in]  */,
						      uint32_t _number_of_bytes /* [in] [range(0,0x7FFFF)] */,
						      uint8_t *_data /* [out] [ref,size_is(number_of_bytes)] */,
						      uint32_t *_sent_size /* [out] [ref] */,
						      uint32_t *_real_size /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ReadEventLogW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ReadEventLogW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.flags = _flags;
	state->orig.in.offset = _offset;
	state->orig.in.number_of_bytes = _number_of_bytes;

	/* Out parameters */
	state->orig.out.data = _data;
	state->orig.out.sent_size = _sent_size;
	state->orig.out.real_size = _real_size;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReadEventLogW, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_ReadEventLogW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_READEVENTLOGW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ReadEventLogW_done, req);
	return req;
}

static void rpccli_eventlog_ReadEventLogW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ReadEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReadEventLogW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	memcpy(state->orig.out.data, state->tmp.out.data, state->tmp.in.number_of_bytes * sizeof(*state->orig.out.data));
	*state->orig.out.sent_size = *state->tmp.out.sent_size;
	*state->orig.out.real_size = *state->tmp.out.real_size;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReadEventLogW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ReadEventLogW_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_eventlog_ReadEventLogW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReadEventLogW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ReadEventLogW(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */,
				       uint32_t flags /* [in]  */,
				       uint32_t offset /* [in]  */,
				       uint32_t number_of_bytes /* [in] [range(0,0x7FFFF)] */,
				       uint8_t *data /* [out] [ref,size_is(number_of_bytes)] */,
				       uint32_t *sent_size /* [out] [ref] */,
				       uint32_t *real_size /* [out] [ref] */)
{
	struct eventlog_ReadEventLogW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.flags = flags;
	r.in.offset = offset;
	r.in.number_of_bytes = number_of_bytes;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReadEventLogW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_READEVENTLOGW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReadEventLogW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(data, r.out.data, r.in.number_of_bytes * sizeof(*data));
	*sent_size = *r.out.sent_size;
	*real_size = *r.out.real_size;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_ReportEventW_state {
	struct eventlog_ReportEventW orig;
	struct eventlog_ReportEventW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ReportEventW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ReportEventW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli,
						     struct policy_handle *_handle /* [in] [ref] */,
						     time_t _timestamp /* [in]  */,
						     enum eventlogEventTypes _event_type /* [in]  */,
						     uint16_t _event_category /* [in]  */,
						     uint32_t _event_id /* [in]  */,
						     uint16_t _num_of_strings /* [in] [range(0,256)] */,
						     uint32_t _data_size /* [in] [range(0,0x3FFFF)] */,
						     struct lsa_String *_servername /* [in] [ref] */,
						     struct dom_sid *_user_sid /* [in] [unique] */,
						     struct lsa_String **_strings /* [in] [unique,size_is(num_of_strings)] */,
						     uint8_t *_data /* [in] [unique,size_is(data_size)] */,
						     uint16_t _flags /* [in]  */,
						     uint32_t *_record_number /* [in,out] [unique] */,
						     time_t *_time_written /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ReportEventW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ReportEventW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.timestamp = _timestamp;
	state->orig.in.event_type = _event_type;
	state->orig.in.event_category = _event_category;
	state->orig.in.event_id = _event_id;
	state->orig.in.num_of_strings = _num_of_strings;
	state->orig.in.data_size = _data_size;
	state->orig.in.servername = _servername;
	state->orig.in.user_sid = _user_sid;
	state->orig.in.strings = _strings;
	state->orig.in.data = _data;
	state->orig.in.flags = _flags;
	state->orig.in.record_number = _record_number;
	state->orig.in.time_written = _time_written;

	/* Out parameters */
	state->orig.out.record_number = _record_number;
	state->orig.out.time_written = _time_written;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventW, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_ReportEventW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_REPORTEVENTW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ReportEventW_done, req);
	return req;
}

static void rpccli_eventlog_ReportEventW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ReportEventW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReportEventW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.record_number && state->tmp.out.record_number) {
		*state->orig.out.record_number = *state->tmp.out.record_number;
	}
	if (state->orig.out.time_written && state->tmp.out.time_written) {
		*state->orig.out.time_written = *state->tmp.out.time_written;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ReportEventW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct rpccli_eventlog_ReportEventW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReportEventW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ReportEventW(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      time_t timestamp /* [in]  */,
				      enum eventlogEventTypes event_type /* [in]  */,
				      uint16_t event_category /* [in]  */,
				      uint32_t event_id /* [in]  */,
				      uint16_t num_of_strings /* [in] [range(0,256)] */,
				      uint32_t data_size /* [in] [range(0,0x3FFFF)] */,
				      struct lsa_String *servername /* [in] [ref] */,
				      struct dom_sid *user_sid /* [in] [unique] */,
				      struct lsa_String **strings /* [in] [unique,size_is(num_of_strings)] */,
				      uint8_t *data /* [in] [unique,size_is(data_size)] */,
				      uint16_t flags /* [in]  */,
				      uint32_t *record_number /* [in,out] [unique] */,
				      time_t *time_written /* [in,out] [unique] */)
{
	struct eventlog_ReportEventW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.timestamp = timestamp;
	r.in.event_type = event_type;
	r.in.event_category = event_category;
	r.in.event_id = event_id;
	r.in.num_of_strings = num_of_strings;
	r.in.data_size = data_size;
	r.in.servername = servername;
	r.in.user_sid = user_sid;
	r.in.strings = strings;
	r.in.data = data;
	r.in.flags = flags;
	r.in.record_number = record_number;
	r.in.time_written = time_written;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REPORTEVENTW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (record_number && r.out.record_number) {
		*record_number = *r.out.record_number;
	}
	if (time_written && r.out.time_written) {
		*time_written = *r.out.time_written;
	}

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_ClearEventLogA_state {
	struct eventlog_ClearEventLogA orig;
	struct eventlog_ClearEventLogA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ClearEventLogA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ClearEventLogA_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ClearEventLogA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ClearEventLogA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ClearEventLogA, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_CLEAREVENTLOGA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ClearEventLogA_done, req);
	return req;
}

static void rpccli_eventlog_ClearEventLogA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ClearEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ClearEventLogA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ClearEventLogA, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ClearEventLogA_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     NTSTATUS *result)
{
	struct rpccli_eventlog_ClearEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ClearEventLogA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ClearEventLogA(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct eventlog_ClearEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ClearEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_CLEAREVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ClearEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_BackupEventLogA_state {
	struct eventlog_BackupEventLogA orig;
	struct eventlog_BackupEventLogA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_BackupEventLogA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_BackupEventLogA_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_BackupEventLogA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_BackupEventLogA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_BackupEventLogA, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_BACKUPEVENTLOGA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_BackupEventLogA_done, req);
	return req;
}

static void rpccli_eventlog_BackupEventLogA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_BackupEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_BackupEventLogA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_BackupEventLogA, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_BackupEventLogA_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      NTSTATUS *result)
{
	struct rpccli_eventlog_BackupEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_BackupEventLogA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_BackupEventLogA(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx)
{
	struct eventlog_BackupEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_BackupEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_BACKUPEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_BackupEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_OpenEventLogA_state {
	struct eventlog_OpenEventLogA orig;
	struct eventlog_OpenEventLogA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_OpenEventLogA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_OpenEventLogA_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_OpenEventLogA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_OpenEventLogA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenEventLogA, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_OPENEVENTLOGA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_OpenEventLogA_done, req);
	return req;
}

static void rpccli_eventlog_OpenEventLogA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_OpenEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenEventLogA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenEventLogA, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_OpenEventLogA_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_eventlog_OpenEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenEventLogA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_OpenEventLogA(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct eventlog_OpenEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_RegisterEventSourceA_state {
	struct eventlog_RegisterEventSourceA orig;
	struct eventlog_RegisterEventSourceA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_RegisterEventSourceA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_RegisterEventSourceA_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_RegisterEventSourceA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_RegisterEventSourceA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterEventSourceA, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_REGISTEREVENTSOURCEA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_RegisterEventSourceA_done, req);
	return req;
}

static void rpccli_eventlog_RegisterEventSourceA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_RegisterEventSourceA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_RegisterEventSourceA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterEventSourceA, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_RegisterEventSourceA_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   NTSTATUS *result)
{
	struct rpccli_eventlog_RegisterEventSourceA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_RegisterEventSourceA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_RegisterEventSourceA(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx)
{
	struct eventlog_RegisterEventSourceA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterEventSourceA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REGISTEREVENTSOURCEA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterEventSourceA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_OpenBackupEventLogA_state {
	struct eventlog_OpenBackupEventLogA orig;
	struct eventlog_OpenBackupEventLogA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_OpenBackupEventLogA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_OpenBackupEventLogA_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_OpenBackupEventLogA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_OpenBackupEventLogA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenBackupEventLogA, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_OPENBACKUPEVENTLOGA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_OpenBackupEventLogA_done, req);
	return req;
}

static void rpccli_eventlog_OpenBackupEventLogA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_OpenBackupEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenBackupEventLogA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenBackupEventLogA, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_OpenBackupEventLogA_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  NTSTATUS *result)
{
	struct rpccli_eventlog_OpenBackupEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_OpenBackupEventLogA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_OpenBackupEventLogA(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx)
{
	struct eventlog_OpenBackupEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_OpenBackupEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_OPENBACKUPEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_OpenBackupEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_ReadEventLogA_state {
	struct eventlog_ReadEventLogA orig;
	struct eventlog_ReadEventLogA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ReadEventLogA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ReadEventLogA_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ReadEventLogA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ReadEventLogA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReadEventLogA, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_READEVENTLOGA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ReadEventLogA_done, req);
	return req;
}

static void rpccli_eventlog_ReadEventLogA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ReadEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReadEventLogA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReadEventLogA, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ReadEventLogA_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_eventlog_ReadEventLogA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReadEventLogA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ReadEventLogA(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct eventlog_ReadEventLogA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReadEventLogA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_READEVENTLOGA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReadEventLogA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_ReportEventA_state {
	struct eventlog_ReportEventA orig;
	struct eventlog_ReportEventA tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ReportEventA_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ReportEventA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ReportEventA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ReportEventA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventA, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_REPORTEVENTA,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ReportEventA_done, req);
	return req;
}

static void rpccli_eventlog_ReportEventA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ReportEventA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReportEventA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventA, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ReportEventA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   NTSTATUS *result)
{
	struct rpccli_eventlog_ReportEventA_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReportEventA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ReportEventA(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct eventlog_ReportEventA r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventA, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REPORTEVENTA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventA, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_RegisterClusterSvc_state {
	struct eventlog_RegisterClusterSvc orig;
	struct eventlog_RegisterClusterSvc tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_RegisterClusterSvc_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_RegisterClusterSvc_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_RegisterClusterSvc_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_RegisterClusterSvc_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterClusterSvc, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_REGISTERCLUSTERSVC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_RegisterClusterSvc_done, req);
	return req;
}

static void rpccli_eventlog_RegisterClusterSvc_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_RegisterClusterSvc_state *state = tevent_req_data(
		req, struct rpccli_eventlog_RegisterClusterSvc_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterClusterSvc, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_RegisterClusterSvc_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct rpccli_eventlog_RegisterClusterSvc_state *state = tevent_req_data(
		req, struct rpccli_eventlog_RegisterClusterSvc_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_RegisterClusterSvc(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx)
{
	struct eventlog_RegisterClusterSvc r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_RegisterClusterSvc, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REGISTERCLUSTERSVC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_RegisterClusterSvc, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_DeregisterClusterSvc_state {
	struct eventlog_DeregisterClusterSvc orig;
	struct eventlog_DeregisterClusterSvc tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_DeregisterClusterSvc_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_DeregisterClusterSvc_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_DeregisterClusterSvc_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_DeregisterClusterSvc_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_DeregisterClusterSvc, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_DEREGISTERCLUSTERSVC,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_DeregisterClusterSvc_done, req);
	return req;
}

static void rpccli_eventlog_DeregisterClusterSvc_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_DeregisterClusterSvc_state *state = tevent_req_data(
		req, struct rpccli_eventlog_DeregisterClusterSvc_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_DeregisterClusterSvc, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_DeregisterClusterSvc_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   NTSTATUS *result)
{
	struct rpccli_eventlog_DeregisterClusterSvc_state *state = tevent_req_data(
		req, struct rpccli_eventlog_DeregisterClusterSvc_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_DeregisterClusterSvc(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx)
{
	struct eventlog_DeregisterClusterSvc r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_DeregisterClusterSvc, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_DEREGISTERCLUSTERSVC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_DeregisterClusterSvc, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_WriteClusterEvents_state {
	struct eventlog_WriteClusterEvents orig;
	struct eventlog_WriteClusterEvents tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_WriteClusterEvents_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_WriteClusterEvents_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct rpc_pipe_client *cli)
{
	struct tevent_req *req;
	struct rpccli_eventlog_WriteClusterEvents_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_WriteClusterEvents_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_WriteClusterEvents, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_WRITECLUSTEREVENTS,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_WriteClusterEvents_done, req);
	return req;
}

static void rpccli_eventlog_WriteClusterEvents_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_WriteClusterEvents_state *state = tevent_req_data(
		req, struct rpccli_eventlog_WriteClusterEvents_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_WriteClusterEvents, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_WriteClusterEvents_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 NTSTATUS *result)
{
	struct rpccli_eventlog_WriteClusterEvents_state *state = tevent_req_data(
		req, struct rpccli_eventlog_WriteClusterEvents_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_WriteClusterEvents(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx)
{
	struct eventlog_WriteClusterEvents r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_WriteClusterEvents, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_WRITECLUSTEREVENTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_WriteClusterEvents, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_GetLogInformation_state {
	struct eventlog_GetLogInformation orig;
	struct eventlog_GetLogInformation tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_GetLogInformation_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_GetLogInformation_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct rpc_pipe_client *cli,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _level /* [in]  */,
							  uint8_t *_buffer /* [out] [ref,size_is(buf_size)] */,
							  uint32_t _buf_size /* [in] [range(0,1024)] */,
							  uint32_t *_bytes_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_GetLogInformation_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_GetLogInformation_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.buf_size = _buf_size;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.bytes_needed = _bytes_needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetLogInformation, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_GetLogInformation_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_GETLOGINFORMATION,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_GetLogInformation_done, req);
	return req;
}

static void rpccli_eventlog_GetLogInformation_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_GetLogInformation_state *state = tevent_req_data(
		req, struct rpccli_eventlog_GetLogInformation_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	memcpy(state->orig.out.buffer, state->tmp.out.buffer, state->tmp.in.buf_size * sizeof(*state->orig.out.buffer));
	*state->orig.out.bytes_needed = *state->tmp.out.bytes_needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetLogInformation, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_GetLogInformation_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						NTSTATUS *result)
{
	struct rpccli_eventlog_GetLogInformation_state *state = tevent_req_data(
		req, struct rpccli_eventlog_GetLogInformation_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_GetLogInformation(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t level /* [in]  */,
					   uint8_t *buffer /* [out] [ref,size_is(buf_size)] */,
					   uint32_t buf_size /* [in] [range(0,1024)] */,
					   uint32_t *bytes_needed /* [out] [ref] */)
{
	struct eventlog_GetLogInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.buf_size = buf_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_GetLogInformation, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_GETLOGINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_GetLogInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	memcpy(buffer, r.out.buffer, r.in.buf_size * sizeof(*buffer));
	*bytes_needed = *r.out.bytes_needed;

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_FlushEventLog_state {
	struct eventlog_FlushEventLog orig;
	struct eventlog_FlushEventLog tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_FlushEventLog_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_FlushEventLog_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct rpc_pipe_client *cli,
						      struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_FlushEventLog_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_FlushEventLog_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_FlushEventLog, &state->orig);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_FLUSHEVENTLOG,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_FlushEventLog_done, req);
	return req;
}

static void rpccli_eventlog_FlushEventLog_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_FlushEventLog_state *state = tevent_req_data(
		req, struct rpccli_eventlog_FlushEventLog_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_FlushEventLog, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_FlushEventLog_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    NTSTATUS *result)
{
	struct rpccli_eventlog_FlushEventLog_state *state = tevent_req_data(
		req, struct rpccli_eventlog_FlushEventLog_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_FlushEventLog(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *handle /* [in] [ref] */)
{
	struct eventlog_FlushEventLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_FlushEventLog, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_FLUSHEVENTLOG,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_FlushEventLog, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

struct rpccli_eventlog_ReportEventAndSourceW_state {
	struct eventlog_ReportEventAndSourceW orig;
	struct eventlog_ReportEventAndSourceW tmp;
	TALLOC_CTX *out_mem_ctx;
	NTSTATUS (*dispatch_recv)(struct tevent_req *req, TALLOC_CTX *mem_ctx);
};

static void rpccli_eventlog_ReportEventAndSourceW_done(struct tevent_req *subreq);

struct tevent_req *rpccli_eventlog_ReportEventAndSourceW_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct rpc_pipe_client *cli,
							      struct policy_handle *_handle /* [in] [ref] */,
							      time_t _timestamp /* [in]  */,
							      enum eventlogEventTypes _event_type /* [in]  */,
							      uint16_t _event_category /* [in]  */,
							      uint32_t _event_id /* [in]  */,
							      struct lsa_String *_sourcename /* [in] [ref] */,
							      uint16_t _num_of_strings /* [in] [range(0,256)] */,
							      uint32_t _data_size /* [in] [range(0,0x3FFFF)] */,
							      struct lsa_String *_servername /* [in] [ref] */,
							      struct dom_sid *_user_sid /* [in] [unique] */,
							      struct lsa_String **_strings /* [in] [unique,size_is(num_of_strings)] */,
							      uint8_t *_data /* [in] [unique,size_is(data_size)] */,
							      uint16_t _flags /* [in]  */,
							      uint32_t *_record_number /* [in,out] [unique] */,
							      time_t *_time_written /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct rpccli_eventlog_ReportEventAndSourceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct rpccli_eventlog_ReportEventAndSourceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;
	state->dispatch_recv = cli->dispatch_recv;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.timestamp = _timestamp;
	state->orig.in.event_type = _event_type;
	state->orig.in.event_category = _event_category;
	state->orig.in.event_id = _event_id;
	state->orig.in.sourcename = _sourcename;
	state->orig.in.num_of_strings = _num_of_strings;
	state->orig.in.data_size = _data_size;
	state->orig.in.servername = _servername;
	state->orig.in.user_sid = _user_sid;
	state->orig.in.strings = _strings;
	state->orig.in.data = _data;
	state->orig.in.flags = _flags;
	state->orig.in.record_number = _record_number;
	state->orig.in.time_written = _time_written;

	/* Out parameters */
	state->orig.out.record_number = _record_number;
	state->orig.out.time_written = _time_written;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventAndSourceW, &state->orig);
	}

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "rpccli_eventlog_ReportEventAndSourceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = cli->dispatch_send(state, ev, cli,
				    &ndr_table_eventlog,
				    NDR_EVENTLOG_REPORTEVENTANDSOURCEW,
				    &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, rpccli_eventlog_ReportEventAndSourceW_done, req);
	return req;
}

static void rpccli_eventlog_ReportEventAndSourceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct rpccli_eventlog_ReportEventAndSourceW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReportEventAndSourceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = state->dispatch_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.record_number && state->tmp.out.record_number) {
		*state->orig.out.record_number = *state->tmp.out.record_number;
	}
	if (state->orig.out.time_written && state->tmp.out.time_written) {
		*state->orig.out.time_written = *state->tmp.out.time_written;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventAndSourceW, &state->orig);
	}

	tevent_req_done(req);
}

NTSTATUS rpccli_eventlog_ReportEventAndSourceW_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    NTSTATUS *result)
{
	struct rpccli_eventlog_ReportEventAndSourceW_state *state = tevent_req_data(
		req, struct rpccli_eventlog_ReportEventAndSourceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possbile out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS rpccli_eventlog_ReportEventAndSourceW(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       time_t timestamp /* [in]  */,
					       enum eventlogEventTypes event_type /* [in]  */,
					       uint16_t event_category /* [in]  */,
					       uint32_t event_id /* [in]  */,
					       struct lsa_String *sourcename /* [in] [ref] */,
					       uint16_t num_of_strings /* [in] [range(0,256)] */,
					       uint32_t data_size /* [in] [range(0,0x3FFFF)] */,
					       struct lsa_String *servername /* [in] [ref] */,
					       struct dom_sid *user_sid /* [in] [unique] */,
					       struct lsa_String **strings /* [in] [unique,size_is(num_of_strings)] */,
					       uint8_t *data /* [in] [unique,size_is(data_size)] */,
					       uint16_t flags /* [in]  */,
					       uint32_t *record_number /* [in,out] [unique] */,
					       time_t *time_written /* [in,out] [unique] */)
{
	struct eventlog_ReportEventAndSourceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.timestamp = timestamp;
	r.in.event_type = event_type;
	r.in.event_category = event_category;
	r.in.event_id = event_id;
	r.in.sourcename = sourcename;
	r.in.num_of_strings = num_of_strings;
	r.in.data_size = data_size;
	r.in.servername = servername;
	r.in.user_sid = user_sid;
	r.in.strings = strings;
	r.in.data = data;
	r.in.flags = flags;
	r.in.record_number = record_number;
	r.in.time_written = time_written;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(eventlog_ReportEventAndSourceW, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_eventlog,
				NDR_EVENTLOG_REPORTEVENTANDSOURCEW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(eventlog_ReportEventAndSourceW, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (record_number && r.out.record_number) {
		*record_number = *r.out.record_number;
	}
	if (time_written && r.out.time_written) {
		*time_written = *r.out.time_written;
	}

	/* Return result */
	return r.out.result;
}

