#include "config_xor.h"

#include <stdio.h>


#if defined (SH_WITH_CLIENT) || defined (SH_STANDALONE) 

#include "sh_modules.h"

#include "sh_utmp.h"
#include "sh_mounts.h"
#include "sh_userfiles.h"
#include "sh_kern.h"
#include "sh_suidchk.h"

sh_mtype modList[] = {
#ifdef SH_USE_UTMP
  {
    N_("UTMP"),
    0,
    sh_utmp_init,
    sh_utmp_timer,
    sh_utmp_check,
    sh_utmp_end,
    sh_utmp_null,

    N_("[Utmp]"),
    sh_utmp_table,
  },
#endif

#ifdef SH_USE_MOUNTS
  {
    N_("MOUNTS"),
    0,
    sh_mounts_init,
    sh_mounts_timer,
    sh_mounts_check,
    sh_mounts_cleanup,
    sh_mounts_reconf,

    N_("[Mounts]"),
    sh_mounts_table,
  },
#endif

#ifdef SH_USE_USERFILES
  {
    N_("USERFILES"),
    0,
    sh_userfiles_init,
    sh_userfiles_timer,
    sh_userfiles_check,
    sh_userfiles_cleanup,
    sh_userfiles_reconf,

    N_("[UserFiles]"),
    sh_userfiles_table,
  },
#endif

#ifdef SH_USE_KERN
  {
    N_("KERNEL"),
    0,
    sh_kern_init,
    sh_kern_timer,
    sh_kern_check,
    sh_kern_end,
    sh_kern_null,

    N_("[Kernel]"),
    sh_kern_table,
  },
#endif
#ifdef SH_USE_SUIDCHK
  {
    N_("SUIDCHECK"),
    0,
    sh_suidchk_init,
    sh_suidchk_timer,
    sh_suidchk_check,
    sh_suidchk_end,
    sh_suidchk_free_schedule,

    N_("[SuidCheck]"),
    sh_suidchk_table,
  },
#endif
  {
    NULL,
    0,

    NULL,
    NULL,
    NULL,
    NULL,
    NULL,

    NULL,
    NULL,
  },
};

#endif

