#!/usr/bin/env ruby
#
# Samizdat moderation log
#
#   Copyright (c) 2002-2005  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

request do |session|
  t = session.template
  skip, = session.params %w[skip]
  skip = skip.to_i

  title = _('Moderation Log') + (skip > 0 ? sprintf(_(', page %s'), skip + 1) : '')

  log = db.select_all(
    %{SELECT action_date, moderator, action, resource FROM moderation
    ORDER BY action_date DESC LIMIT #{limit_page} OFFSET #{limit_page * skip}}
  ).collect {|date, moderator, action, resource|
    [
      t.format_date(date),
      t.resource_href(moderator,
        Resource.new(session, moderator).render(:title)),
      action,
      Resource.new(session, resource).render(:list)
    ]
  }
  page = t.table([[_('Date'), _('Moderator'), _('Action'), _('Resource')]] +
    log, t.nav(log.size < limit_page, skip + 1))

  t.page(title, page)
end
