#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc AnnulusDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # variables
    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)

    set marker($frame,$id,method) dist

    # base
    MarkerBaseAnnulusDialog $frame $id 275 150

    # menus
    MarkerBaseDistMenu $frame $id radius Radius AnnulusDistCB dcoord dformat
    MarkerBaseAnnulusMethodMenu $frame $id

    # callbacks
    $frame marker $id callback edit AnnulusEditCB $frame
    $frame marker $id callback end edit AnnulusEditCB $frame

    # Radius
    label $w.ref.left.bottom.f.innerTitle -text "Inner"
    label $w.ref.left.bottom.f.outerTitle -text "Outer"
    label $w.ref.left.bottom.f.radiusTitle -text "Radius"
    entry $w.ref.left.bottom.f.inner -textvariable marker($frame,$id,inner) \
	-width 13
    entry $w.ref.left.bottom.f.outer -textvariable marker($frame,$id,outer) \
	-width 13
    label $w.ref.left.bottom.f.radiusformat \
	-textvariable marker($frame,$id,dlabel) -relief groove -width 9 -padx 4
    label $w.ref.left.bottom.f.annuliTitle -text "Annuli"
    entry $w.ref.left.bottom.f.annuli -textvariable marker($frame,$id,annuli) \
	-width 13

    grid x $w.ref.left.bottom.f.innerTitle $w.ref.left.bottom.f.outerTitle \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.radiusTitle $w.ref.left.bottom.f.inner \
	$w.ref.left.bottom.f.outer $w.ref.left.bottom.f.radiusformat \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.annuliTitle $w.ref.left.bottom.f.annuli \
	-padx 4 -sticky w

    # Right
    frame $w.ref.right.title
    frame $w.ref.right.value
    pack $w.ref.right.title $w.ref.right.value -side top -padx 4 -pady 4

    label $w.ref.right.title.title -text "Radius"
    label $w.ref.right.title.radiusformat \
	-textvariable marker($frame,$id,dlabel) -relief groove -width 9 -padx 4

    grid $w.ref.right.title.title $w.ref.right.title.radiusformat \
	-padx 4 -sticky news

    set txtscr $w.ref.right.value.yscroll
    set marker($frame,$id,annulitxt) $w.ref.right.value.txt
    text $marker($frame,$id,annulitxt) -height 10 -width 15 -wrap none \
	-font {courier 12} -yscrollcommand "$txtscr set"
    scrollbar $txtscr -command [list $marker($frame,$id,annulitxt) yview] \
	-orient vertical

    grid $marker($frame,$id,annulitxt) $txtscr -sticky news

    # init - do this last
    AnnulusDistCB $frame $id
}

# actions

proc AnnulusClose {frame id} {
    $frame marker $id delete callback edit AnnulusEditCB
    $frame marker $id delete callback end edit AnnulusEditCB
    MarkerBaseCenterClose $frame $id
}

proc AnnulusApply {frame id} {
    global marker

    set levels ""
    regsub -all "\n" "[$marker($frame,$id,annulitxt) get 1.0 end]" " " levels
    # and trim any trailing spaces
    set levels [string trimright $levels " "]

    if {$levels != ""} {
	$frame marker $id annulus radius "\{$levels\}" \
	    $marker($frame,$id,dcoord) $marker($frame,$id,dformat)
    }

    MarkerBaseCenterApply $frame $id
}

proc AnnulusGenerate {frame id} {
    MarkerBaseAnnulusGenerateCircle $frame $id
}

# callbacks

proc AnnulusCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id
}

proc AnnulusEditCB {frame id} {
    global marker
    
    set t [$frame get marker $id annulus radius \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]

    set last [expr [llength $t]-1]
    set marker($frame,$id,inner) [lindex $t 0]
    set marker($frame,$id,outer) [lindex $t $last]
    set marker($frame,$id,annuli) $last

    $marker($frame,$id,annulitxt) delete 1.0 end
    $marker($frame,$id,annulitxt) insert end "$t"
}

proc AnnulusDistCB {frame id} {
    MarkerBaseDistCB $frame $id
    AnnulusEditCB $frame $id
}

proc AnnulusDefaultDialog {} {
    global marker
    global ed

    set w ".annulus"

    set ed(ok) 0
    set ed(inner) $marker(annulus,inner)
    set ed(outer) $marker(annulus,outer)
    set ed(annuli) $marker(annulus,annuli)

    DialogCreate $w "Default Annulus" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.innerTitle -text "Inner"
    label $w.ed.outerTitle -text "Outer"
    label $w.ed.radiusTitle -text "Radius"
    entry $w.ed.inner -textvariable ed(inner) -width 10
    entry $w.ed.outer -textvariable ed(outer) -width 10
    label $w.ed.unit -text "image" -relief groove -width 8
    label $w.ed.annuliTitle -text "Annuli"
    entry $w.ed.annuli -textvariable ed(annuli) -width 10
    
    grid x $w.ed.innerTitle $w.ed.outerTitle -padx 4 -sticky w
    grid $w.ed.radiusTitle $w.ed.inner $w.ed.outer $w.ed.unit -padx 4 -sticky w
    grid $w.ed.annuliTitle $w.ed.annuli -padx 4 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.inner select range 0 end
    DialogWait $w ed(ok) $w.ed.inner
    DialogDismiss $w

    if {$ed(ok)} {
	set marker(annulus,inner) $ed(inner)
	set marker(annulus,outer) $ed(outer)
	set marker(annulus,annuli) $ed(annuli)
    }

    unset ed
}
