#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc BpandaDialog {frame id} {
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # base panda rect dialog
    MarkerBasePandaRectDialog $frame $id 275 150
}

# actions

proc BpandaClose {frame id} {
    MarkerBasePandaRectClose $frame $id
}

proc BpandaApply {frame id} {
    MarkerBasePandaRectApply $frame $id
}

proc BpandaGenerate {frame id} {
    MarkerBaseAnnulusGenerateBox $frame $id
    MarkerBasePandaGenerateAngles $frame $id
}

# callbacks

proc BpandaCoordCB {frame id} {
    MarkerBasePandaRectCoordCB $frame $id
}

proc BpandaEditCB {frame id} {
    MarkerBasePandaRectEditCB $frame $id
}

proc BpandaDistCB {frame id} {
    MarkerBasePandaDistCB $frame $id
}

proc BpandaDefaultDialog {} {
    MarkerBasePandaRectDefaultDialog bpanda
}
