#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CATSymDialog {parent} {
    upvar #0 $parent pvar
    global $parent

    set varname $pvar(symdl)
    upvar #0 $varname var
    global $varname

    global ds9
    global menu
    global catsym

    # main dialog
    set var(top) ".${varname}"
    set var(mb) ".${varname}mb"

    if [winfo exists $var(top)] {
	raise $var(top)
	return
    }

    # variables
    set var(parent) $parent
    set var(symdb) $pvar(symdb)

    global $var(symdb)
    set var(row) 1

    set var(condition) {}
    set var(shape) {}
    set var(color) {}
    set var(text) {}
    set var(size) {}
    set var(size2) {}
    set var(units) {}
    set var(angle) {}

    # top
    set w $var(top)
    set t "Symbol Editor"

    # create the window
    toplevel $w -colormap $ds9(main)
    wm title $w $t
    wm iconname $w $t
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW "CATSymDestroy $varname"

    # menu
    $w configure -menu $var(mb)
    menu $var(mb) -tearoff 0

    # menu
    $var(mb) add cascade -label File -menu $var(mb).file
    menu $var(mb).file -tearoff 0 -selectcolor $menu(selectcolor)
    $var(mb).file add command -label Apply \
	-command "CATSymApply $varname"
    $var(mb).file add separator
    $var(mb).file add command -label Save \
	-command "CATSymSave $varname"
    $var(mb).file add command -label Load \
	-command "CATSymLoad $varname"
    $var(mb).file add separator
    $var(mb).file add command -label Add \
	-command "CATSymAdd $varname"
    $var(mb).file add command -label Remove \
	-command "CATSymRemove $varname"
    $var(mb).file add separator
    $var(mb).file add command -label Close \
	-command "CATSymDestroy $varname"

    # dialog
    frame $w.param -relief groove -borderwidth 2
    frame $w.tbl -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2

    pack $w.buttons -side bottom -fill x -ipadx 4 -ipady 4
    pack $w.param -side top -fill x -ipadx 4 -ipady 4
    pack $w.tbl -side top -fill both -expand true -ipadx 4 -ipady 4

    # param
    frame $w.param.f
    pack $w.param.f -side left

    label $w.param.f.tcondition -text "If" 
    entry $w.param.f.condition -textvariable ${varname}(condition) -width 40
    button $w.param.f.bcondition -text "Edit" \
	-command "CATEditDialog $varname condition $pvar(catdb)"

    label $w.param.f.tthen -text "then" 

    label $w.param.f.tshape -text "Shape" 
    menubutton $w.param.f.shape -textvariable ${varname}(shape) \
	-menu $w.param.f.shape.m -relief raised -bd 2 -width 15

    menu $w.param.f.shape.m -tearoff 0
    $w.param.f.shape.m add command -label {circle point} \
	-command "global $varname;set ${varname}(shape) {circle point}"
    $w.param.f.shape.m add command -label {box point} \
	-command "global $varname;set ${varname}(shape) {box point}"
    $w.param.f.shape.m add command -label {diamond point} \
	-command "global $varname;set ${varname}(shape) {diamond point}"
    $w.param.f.shape.m add command -label {cross point} \
	-command "global $varname;set ${varname}(shape) {cross point}"
    $w.param.f.shape.m add command -label {x point} \
	-command "global $varname;set ${varname}(shape) {x point}"
    $w.param.f.shape.m add command -label {arrow point} \
	-command "global $varname;set ${varname}(shape) {arrow point}"
    $w.param.f.shape.m add command -label {boxcircle point} \
	-command "global $varname;set ${varname}(shape) {boxcircle point}"
    $w.param.f.shape.m add separator
    $w.param.f.shape.m add command -label circle \
	-command "global $varname;set ${varname}(shape) circle"
    $w.param.f.shape.m add command -label ellipse \
	-command "global $varname;set ${varname}(shape) ellipse"
    $w.param.f.shape.m add command -label box \
	-command "global $varname;set ${varname}(shape) box"
    $w.param.f.shape.m add command -label text \
	-command "global $varname;set ${varname}(shape) text"

    label $w.param.f.tcolor -text "Color" 
    menubutton $w.param.f.color -textvariable ${varname}(color) \
	-menu $w.param.f.color.m -relief raised -bd 2 -width 15

    menu $w.param.f.color.m -tearoff 0
    $w.param.f.color.m add command -label white \
	-command "global $varname;set ${varname}(color) white"
    $w.param.f.color.m add command -label black \
	-command "global $varname;set ${varname}(color) black"
    $w.param.f.color.m add command -label red \
	-command "global $varname;set ${varname}(color) red"
    $w.param.f.color.m add command -label green \
	-command "global $varname;set ${varname}(color) green"
    $w.param.f.color.m add command -label blue \
	-command "global $varname;set ${varname}(color) blue"
    $w.param.f.color.m add command -label cyan \
	-command "global $varname;set ${varname}(color) cyan"
    $w.param.f.color.m add command -label magenta \
	-command "global $varname;set ${varname}(color) magenta"
    $w.param.f.color.m add command -label yellow \
	-command "global $varname;set ${varname}(color) yellow"

    label $w.param.f.ttext -text "Text" 
    entry $w.param.f.text -textvariable ${varname}(text) -width 40
    button $w.param.f.btext -text "Edit" \
	-command "CATEditDialog $varname text  $pvar(catdb)"

    label $w.param.f.tsize -text "Size/Radius" 
    entry $w.param.f.size -textvariable ${varname}(size) -width 40
    button $w.param.f.bsize -text "Edit" \
	-command "CATEditDialog $varname size $pvar(catdb)"

    label $w.param.f.tsize2 -text "Size/Radius 2" 
    entry $w.param.f.size2 -textvariable ${varname}(size2) -width 40
    button $w.param.f.bsize2 -text "Edit" \
	-command "CATEditDialog $varname size2 $pvar(catdb)"

    label $w.param.f.tunits -text "Units" 
    menubutton $w.param.f.units -textvariable ${varname}(units) \
	-menu $w.param.f.units.m -relief raised -bd 2 -width 15

    menu $w.param.f.units.m -tearoff 0
    $w.param.f.units.m add command -label image \
	-command "global $varname;set ${varname}(units) image"
    $w.param.f.units.m add command -label physical \
	-command "global $varname;set ${varname}(units) physical"
    $w.param.f.units.m add command -label degrees \
	-command "global $varname;set ${varname}(units) degrees"
    $w.param.f.units.m add command -label arcmin \
	-command "global $varname;set ${varname}(units) arcmin"
    $w.param.f.units.m add command -label arcsec \
	-command "global $varname;set ${varname}(units) arcsec"

    label $w.param.f.tangle -text "Angle" 
    entry $w.param.f.angle -textvariable ${varname}(angle) -width 40
    button $w.param.f.bangle -text "Edit" \
	-command "CATEditDialog $varname angle $pvar(catdb)"

    grid $w.param.f.tcondition $w.param.f.condition $w.param.f.bcondition \
	-padx 4 -pady 1 -sticky w
    grid $w.param.f.tthen -padx 4 -pady 1 -sticky w
    grid $w.param.f.tshape $w.param.f.shape \
	-padx 4 -pady 1 -sticky w
    grid $w.param.f.tcolor $w.param.f.color \
	-padx 4 -pady 1 -sticky w
    grid $w.param.f.ttext $w.param.f.text $w.param.f.btext \
	-padx 4 -pady 1 -sticky w
    grid $w.param.f.tsize $w.param.f.size $w.param.f.bsize \
	-padx 4 -pady 1 -sticky w
    grid $w.param.f.tsize2 $w.param.f.size2 $w.param.f.bsize2 \
	-padx 4 -pady 1 -sticky w
    grid $w.param.f.tunits $w.param.f.units \
	-padx 4 -pady 1 -sticky w
    grid $w.param.f.tangle $w.param.f.angle $w.param.f.bangle \
	-padx 4 -pady 1 -sticky w

    # tbl
    set var(tbl) [table $var(top).tbl.t \
			  -state disabled \
			  -usecommand 0 \
			  -variable $var(symdb) \
			  -colorigin 1 \
			  -roworigin 0 \
			  -cols $catsym(mincols) \
			  -rows $catsym(minrows) \
			  -width -1 \
			  -height -1 \
			  -maxwidth 550 \
			  -maxheight 300 \
			  -titlerows 1 \
			  -xscrollcommand [list $var(top).tbl.xscroll set]\
			  -yscrollcommand [list $var(top).tbl.yscroll set]\
			  -selecttype row \
			  -selectmode single \
			  -browsecommand [list CATSymSelectCB $varname] \
			 ]

    scrollbar $var(top).tbl.yscroll -command [list $var(tbl) yview] \
	-orient vertical
    scrollbar $var(top).tbl.xscroll -command [list $var(tbl) xview] \
	-orient horizontal

    grid $var(tbl) $var(top).tbl.yscroll -sticky news
    grid $var(top).tbl.xscroll -stick news
    grid rowconfigure $var(top).tbl 0 -weight 1
    grid columnconfigure $var(top).tbl 0 -weight 1

    # buttons
    button $w.buttons.apply -text Apply -command "CATSymApply $varname"
    button $w.buttons.add -text Add -command "CATSymAdd $varname"
    button $w.buttons.remove -text Remove -command "CATSymRemove $varname"
    button $w.buttons.close -text Close -command "CATSymDestroy $varname"
    pack $w.buttons.apply $w.buttons.add $w.buttons.remove $w.buttons.close \
	-side left -padx 10 -expand true

    CATSymTable $varname

    # initialize
    if {$var(row) <= [starbase_nrows $var(symdb)]} {
	set var(condition) [starbase_get $var(symdb) $var(row) \
				[starbase_colnum $var(symdb) condition]]
	set var(shape) [starbase_get $var(symdb) $var(row) \
			    [starbase_colnum $var(symdb) shape]]
	set var(color) [starbase_get $var(symdb) $var(row) \
			    [starbase_colnum $var(symdb) color]]
	set var(text) [starbase_get $var(symdb) $var(row) \
			   [starbase_colnum $var(symdb) text]]
	set var(size) [starbase_get $var(symdb) $var(row) \
			   [starbase_colnum $var(symdb) size]]
	set var(size2) [starbase_get $var(symdb) $var(row) \
			    [starbase_colnum $var(symdb) size2]]
	set var(units) [starbase_get $var(symdb) $var(row) \
			    [starbase_colnum $var(symdb) units]]
	set var(angle) [starbase_get $var(symdb) $var(row) \
			    [starbase_colnum $var(symdb) angle]]
    }
    $var(tbl) selection set $var(row),1
}

proc CATSymDestroy {varname} {
    upvar #0 $varname var
    global $varname

    destroy $var(top)
    destroy $var(mb)

    catch {unset var}
}

proc CATSymApply {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)

    if {$var(row) != {}} {
	if {$var(row) <= [starbase_nrows $var(symdb)]} {
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) condition] $var(condition)
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) shape] $var(shape)
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) color] $var(color)
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) text] $var(text)
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) size] $var(size)
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) size2] $var(size2)
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) units] $var(units)
	    starbase_set $var(symdb) $var(row) \
		[starbase_colnum $var(symdb) angle] $var(angle)
	}
    }

    CATSymUpdate $varname
}

proc CATSymAdd {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)
    global cat

    set row [expr [starbase_nrows $var(symdb)]+1]
    starbase_rowins $var(symdb) $row
    starbase_set $var(symdb) $row \
	[starbase_colnum $var(symdb) shape] $cat(sym,shape)
    starbase_set $var(symdb) $row \
	[starbase_colnum $var(symdb) color] $cat(sym,color)
    starbase_set $var(symdb) $row \
	[starbase_colnum $var(symdb) units] $cat(sym,units)

    $var(tbl) selection clear all
    $var(tbl) selection set $row,1
    $var(tbl) see $row,1

    CATSymSelectCB $varname
    CATSymTable $varname
}

proc CATSymRemove {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)

    set ss "[$var(tbl) curselection]"
    set var(row) [string trim [lindex [split $ss ,] 0]]
    if {$var(row) != {}} {
	set nr [starbase_nrows $var(symdb)]
	if {$nr > 1 && $var(row) <= $nr} {
	    starbase_rowdel $var(symdb) $var(row)
	    set var(row) {}
	}
    }

    CATSymClear $varname
    CATSymTable $varname
}

proc CATSymSave {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)

    set fn [SaveFileDialog catsymfbox]
    if {$fn != {}} {
	starbase_write $var(symdb) $fn
    }
}

proc CATSymLoad {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)

    set fn [OpenFileDialog catsymfbox]
    if {$fn != {}} {
	catch {unset $var(symdb)}
	starbase_read $var(symdb) $fn

	CATSymUpdate $varname
    }
}

proc CATSymClear {varname} {
    upvar #0 $varname var
    global $varname

    $var(tbl) selection clear all

    set var(row) {}

    set var(condition) {}
    set var(shape) {}
    set var(color) {}
    set var(text) {}
    set var(size) {}
    set var(size2) {}
    set var(units) {}
    set var(angle) {}
}

# Support routines

proc CATSymDBInit {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)
    global cat

    catch {unset $var(symdb)}

    starbase_new $var(symdb) condition shape color text size size2 units angle
    starbase_rowins $var(symdb) 1
    starbase_set $var(symdb) 1 \
	[starbase_colnum $var(symdb) shape] $cat(sym,shape)
    starbase_set $var(symdb) 1 \
	[starbase_colnum $var(symdb) color] $cat(sym,color)
    starbase_set $var(symdb) 1 \
	[starbase_colnum $var(symdb) units] $cat(sym,units)
}

proc CATSymUpdate {varname} {
    upvar #0 $varname var
    global $varname

    CATPlot $var(parent)
}

proc CATSymTable {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)
    global catsym

    set nr [starbase_nrows $var(symdb)]
    set nc [starbase_ncols $var(symdb)]

    if { $nc > $catsym(mincols)} {
	$var(tbl) configure -cols $nc
    } else {
	$var(tbl) configure -cols $catsym(mincols)
    }

    if {$nr > $catsym(minrows)} {
	$var(tbl) configure -rows $nr
    } else {
	$var(tbl) configure -rows $catsym(minrows)
    }
}

proc CATSymSelectCB {varname} {
    upvar #0 $varname var
    global $varname
    global $var(symdb)

    set ss "[$var(tbl) curselection]"
    set var(row) [string trim [lindex [split $ss ,] 0]]
    if {$var(row) != {}} {
	if {$var(row) <= [starbase_nrows $var(symdb)]} {
	    set var(condition) [starbase_get $var(symdb) $var(row) \
				    [starbase_colnum $var(symdb) condition]]
	    set var(shape) [starbase_get $var(symdb) $var(row) \
				[starbase_colnum $var(symdb) shape]]
	    set var(color) [starbase_get $var(symdb) $var(row) \
				[starbase_colnum $var(symdb) color]]
	    set var(text) [starbase_get $var(symdb) $var(row) \
			       [starbase_colnum $var(symdb) text]]
	    set var(size) [starbase_get $var(symdb) $var(row) \
			       [starbase_colnum $var(symdb) size]]
	    set var(size2) [starbase_get $var(symdb) $var(row) \
				[starbase_colnum $var(symdb) size2]]
	    set var(units) [starbase_get $var(symdb) $var(row) \
				[starbase_colnum $var(symdb) units]]
	    set var(angle) [starbase_get $var(symdb) $var(row) \
				[starbase_colnum $var(symdb) angle]]
	    return
	}
    }

    CATSymClear $varname
}
