#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerBasePandaRectDialog {frame id width height} {
    global marker
    global ds9

    set w ".marker$id"
    set mb ".mb$id"

    # base panda dialog
    MarkerBasePandaDialog $frame $id $width $height
    set which $marker($frame,$id,which)

    # callbacks
    $frame marker $id callback rotate MarkerBaseCenterRotateCB $frame

    # Radius
    label $w.ref.left.bottom.f.majorTitle -text "Major"
    label $w.ref.left.bottom.f.minorTitle -text "Minor"

    label $w.ref.left.bottom.f.outerTitle -text "Outer Radius"
    entry $w.ref.left.bottom.f.radius1 \
	-textvariable marker($frame,$id,radius1) \
	-width 13 
    entry $w.ref.left.bottom.f.radius2 \
	-textvariable marker($frame,$id,radius2) \
	-width 13 
    label $w.ref.left.bottom.f.radiusformat \
	-textvariable marker($frame,$id,dlabel) -relief groove -width 9 -padx 4

    label $w.ref.left.bottom.f.innerTitle -text "Inner Radius"
    entry $w.ref.left.bottom.f.radius3 \
	-textvariable marker($frame,$id,radius3) -width 13 

    label $w.ref.left.bottom.f.annuliTitle -text "Annuli"
    entry $w.ref.left.bottom.f.annuli -textvariable marker($frame,$id,annuli) \
	-width 13

    grid x $w.ref.left.bottom.f.majorTitle $w.ref.left.bottom.f.minorTitle \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.outerTitle $w.ref.left.bottom.f.radius1 \
	$w.ref.left.bottom.f.radius2 $w.ref.left.bottom.f.radiusformat \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.innerTitle $w.ref.left.bottom.f.radius3 \
	-padx 4 -sticky w
    grid $w.ref.left.bottom.f.annuliTitle $w.ref.left.bottom.f.annuli \
	-padx 4 -sticky w

    # Angle
    label $w.ref.left.bottom.f.angleTitle -text "Angle"
    entry $w.ref.left.bottom.f.angle -textvariable marker($frame,$id,angle) \
	-width 13 
    label $w.ref.left.bottom.f.angleUnit -relief groove -width 9 \
	-padx 4 -text "degrees"

    grid $w.ref.left.bottom.f.angleTitle $w.ref.left.bottom.f.angle x \
	$w.ref.left.bottom.f.angleUnit -padx 4 -sticky w

    # init - do this last
    ${which}DistCB $frame $id
    MarkerBaseCenterRotateCB $frame $id
}

# actions

proc MarkerBasePandaRectClose {frame id} {
    MarkerBasePandaClose $frame $id
    $frame marker $id delete callback rotate MarkerBaseCenterRotateCB
}

proc MarkerBasePandaRectApply {frame id} {
    MarkerBasePandaApply $frame $id
    MarkerBaseCenterRotate $frame $id
}

# callbacks

proc MarkerBasePandaRectCoordCB {frame id} {
    MarkerBasePandaCoordCB $frame $id
    MarkerBaseCenterRotateCB $frame $id
}

proc MarkerBasePandaRectEditCB {frame id} {
    global marker
    set which $marker($frame,$id,which)

    set t \
	[$frame get marker $id epanda radius \
	     $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]

    set last [llength $t]
    set marker($frame,$id,annuli) [expr $last/2-1]
    set marker($frame,$id,radius1) [lindex $t [expr $last-2]]
    set marker($frame,$id,radius2) [lindex $t [expr $last-1]]
    set marker($frame,$id,radius3) [lindex $t 0]

    $marker($frame,$id,annulitxt) delete 1.0 end
    $marker($frame,$id,annulitxt) insert end "$t"

    set a [$frame get marker $id $which angle \
	       $marker($frame,$id,system) $marker($frame,$id,sky)]

    set last [expr [llength $a]-1]
    set marker($frame,$id,ang1) [lindex $a 0]
    set marker($frame,$id,ang2) [lindex $a $last]
    set marker($frame,$id,angnum) $last

    $marker($frame,$id,angtxt) delete 1.0 end
    $marker($frame,$id,angtxt) insert end "$a"
}

proc MarkerBasePandaRectDistCB {frame id} {
    MarkerBasePandaDistCB $frame $id
}

proc MarkerBasePandaRectDefaultDialog {which} {
    global marker
    global ed

    set w ".${which}"

    set ed(ok) 0
    set ed(radius1) $marker($which,radius1)
    set ed(radius2) $marker($which,radius2)
    set ed(radius3) $marker($which,radius3)
    set ed(annuli) $marker($which,annuli)
    set ed(ang1) $marker($which,ang1)
    set ed(ang2) $marker($which,ang2)
    set ed(angnum) $marker($which,angnum)

    DialogCreate $w "Default $which" -borderwidth 2
    frame $w.ed  -relief groove -borderwidth 2
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.ed $w.buttons -fill x -ipadx 4 -ipady 4

    label $w.ed.majorTitle -text "Major"
    label $w.ed.minorTitle -text "Minor"

    label $w.ed.innerTitle -text "Inner Radius"
    entry $w.ed.radius1 -textvariable ed(radius1) -width 10 	
    entry $w.ed.radius2 -textvariable ed(radius2) -width 10 
    label $w.ed.unit -text "image" -relief groove -width 8

    label $w.ed.outerTitle -text "Outer Radius"
    entry $w.ed.radius3 -textvariable ed(radius3) -width 10 

    label $w.ed.annuliTitle -text "Annuli"
    entry $w.ed.annuli -textvariable ed(annuli) -width 10
    
    grid x $w.ed.majorTitle $w.ed.minorTitle -padx 4 -sticky w
    grid $w.ed.innerTitle $w.ed.radius1 $w.ed.radius2 $w.ed.unit \
	-padx 4 -sticky w
    grid $w.ed.outerTitle $w.ed.radius3 -padx 4 -sticky w
    grid $w.ed.annuliTitle $w.ed.annuli -padx 4 -sticky w

    label $w.ed.ang1Title -text "Start"
    label $w.ed.ang2Title -text "Stop"
    label $w.ed.angTitle -text "Angles"
    entry $w.ed.ang1 -textvariable ed(ang1) -width 10
    entry $w.ed.ang2 -textvariable ed(ang2) -width 10
    label $w.ed.angunit -text "degrees" -relief groove -width 8
    label $w.ed.angnumTitle -text "Number"
    entry $w.ed.angnum -textvariable ed(angnum) -width 10
    
    grid x $w.ed.ang1Title $w.ed.ang2Title -padx 4 -sticky w
    grid $w.ed.angTitle $w.ed.ang1 $w.ed.ang2 $w.ed.angunit -padx 4 -sticky w
    grid $w.ed.angnumTitle $w.ed.angnum -padx 4 -sticky w

    button $w.buttons.ok -text "OK" -default active -command {set ed(ok) 1}
    button $w.buttons.cancel -text "Cancel" -command {set ed(ok) 0}
    pack $w.buttons.ok -side left -padx 10
    pack $w.buttons.cancel -side right -padx 10

    bind $w <Return> {set ed(ok) 1}
    bind $w <Alt-o> "tkButtonInvoke $w.buttons.ok"
    bind $w <Alt-c> "tkButtonInvoke $w.buttons.cancel"

    DialogCenter $w 
    $w.ed.radius1 select range 0 end
    DialogWait $w ed(ok) $w.ed.radius1
    DialogDismiss $w

    if {$ed(ok)} {
	set marker($which,radius1) $ed(radius1)
	set marker($which,radius2) $ed(radius2)
	set marker($which,radius3) $ed(radius3)
	set marker($which,annuli) $ed(annuli)
	set marker($which,ang1) $ed(ang1)
	set marker($which,ang2) $ed(ang2)
	set marker($which,angnum) $ed(angnum)
    }

    unset ed
}
