#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc OpenFileDialog {varname} {
    return [FileDialog $varname tk_getOpenFile]
}

proc SaveFileDialog {varname} {
    return [FileDialog $varname tk_getSaveFile]
}

proc FileDialog {varname which} {
    global ds9

    switch -- $ds9(dialog) {
	motif {return [FileDialogMotif $varname $which]}
	windows {return [FileDialogWindows $varname $which]}
	native {return [FileDialogNative $varname $which]}
    }
}

proc FileDialogMotif {varname which} {
    upvar #0 $varname var

    global ds9
    global tcl_platform
    global tk_strictMotif

    set tk_strictMotif 1
    if {$tcl_platform(platform) != "windows"} {
	# Theres a bug with strictmotif. 
	# If tk_strictMotif is set to 1, buttons are
	# rendered smaller than if 0.
	set result [$which \
			-filetypes $var(types) \
			-initialdir $var(directory) \
			-initialfile $var(file) \
			-parent $ds9(top)]
    } else {
	switch -- $which {
	    tk_getOpenFile {set type open}
	    tk_getSaveFile {set type save}
	}
	set result [::tk::MotifFDialog $type \
			-filetypes $var(types) \
			-initialdir $var(directory) \
			-initialfile $var(file) \
			-parent $ds9(top)]
    }
    set tk_strictMotif 0

    if {$result != {}} {
	set var(file) [file tail $result]
	set var(directory) [file dirname $result]
    }
    return $result
}

proc FileDialogWindows {varname which} {
    upvar #0 $varname var
    global ds9
    global tcl_platform

    if {$tcl_platform(platform) != "windows"} {
	set result [$which \
			-filetypes $var(types) \
			-initialdir $var(directory) \
			-initialfile $var(file) \
			-parent $ds9(top)]
    } else {
	switch -- $which {
	    tk_getOpenFile {set type open}
	    tk_getSaveFile {set type save}
	}
	set result [::tk::dialog::file:: $type \
			-filetypes $var(types) \
			-initialdir $var(directory) \
			-initialfile $var(file) \
			-parent $ds9(top)]
    }

    if {$result != {}} {
	set var(file) [file tail $result]
	set var(directory) [file dirname $result]
    }

    return $result
}


proc FileDialogNative {varname which} {
    upvar #0 $varname var
    global ds9
    global tcl_platform

    set result [$which \
		    -filetypes $var(types) \
		    -initialdir $var(directory) \
		    -initialfile $var(file) \
		    -parent $ds9(top)]

    if {$result != {}} {
	set var(file) [file tail $result]
	set var(directory) [file dirname $result]
    }

    return $result
}


proc FileLast {varname fn} {
    upvar #0 $varname var

    set var(file) [file tail $fn]
}

proc FileLastFull {varname fn} {
    upvar #0 $varname var

    set var(file) [file tail $fn]
    set var(directory) [file dirname $fn]
}

# blueplate

proc FileDialogMotifOld {varname which} {
    upvar #0 $varname var

    global ds9
    global tk_strictMotif

    # Theres a bug with strictmotif. 
    # If tk_strictMotif is set to 1, buttons are
    # rendered smaller than if 0.
    set tk_strictMotif 1
    set result [$which \
		    -filetypes   $var(types) \
		    -initialdir  $var(directory) \
		    -initialfile $var(file) \
		    -parent      $ds9(top)]
    set tk_strictMotif 0

    if {$result != {}} {
	set var(file) [file tail $result]
	set var(directory) [file dirname $result]

	if {$var(pattern)} {
	    return [list $result]
	}
    }
    return $result
}

proc FileDialogWindowsOld {varname which} {
    upvar #0 $varname var

    global ds9
    global tcl_platform

    # NOTE: tkFDialog will return a list if var(pattern)==1

    if {$tcl_platform(platform) != "windows"} {
	set result [$which \
			-initialdir  $var(directory) \
			-initialfile $var(file)      \
			-filetypes   $var(types)     \
			-blueplate   0               \
			-dirslist    $var(dirslist)  \
			-loadtype    $var(loadtype)  \
			-pattern     $var(pattern)   \
			-parent      $ds9(top)]
    } else {
	set result [$which \
			-filetypes   $var(types)     \
			-initialdir  $var(directory) \
			-initialfile $var(file)      \
			-parent      $ds9(top)]
    }

    if {$result != {}} {
	set var(file) [file tail $result]
	set var(directory) [file dirname $result]

	if {$var(pattern)} {
	    return [list $result]
	}
    }
    return $result
}

proc FileDialogBluePlateOld {varname which} {
    upvar #0 $varname var

    global ds9

    if {$which == "tk_getOpenFile"} {
	set which open
    } else {
	set which save
    }

    # NOTE: tkFDialog will return a list if var(pattern)==1
    set result [eval ::tk::dialog::file::tkFDialog $which \
		    [list -initialdir  $var(directory) \
			 -initialfile $var(file)      \
			 -filetypes   $var(types)     \
			 -blueplate   1               \
			 -dirslist    $var(dirslist)  \
			 -loadtype    $var(loadtype)  \
			 -pattern     $var(pattern)   \
			 -parent      $ds9(top)]]

    if {$result != {}} {
	if {$var(pattern)} {
	    global FileNameType
	    if {$FileNameType != {File pattern:}} {
		set var(file) [file tail $result]
		set var(directory) [file dirname $result]

		return [list $result]
	    } else {
		set file [lindex $result 0]
		set var(file) [file tail $file]
		set var(directory) [file dirname $file]

		return $result
	    }

	} else {
	    set var(file) [file tail $result]
	    set var(directory) [file dirname $result]

	    return $result
	}
    }
    return $result
}
