// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __colorbarrgb_h__
#define __colorbarrgb_h__

#include "colorbarbase.h"

class ColorbarRGB : public ColorbarBase {
protected:
  int channel;
  float bias[3];
  float contrast[3];

protected:
  void reset();
  int calcContrastBias(int, float, float);

public:
  ColorbarRGB(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~ColorbarRGB();

  // SubCommandFunctions

  void adjustCmd(float, float);
  void getBiasCmd();
  void getColormapCmd();
  void getColormapNameCmd(int);
  void getContrastCmd();
  void getCurrentFileNameCmd();
  void getCurrentIDCmd();
  void getInvertCmd();
  void getCurrentNameCmd();
  void setColormapCmd(float, float, float, float, float, float);
  void getRGBChannelCmd();
  void setRGBChannelCmd(const char*);
};

#endif
