// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "framergbtrue8.h"
#include "fitsimage.h"
#include "util.h"

// Tk Canvas Widget Function Declarations

int FrameRGBTrueColor8CreateProc(Tcl_Interp*, Tk_Canvas, Tk_Item*, int, 
				  Tcl_Obj *const []);

// FrameRGBTrueColor8 Specs

static Tk_CustomOption tagsOption = {
  Tk_CanvasTagsParseProc, Tk_CanvasTagsPrintProc, NULL
};

static Tk_ConfigSpec frameRGBTrueColor8Specs[] = {

  {TK_CONFIG_STRING, "-command", NULL, NULL, "framergb",
   Tk_Offset(WidgetOptions, cmdName), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-x", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, x), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-y", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, y), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-width", NULL, NULL, "512",
   Tk_Offset(WidgetOptions, width), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, "-height", NULL, NULL, "512",
   Tk_Offset(WidgetOptions, height), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_ANCHOR, "-anchor", NULL, NULL, "nw",
   Tk_Offset(WidgetOptions, anchor), 0, NULL},
  {TK_CONFIG_CUSTOM, "-tags", NULL, NULL, NULL,
   0, TK_CONFIG_NULL_OK, &tagsOption},

  {TK_CONFIG_END, NULL, NULL, NULL, NULL, 0, 0, NULL},
};

// Tk Static Structure

static Tk_ItemType frameRGBTrueColor8Type = {
  "framergbtruecolor8",           // name
  sizeof(WidgetOptions),        // item size
  FrameRGBTrueColor8CreateProc,   // configProc
  frameRGBTrueColor8Specs,        // configSpecs
  WidgetConfigProc,             // configProc
  WidgetCoordProc,              // coordProc
  WidgetDeleteProc,             // deleteProc
  WidgetDisplayProc,            // displayProc
  0,                            // alwaysRedraw
  WidgetPointProc,              // pointProc
  WidgetAreaProc,               // areaProc
  WidgetPostscriptProc,         // postscriptProc
  WidgetScaleProc,              // scaleProc
  WidgetTranslateProc,          // translateProc
  (Tk_ItemIndexProc*)NULL,      // indexProc
  WidgetICursorProc,            // icursorProc
  (Tk_ItemSelectionProc*)NULL,  // selectionProc
  (Tk_ItemInsertProc*)NULL,     // insertProc
  (Tk_ItemDCharsProc*)NULL,     // dCharsProc
  (Tk_ItemType*)NULL            // nextPtr
};

// Non-Member Functions

int FrameRGBTrueColor8_Init(Tcl_Interp* interp)
{
  Tk_CreateItemType(&frameRGBTrueColor8Type);
  return TCL_OK;
}

int FrameRGBTrueColor8CreateProc(Tcl_Interp* interp, Tk_Canvas canvas, 
				  Tk_Item* item, int argc, 
				  Tcl_Obj *const argv[])
{
  FrameRGBTrueColor8* frame = new FrameRGBTrueColor8(interp, canvas, item);

  // and set default configuration

  if (frame->configure(argc, (const char**)argv, 0) != TCL_OK) {
    delete frame;
    Tcl_AppendResult(interp, " error occured while creating frame.", NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

// FrameRGBTrueColor8 Member Functions

FrameRGBTrueColor8::FrameRGBTrueColor8(Tcl_Interp* i, Tk_Canvas c, 
					 Tk_Item* item)
  : FrameRGBTrueColor(i, c, item)
{
  configSpecs = frameRGBTrueColor8Specs;  // frame configure options
}

FrameRGBTrueColor8::~FrameRGBTrueColor8()
{
  // we must do this at this level, because updateColorScale is called
  unloadAllFits();
}

void FrameRGBTrueColor8::encodeTrueColor(XColor* src, char* dest)
{
  int rs,gs,bs;
  unsigned char rm = decodeMask((unsigned char) visual->red_mask, &rs);
  unsigned char gm = decodeMask((unsigned char)visual->green_mask, &gs);
  unsigned char bm = decodeMask((unsigned char)visual->blue_mask, &bs);

  *dest = 
    ((((unsigned char)src->blue)  & bm) >> bs) | 
    ((((unsigned char)src->green) & gm) >> gs) | 
    ((((unsigned char)src->red)   & rm) >> rs);
}

void FrameRGBTrueColor8::buildXImage(XImage* xmap,
				      int x0, int y0, int x1, int y1,
				      double* (FitsImage::*getMatrix)())
{
  // we need a colorScale before we can render
  if (!validColorScale())
    return;

  // create img
  unsigned char* img = fillRGBImage(xmap->width, xmap->height, 
				    x0, y0, x1, y1, getMatrix);

  fillXImage8(img, xmap);

  // clean up
  if (img)
    delete [] img;
}

void FrameRGBTrueColor8::buildColormapXM(const unsigned char* img)
{
  int& height = colormapXM->height;
  memset(colormapXM->data, 255, colormapXM->bytes_per_line * height);

  fillXImage8(img, colormapXM);
}

void FrameRGBTrueColor8::fillXImage8(const unsigned char* img, XImage* xmap)
{
  int& width = xmap->width;
  int& height = xmap->height;

  int rs,gs,bs;
  unsigned char rm = decodeMask((unsigned char)visual->red_mask, &rs);
  unsigned char gm = decodeMask((unsigned char)visual->green_mask, &gs);
  unsigned char bm = decodeMask((unsigned char)visual->blue_mask, &bs);

  const unsigned char* ptr = img;

  for (int j=0; j<height; j++) {
    // the line may be padded at the end
    char* dest = xmap->data + j*xmap->bytes_per_line;

    for (int i=0; i<width; i++, dest++, ptr+=3)
      *dest =
	((ptr[0] & rm) >> rs) |  // red
	((ptr[1] & gm) >> gs) |  // green
	((ptr[2] & bm) >> bs);   // blue
  }
}




