#! /bin/sh

echo "SAMP Tests"

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ds9 -tcl&

    i=1
    while [ "$i" -le 30 ]
	do
	sleep 2
	if [ `xpaaccess ds9` = yes ]; then
	    break
	fi

	i=`expr $i + 1`
    done
fi

testit () {
    echo "Testing $1"
    tclsh ../admin/samp.tcl block < samp/${1}.samp
#    tclsh85sg ../admin/samp.tcl block < samp/${1}.samp
    echo "PASSED"
}

doit () {
    if [ "$1" = "$2" -o  -z "$1" ]; then
    testit "$2"
    fi
}

doit2 () {
    if [ "$1" = "$2" ]; then
    testit "$2"
    fi
}

# must be invoked
#         imexam

# load default image
xpaset -p ds9 scale zscale
xpaset -p ds9 file img16.fits

#doit "$1" 2mass
doit "$1" 3d
doit "$1" about
doit "$1" align
doit "$1" analysis
doit "$1" array
doit "$1" bg
doit "$1" bin
doit "$1" catalog
rm -f foo.cat
doit "$1" cd
doit "$1" cmap
rm -f foo.sao foo.tag
doit "$1" colorbar
doit "$1" console
doit "$1" contour
rm -f foo.con foo.lev
doit "$1" crop
doit "$1" crosshair
doit "$1" cube
doit "$1" cursor
doit "$1" data
doit "$1" dsssao
doit "$1" dsseso
doit "$1" dssstsci
doit "$1" export
rm -f foo.fits foo.gif foo.jpg foo.tif foo.png foo.ppm
doit "$1" file
rm -f foo.fits foo.fits.gz
#doit "$1" first
doit "$1" fits
doit "$1" frame
doit "$1" grid
doit "$1" header
doit "$1" height
doit "$1" iconify
doit "$1" iis
doit2 "$1" imexam
doit "$1" lock
doit "$1" lower
doit "$1" magnifier
doit "$1" mask
doit "$1" match
doit "$1" minmax
doit "$1" mode
doit "$1" movie
rm -f foo.mpg
doit "$1" nameserver
doit "$1" nan
doit "$1" nvss
doit "$1" orient
doit "$1" pagesetup
doit "$1" pan
doit "$1" pixeltable
doit "$1" plot
rm -f foo.dat foo.plt
rm -f foo.ps
doit "$1" prefs
doit "$1" preserve
doit "$1" print
doit "$1" regions
rm -f foo.reg
rm -f foo.tpl
doit "$1" rgb
doit "$1" rotate
doit "$1" save
rm -f foo.fits
doit "$1" saveimage
rm -f foo.fits foo.gif foo.jpg foo.tif foo.png foo.ppm foo.mpg
doit "$1" scale
doit "$1" single
doit "$1" skyview
doit "$1" sleep
doit "$1" smooth
doit "$1" source
doit "$1" tcl
doit "$1" theme
doit "$1" threads
doit "$1" update
doit "$1" version
doit "$1" view
doit "$1" vo
doit "$1" wcs
doit "$1" web
doit "$1" width
doit "$1" zscale
doit "$1" zoom
doit "$1" exit
