/*
 * sarg - Squid user management log
 * Mar/2002 - Pedro L Orso - orso@brturbo.com
 */

#include "include/conf.h"

void squidguard_log(const char *dirname, int debug, const char *outdir, int userip, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *Ip2Name, char *TopuserSortField, char *TopuserSortOrder, char *UserAgentLog, char *DateFormat)
{

   FILE *fp_in = NULL, *fp_ou = NULL;
   char guard_in[MAXLEN];
   char guard_ou[MAXLEN];
   char report[MAXLEN];
   char year[5], mon[3], day[3], hour[15];
   char list[MAXLEN];
   char user[MAXLEN];
   char ip[30];

   if(strlen(SquidGuardLogPath) < 1)
     return;

   sprintf(guard_in,"%s/squidguard.unsort",dirname);
   sprintf(guard_ou,"%s/squidguard.log",dirname);
   sprintf(report,"%s/squidguard.html",dirname);

   if((fp_in=fopen(SquidGuardLogPath,"r"))==NULL) {
      fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],SquidGuardLogPath);
      exit(1);
   }

   if((fp_ou=fopen(guard_in,"w"))==NULL) {
      fprintf(stderr, "SARG: (squidguard) %s: %s\n",text[8],tmp4);
      exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(year,buf,'-');
      getword(mon,buf,'-');
      getword(day,buf,' ');
      getword(hour,buf,' ');
      getword(list,buf,'/');
      getword(list,buf,'/');
      getword(tmp5,buf,'/');
      getword(tmp5,buf,'/');
      getword(url,buf,'/');
      getword(ip,buf,' ');
      getword(ip,buf,'/');
      getword(user,buf,' ');
      getword(user,buf,' ');

      if(strcmp(user,"-") == 0) {
         strcpy(user,ip);
	 bzero(ip, 30);
      }

      sprintf(tmp6,"%s %s%s%s %s %s %s %s\n",user,year,mon,day,hour,ip,url,list);
      fputs(tmp6, fp_ou);
      squidguard_count++;
   }

   fclose(fp_in);
   fclose(fp_ou);

   sprintf(tmp6,"sort -k 1,1 -k 2,2 -k 4,4 %s -o %s",guard_in, guard_ou);
   system(tmp6);

   unlink(guard_in);
   return;
}
