/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void ip2name(char *ip,int ip_len)
{ 
   u_long addr;
   struct hostent *hp;
   char **p;

   if ((int)(addr = inet_addr(ip)) == -1)
      return;

   hp = gethostbyaddr((char *)&addr, sizeof (addr), AF_INET);
   if (hp == NULL)
      return;

   for (p = hp->h_addr_list; *p != 0; p++) {
      struct in_addr in;

      (void) memcpy(&in.s_addr, *p, sizeof (in.s_addr));
      strncpy(ip,hp->h_name,ip_len-1);
      ip[ip_len-1]=0;
   }

   return;
}

void name2ip(char *name)
{ 
   struct in_addr ia;
   struct hostent *hp;
   char *port;
   char n1[4];
   char n2[4];
   char n3[4];
   char n4[4];

   port=strchr(name,':');
   if (port) *port=0;

   if((hp=gethostbyname(name))==NULL)
      return;
      
   memcpy(&ia.s_addr,hp->h_addr_list[0],sizeof(ia.s_addr));
   ia.s_addr=ntohl(ia.s_addr);
   strcpy(name,inet_ntoa(ia));
   if (getword(n4,sizeof(n4),name,'.')<0 || getword(n3,sizeof(n3),name,'.')<0 ||
         getword(n2,sizeof(n2),name,'.')<0 || getword(n1,sizeof(n1),name,0)<0) {
      printf("SARG: Maybe you have a broken record or garbage in your %s ip address.\n",name);
      exit(1);
   }
   sprintf(name,"%s.%s.%s.%s",n1,n2,n3,n4);

   return;
} 
