/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
	 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

// #define LEGACY_MY_ATOLL
// #define LEGACY_TESTVALIDUSERCHAR

#include "include/conf.h"
#include "include/defs.h"

static char mtab1[12][4]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};

//! The list of the HTTP codes to exclude from the report.
static char *excludecode=NULL;

/*void fgetword(char *word, char *line, int stop)
{
    //VARIANT N1
    int x;

    for (x=0; line[x] && (line[x] != stop); x++) word[x] = line[x];
    word[x] = '\0';

    //VARIANT N2
    char *tchar;
    int difflen;

    tchar = strchr(line, stop);
    if (tchar == NULL) strcpy(word, line);
    else
    {
	difflen = tchar - line;
	strncpy(word, line, difflen);
	word[difflen] = '\0';
    }
}*/

int getword(char *word, int limit, char *line, int stop)
{
  int x = 0,y;

  /*if(strlen(line) < 3) {
     word[0]='\0';
     return(0);
   }*/

  for(x=0;((line[x]) && (line[x] != stop ));x++) {
     if(x>=limit) {
        printf("SARG: getword loop detected after %d bytes.\n",x);
        printf("SARG: Record=\"%s\"\n",line);
        printf("SARG: searching for \'x%x\'\n",stop);
        //printf("SARG: Maybe you have a broken record or garbage in your access.log file.\n");
        if (limit>0) word[limit-1]='\0';
        //exit(1);
        return(-1);
     }
     word[x] = line[x];
  }

  word[x] = '\0';
  if (line[x]) ++x;
  y=0;

  while((line[y++] = line[x++]));
  return(0);
}

int getword_multisep(char *word, int limit, char *line, int stop)
{
  int x = 0,y;

  for(x=0;((line[x]) && (line[x] != stop ));x++) {
     if(x>=limit) {
        printf("SARG: getword_multisep loop detected.\n");
        printf("SARG: Record=\"%s\"\n",line);
        printf("SARG: searching for \'x%x\'\n",stop);
        printf("SARG: searching for \'x%x\'\n",stop);
        //printf("SARG: Maybe you have a broken record or garbage in your access.log file.\n");
        if (limit>0) word[limit-1]='\0';
        //exit(1);
        return(-1);
     }
     word[x] = line[x];
  }

  word[x] = '\0';
  while (line[x] && line[x]==stop) ++x;
  y=0;

  while((line[y++] = line[x++]));
  return(0);
}

int getword3(char *word, int limit, char *line, int stop)
{
  int x = 0, y = 0;

  for(x=0; x<limit && (line[x] && (line[x] != stop)) ; x++) word[x] = line[x];
  if(x>=limit) {
     printf("SARG: getword3 loop detected after %d bytes.\n",x);
     printf("SARG: Buffer=\"%s\"\n",line);
     printf("SARG: searching for \'x%x\'\n",stop);
     //printf("SARG: Maybe you have a broken record or garbage in your access.log file.\n");
     //exit(1);
     return(-1);
  }
  word[x] = '\0';
  if(line[x]) ++x;
  while((line[y++] = line[x++]));
  return(0);
}


#ifdef LEGACY_MY_ATOLL

// BMG (bguillory@email.com)
// 3 August 1999
long long int my_atoll (const char *nptr)
#define MAXLLL 30 //maximum number of digits in long long (a guess)
{
  int offset=0, x;
  long long int returnval=0;
  char one_digit[2];

  one_digit[1]='\0';

  // Soak up all the white space
  while (isspace(nptr[offset])) {
    offset++;
  } //while

  //For each character left to right
  //change the character to a single digit
  //multiply what we had before by 10 and add the new digit
  for(x=offset; x<=MAXLLL+offset && isdigit(nptr[x]); x++) {
    sprintf(one_digit, "%c", nptr[x]); //I don't know how else to do this
    returnval = (returnval * 10) + atoi(one_digit);
  } //for

  return returnval;

} //my_atoll

#else

#define MAXLLL 30 //!< Maximum number of digits in long long (a guess).
long long int my_atoll (const char *nptr)
{
  long long int returnval=0;
  const char * t = nptr ;
  int max_digits = MAXLLL ;

  // Soak up all the white space
  while (isspace( *t )) {
    t++;
  } //while

  //For each character left to right
  //change the character to a single digit
  //multiply what we had before by 10 and add the new digit

  for( ; --max_digits && isdigit( *t ) ; t++ )
  {
     returnval = ( returnval * 10 ) + ( *t - '0' ) ;
  }

  return returnval;

} //my_atoll

#endif

static int is_absolute(const char *path)
{
   if (*path=='/') return(1);
#ifdef WINDOWS
   if (isalpha(path[0]) && path[1]==':') return(1);
#endif
   return(0);
}

void my_mkdir(const char *name)
{
   char w0[255];
   char w1[255];
   char w2[255];

   if(!is_absolute(name)) {
      fprintf(stderr,"SARG: Invalid path (%s). Please, use absolute paths only.\n",name);
      fprintf(stderr,"SARG: process aborted.\n");
      exit(1);
   }

   strcpy(w0,name);
   strcpy(w2,"/");
   if (getword_multisep(w1,sizeof(w1),w0,'/')<0) {
      printf("SARG: Maybe you have a broken record or garbage in the directory name %s.\n",name);
      exit(1);
   }
   while(strchr(w0,'/')) {
      if (getword_multisep(w1,sizeof(w1),w0,'/')<0) {
         printf("SARG: Maybe you have a broken record or garbage in the directory name %s.\n",name);
         exit(1);
      }
      strcat(w2,w1);
      if(access(w2, R_OK) != 0) {
         if(mkdir(w2,0755)) {
            fprintf(stderr,"SARG: mkdir %s %s\n",w2,strerror(errno));
            fprintf(stderr,"SARG: process aborted.\n");
            exit(1);
         }
      }
      strcat(w2,"/");
   }
   strcat(w2,w0);
   if(access(w2, R_OK) != 0) {
      if(mkdir(w2,0755)) {
         fprintf(stderr,"SARG: mkdir %s %s\n",w2,strerror(errno));
         fprintf(stderr,"SARG: process aborted.\n");
         exit(1);
      }
   }
}


void my_lltoa(unsigned long long int n, char s[], int len)
{
  int i = 0;
  int x = 0;
  char ww[50];
  do {
    s[i++] = (n % 10) + '0';
  } while ((n /= 10) > 0);
  s[i] = '\0';
  {
    int c,i,j;
    for (i = 0, j = strlen(s)-1; i<j; i++, j--)
      {
        c = s[i];
        s[i] = s[j];
        s[j] = c;
      }
  }

  if(len) {
     bzero(ww,sizeof(ww));
     i=len-strlen(s)-1;
     for(x=0; x<=i; x++)
        ww[x]='0';
     i=strlen(s);
     strncat(ww,s,i>sizeof(ww)?sizeof(ww):i);
     strcpy(s,ww);
  }

}


void builddia(char *dia, const char *mes, const char *ano, const char *df, char *wdata)
{
   char ndia[11];
   int nmes;

   if(strlen(dia) < 1) return;

   for(nmes=0; nmes<12; nmes++) {
      if(strcmp(mtab1[nmes],mes) == 0) {
         break;
      }
   }
   nmes++;

   snprintf(wdata,9,"%s%02d%s",ano,nmes,dia);

   if(df[0]!='u')
      snprintf(ndia,sizeof(ndia),"%s/%02d/%s",dia,nmes,ano);
    else
      snprintf(ndia,sizeof(ndia),"%02d/%s/%s",nmes,dia,ano);

   strcpy(dia,ndia);

}


void buildymd(const char *dia, const char *mes, const char *ano, char *wdata)
{
   int nmes;

   for(nmes=0; nmes<12; nmes++) {
      if(strcmp(mtab1[nmes],mes) == 0)
         break;
   }

   sprintf(wdata,"%s%02d%s",ano,nmes+1,dia);

}


void conv_month(char *month)
{
   int  x;

   for(x=0; x<12 && strcmp(mtab1[x],month)!=0; x++);
   sprintf(month,"%02d",x+1);

}


void conv_month_name(char *month)
{
   int x;

   x=atoi(month);
   if (x>=1 && x<=12)
      strcpy(month,mtab1[x-1]);
}


void name_month(char *month,int month_len)
{
   int  x, z=atoi(month)-1;
   char m[255];
   char w[20];

   strcpy(m,text[133]);

   for(x=0; x<z; x++)
      if (getword_multisep(w,sizeof(w),m,',')<0) {
         printf("SARG: Maybe you have a broken record or garbage in the names of the months.\n");
         exit(1);
      }
   if (getword_multisep(month,month_len,m,',')<0) {
      printf("SARG: Maybe you have a broken record or garbage in the name of the months.\n");
      exit(1);
   }
}


void fixper(char *tbuf, char *period, const char *duntil)
{

   char warea[50];
   char dia[5], mes[5], ano[5];
   int  x;

   warea[0]='\0';

   strncpy(dia,duntil+6,2);
   dia[2]='\0';
   strncpy(mes,duntil+4,2);
   mes[2]='\0';
   strncpy(ano,duntil,4);
   ano[4]='\0';

   x=atoi(mes);
   if (x>=1 && x<=12)
      strcpy(mes,mtab1[x-1]);

   if(strcmp(df,"e") == 0)
      sprintf(warea,"%s%s%s",dia,mes,ano);
   if(strcmp(df,"u") == 0)
      sprintf(warea,"%s%s%s",ano,mes,dia);

   strcat(period,warea);
}


void debuga(const char *msg,...)
{
   va_list ap;

   fputs("SARG: ",stderr);
   va_start(ap,msg);
   vfprintf(stderr,msg,ap);
   va_end(ap);
   fputc('\n',stderr);
}


void debugaz(const char *head, const char *msg)
{
  fprintf(stderr, "SARG: (util) %s=%s\n",head, msg);

}


void fixip(char *ip)
{
   int i;
   char sep='_';
   char search=0;
   int nrepl=0;

   for (i=0; ip[i]; i++) {
      if (ip[i]=='.') {
         search='.';
         sep='_';
         break;
      }
      if (ip[i]=='_') {
         search='_';
         sep='.';
         break;
      }
   }
   for (; ip[i]; i++) {
      if (ip[i]==search) {
         ip[i]=sep;
         nrepl++;
         if (nrepl>=3) break;
      }
   }
}


char *fixnum(long long int value, int n)
{
#define MAXLEN_FIXNUM 1024
   char num[MAXLEN_FIXNUM];
   char buf[MAXLEN_FIXNUM * 2];
   char *pbuf;
   static char ret[MAXLEN_FIXNUM * 2];
   char *pret;
   register int i, j, k;
   static char abbrev[30];

   my_lltoa(value, num, 0);

   if(strcmp(DisplayedValues,"abbreviation") == 0) {
      if(strlen(num) <= 3)
         sprintf(abbrev,"%s",num);
      if(strlen(num) == 4 || strlen(num) == 7 || strlen(num) == 10 || strlen(num) == 13) {
         snprintf(abbrev,2,"%s",num);
         strncat(abbrev,".",1);
         strncat(abbrev,num+1,2);
         if(!n) return(abbrev);
         if(strlen(num) == 4)
            strncat(abbrev,"K",1);
         else if(strlen(num) == 7)
            strncat(abbrev,"M",1);
         else if(strlen(num) == 10)
            strncat(abbrev,"G",1);
         else if(strlen(num) == 13)
            strncat(abbrev,"T",1);
      }
      if(strlen(num) == 5 || strlen(num) == 8 || strlen(num) == 11 || strlen(num) == 14) {
         snprintf(abbrev,3,"%s",num);
         strncat(abbrev,".",1);
         strncat(abbrev,num+2,2);
         if(!n) return(abbrev);
         if(strlen(num) == 5)
            strncat(abbrev,"K",1);
         else if(strlen(num) == 8)
            strncat(abbrev,"M",1);
         else if(strlen(num) == 11)
            strncat(abbrev,"G",1);
         else if(strlen(num) == 14)
            strncat(abbrev,"T",1);
      }
      if(strlen(num) == 6 || strlen(num) == 9 || strlen(num) == 12 || strlen(num) == 15) {
         snprintf(abbrev,4,"%s",num);
         strncat(abbrev,".",1);
         strncat(abbrev,num+3,2);
         if(!n) return(abbrev);
         if(strlen(num) == 6)
            strncat(abbrev,"K",1);
         else if(strlen(num) == 9)
            strncat(abbrev,"M",1);
         else if(strlen(num) == 12)
            strncat(abbrev,"G",1);
         else if(strlen(num) == 15)
            strncat(abbrev,"T",1);
      }

      return(abbrev);
   }

   bzero(buf, MAXLEN_FIXNUM*2);

   pbuf = buf;
   pret = ret;
   k = 0;

   for ( i = strlen(num) - 1, j = 0 ; i > -1; i--) {
      if ( k == 2 && i != 0 )  {
         k = 0;
         pbuf[j++] = num[i];
         if(strcmp(UseComma,"yes") == 0)
            pbuf[j++] = ',';
         else pbuf[j++] = '.';
         continue;
      }
      pbuf[j] = num[i];
      j++;
      k++;
   }

   pret[0]='\0';

   for ( i = strlen(pbuf) - 1, j = 0 ; i > -1; i--, j++)
      pret[j] = pbuf[i];

   pret[j] = '\0';

   return pret;
}


char *fixnum2(long long int value, int n)
{
#define MAXLEN_FIXNUM2 1024
   char num[MAXLEN_FIXNUM2];
   char buf[MAXLEN_FIXNUM2 * 2];
   char *pbuf;
   static char ret[MAXLEN_FIXNUM2 * 2];
   char *pret;
   register int i, j, k;

   my_lltoa(value, num, 0);
   bzero(buf, MAXLEN_FIXNUM2*2);

   pbuf = buf;
   pret = ret;
   k = 0;

   for ( i = strlen(num) - 1, j = 0 ; i > -1; i--) {
      if ( k == 2 && i != 0 )  {
         k = 0;
         pbuf[j++] = num[i];
         if(strcmp(UseComma,"yes") == 0)
            pbuf[j++] = ',';
         else pbuf[j++] = '.';
         continue;
      }
      pbuf[j] = num[i];
      j++;
      k++;
   }

   pret[0]='\0';

   for ( i = strlen(pbuf) - 1, j = 0 ; i > -1; i--, j++)
      pret[j] = pbuf[i];

   pret[j] = '\0';

   return pret;
}



void buildhref(char * href)
{
   char whref[MAXLEN];

   if(strcmp(href,"./") == 0){
      href[0]='\0';
      strcat(href,"<a href='");
      return;
   }

   href[strlen(href)-1]='\0';
   sprintf(whref,"%s",strrchr(href,'/'));

   strcpy(href,"<a href='");
   strcat(href,whref);
   strcat(href,"/");

   return;

}


char *buildtime(long long int elap)
{

   int num = elap / 1000;
   int hor = 0;
   int min = 0;
   int sec = 0;
   static char buf[12];

   buf[0]='\0';

   hor=num / 3600;
   min=(num % 3600) / 60;
   sec=num % 60;
   sprintf(buf,"%02d:%02d:%02d",hor,min,sec);

   return(buf);

}


void obtdate(const char *dirname, const char *name, char *data)
{

   FILE *fp_in;
   char wdir[MAXLEN];

   sprintf(wdir,"%s%s/sarg-date",dirname,name);
   if ((fp_in = fopen(wdir, "rt")) == 0) {
      sprintf(wdir,"%s%s/date",dirname,name);
      if ((fp_in = fopen(wdir, "rt")) == 0) {
         data[0]='\0';
         return;
      }
   }

   if (!fgets(data,80,fp_in)) {
      fprintf(stderr,"Failed to read the date in %s\n",wdir);
      exit(1);
   }
   fclose(fp_in);
   fixendofline(data);

   return;

}


void obtuser(const char *dirname, const char *name, char *tuser)
{

   FILE *fp_in;
   char wdir[MAXLEN];

   sprintf(wdir,"%s%s/sarg-users",dirname,name);
   if((fp_in=fopen(wdir,"r"))==NULL) {
      sprintf(wdir,"%s%s/users",dirname,name);
      if((fp_in=fopen(wdir,"r"))==NULL) {
         tuser[0]='\0';
         return;
      }
   }

   if (!fgets(tuser,20,fp_in)) {
      fprintf(stderr,"Failed to read the user in %s\n",wdir);
      exit(1);
   }
   fclose(fp_in);
   fixendofline(tuser);

   return;

}


void obttotal(const char *dirname, const char *name, char *tbytes, char *tuser, char *media)
{

   FILE *fp_in;
   char wdir[MAXLEN];
   long long int med=0;
   long long int wtuser=0;
   long long int twork;

   sprintf(wdir,"%s%s/sarg-general",dirname,name);
   if ((fp_in = fopen(wdir, "r")) == 0) {
      sprintf(wdir,"%s%s/general",dirname,name);
      if ((fp_in = fopen(wdir, "r")) == 0) {
         tbytes=0;
         return;
      }
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if (getword_multisep(warea,sizeof(warea),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wdir);
         exit(1);
      }
      if(strcmp(warea,"TOTAL") != 0)
         continue;
      if (getword_multisep(warea,sizeof(warea),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wdir);
         exit(1);
      }
      if (getword_multisep(warea,sizeof(warea),buf,' ')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",wdir);
         exit(1);
      }
      twork=my_atoll(warea);
      strcpy(tbytes,fixnum(twork,1));
   }
   fclose(fp_in);

   wtuser=my_atoll(tuser);
   if(wtuser == 0) {
      strcpy(media,"0");
      return;
   }

   med=my_atoll(warea) / wtuser;
   strcpy(media,fixnum(med,1));

   return;

}


void gperiod(const char *dirname, const char *period)
{

   FILE *fp_ou;
   char wdirname[MAXLEN];

   strcpy(wdirname,dirname);
   strcat(wdirname,"/");
   strcat(wdirname,"sarg-period");

   if((fp_ou=fopen(wdirname,"w"))==NULL){
      fprintf(stderr, "SARG: (report) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   fputs(period,fp_ou);
   fclose(fp_ou);

   if(debug)
      debuga("%s",(char *)text[50]);

   return;

}

void vrfydir(const char *dir, const char *per1, const char *addr, const char *site, const char *us, const char *form)
{
   FILE *img_in, *img_ou;
   FILE *fp_ou;
   int  num=1, count=0;
   int  c;
   char wdir[MAXLEN];
   char per2[MAXLEN];
   char dirname2[MAXLEN];
   char images[512];
   DIR *dirp;
   struct dirent *direntp;
   char y1[5], y2[5];
   char d1[3], d2[3];
   char m1[4], m2[4];
   time_t curtime;
   int cstatus;

   if(strcmp(IndexTree,"date") == 0) {
      bzero(y1,5);
      bzero(y2,5);
      bzero(d1,3);
      bzero(d2,3);
      bzero(m1,4);
      bzero(m2,4);
      if(strncmp(df,"u",1) == 0) {
         strncpy(y1,period,4);
         strncpy(y2,period+10,4);
         strncpy(m1,period+4,3);
         strncpy(m2,period+14,3);
         strncpy(d1,period+7,2);
         strncpy(d2,period+17,2);
      } else if(strncmp(df,"e",1) == 0) {
         strncpy(d1,period+0,2);
         strncpy(d2,period+10,2);
         strncpy(m1,period+2,3);
         strncpy(m2,period+12,3);
         strncpy(y1,period+5,4);
         strncpy(y2,period+15,4);
      }
      conv_month(m1);
      conv_month(m2);

      sprintf(wdir,"%s%s",outdir,y1);
      if(strcmp(y1,y2) != 0) {
         strncat(wdir,"-",1);
         strncat(wdir,y2,strlen(y2));
      }
      if(access(wdir, R_OK) != 0)
         my_mkdir(wdir);

      strncat(wdir,"/",1);
      strncat(wdir,m1,strlen(m1));
      if(strcmp(m1,m2) != 0) {
         strncat(wdir,"-",1);
         strncat(wdir,m2,strlen(m2));
      }
      if(access(wdir, R_OK) != 0)
         my_mkdir(wdir);

      strncat(wdir,"/",1);
      strncat(wdir,d1,strlen(d1));
      if(strcmp(d1,d2) != 0) {
         strncat(wdir,"-",1);
         strncat(wdir,d2,strlen(d2));
      }
   } else
      strcpy(wdir,dir);

   if(strlen(us) > 0) {
      strcat(wdir,"-");
      strcat(wdir,us);
   }
   if(strlen(addr) > 0) {
      strcat(wdir,"-");
      strcat(wdir,addr);
   }
   if(strlen(site) > 0) {
      strcat(wdir,"-");
      strcat(wdir,site);
   }

   if(strcmp(dirname,wdir) != 0)
      strcpy(dirname,wdir);

   if(strcmp(IndexTree,"date") != 0) {
      strcpy(dirname2,dirname);
      if(strcmp(OverwriteReport,"no") == 0) {
         while(num) {
            if(access(wdir,R_OK) == 0) {
               sprintf(wdir,"%s.%d",dirname,num);
               sprintf(per2,"%s.%d",per1,num);
               num++;
               count++;
            } else
               break;
         }

         if(count > 0) {
            if(debug)
               fprintf(stderr, "SARG: %s: %s %s %s\n",text[51],dirname2,text[52],wdir);
            rename(dirname2,wdir);
         }
      } else {
         if(access(dir,R_OK) == 0) {
            sprintf(csort,"rm -r \"%s\"",dir);
            cstatus=system(csort);
            if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
               fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
               fprintf(stderr, "SARG: command: %s\n",csort);
               exit(1);
            }
         }
      }
      my_mkdir(dirname);
   } else {
      strcpy(dirname2,wdir);
      if(strcmp(OverwriteReport,"no") == 0) {
         while(num) {
            if(access(wdir,R_OK) == 0) {
               sprintf(wdir,"%s.%d",dirname2,num);
               sprintf(per2,"%s.%d",per1,num);
               num++;
               count++;
            } else
               break;
         }

         if(count > 0) {
            if(debug)
               fprintf(stderr, "SARG: %s: %s %s %s\n",text[51],dirname2,text[52],wdir);
            rename(dirname2,wdir);
            strcpy(dirname2,wdir);
         }
      } else {
         if(access(wdir,R_OK) == 0) {
            sprintf(csort,"rm -r \"%s\"",wdir);
            cstatus=system(csort);
            if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
               fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
               fprintf(stderr, "SARG: command: %s\n",csort);
               exit(1);
            }
         }
      }

      if(access(wdir, R_OK) != 0)
         my_mkdir(wdir);
   }

   strcpy(dirname2,wdir);
   sprintf(images,"%simages",outdir);
   mkdir(images,0755);

   sprintf(wdir,"%s/sarg-date",dirname);
   if ((fp_ou = fopen(wdir, "wt")) == 0) {
      fprintf(stderr, "SARG: cannot open %s for writing\n",wdir);
      perror("SARG:");
      exit(1);
   }
   time(&curtime);
   strftime(wdir,sizeof(wdir),"%a %b %d %H:%M:%S %Z %Y",localtime(&curtime));
   fprintf(fp_ou,"%s\n",wdir);
   fclose(fp_ou);

   strcpy(per2,IMAGEDIR);

   dirp = opendir(per2);
   if(dirp==NULL) {
      fprintf(stderr, "SARG: (util) %s %s: %s\n","Can't open directory", per2,strerror(errno));
      return;
   }
   while ((direntp = readdir( dirp )) != NULL ){
      if(strncmp(direntp->d_name,".",1) == 0)
         continue;
      sprintf(val10,"%s/%s",per2,direntp->d_name);
      sprintf(val11,"%s/%s",images,direntp->d_name);
      img_in = fopen(val10, "rb");
      if(img_in!=NULL) {
         img_ou = fopen(val11, "wb");
         if(img_ou!=NULL) {
            while ((c = fgetc(img_in))!=EOF) {
               fputc(c,img_ou);
            }
            fclose(img_ou);
         } else
            fprintf(stderr,"SARG: (util): %s %s: %s\n", text[45]?text[45]:"Can't open/create file", val11, strerror(errno));
         fclose(img_in);
      } else
         fprintf(stderr,"SARG: (util): %s %s: %s\n", text[45]?text[45]:"Can't open file", val10, strerror(errno));
   }
   (void) rewinddir(dirp);
   (void) closedir(dirp);

   return;


}


void strip_latin(char *line)
{
   char buf[255];
   char warea[255];

   while(strstr(line,"&") != 0){
      if (getword_multisep(warea,sizeof(warea),line,'&')<0) {
         printf("SARG: Maybe you have a broken record or garbage in a line to strip from HTML entities.\n");
         exit(1);
      }
      strncat(warea,line,1);
      if (getword_multisep(buf,sizeof(buf),line,';')<0) {
         printf("SARG: Maybe you have a broken record or garbage in a line to strip from HTML entities.\n");
         exit(1);
      }
      strcat(warea,line);
      strcpy(line,warea);
   }

   return;

}

void zdate(char *ftime, const char *DateFormat)
{

   time_t t;
   struct tm *local;

   t = time(NULL);
   local = localtime(&t);
   if(strcmp(DateFormat,"u") == 0)
      strftime(ftime, 127, "%b/%d/%Y %H:%M", local);
   if(strcmp(DateFormat,"e") == 0)
      strftime(ftime, 127, "%d/%b/%Y-%H:%M", local);
   if(strcmp(DateFormat,"w") == 0)
      strftime(ftime, 127, "%V-%H-%M", local);

   return;
}


char *fixtime(long int elap)
{

   int num = elap / 1000;
   int hor = 0;
   int min = 0;
   int sec = 0;
   static char buf[12];

   if(strcmp(datetimeby,"bytes") == 0) {
      strcpy(buf,fixnum(elap,1));
      return buf;
   }

   if(num<1) {
      sprintf(buf,"00:00:%02ld",elap);
      return buf;
   }

   hor=num / 3600;
   min=(num % 3600) / 60;
   sec=num % 60;

   if(hor==0 && min==0 && sec==0)
      strcpy(buf,"0");
   else
      sprintf(buf,"%01d:%02d:%02d",hor,min,sec);

   return buf;

}


void date_from(char *date, char *dfrom, char *duntil)
{

   char diaf[10];
   char mesf[10];
   char anof[10];
   char diau[10];
   char mesu[10];
   char anou[10];
   static char wdate[50];


   strcpy(wdate,date);
   if(strchr(wdate,'-') == NULL) {
      strcat(wdate,"-");
      strcat(wdate,date);
      strcpy(date,wdate);
   }

   if (getword(diaf,sizeof(diaf),wdate,'/')<0 || getword(mesf,sizeof(mesf),wdate,'/')<0 || getword(anof,sizeof(anof),wdate,'-')<0 ||
       getword(diau,sizeof(diau),wdate,'/')<0 || getword(mesu,sizeof(mesu),wdate,'/')<0 || getword(anou,sizeof(anou),wdate,0)<0) {
      printf("SARG: Maybe you have a broken record or garbage in a date.\n");
      exit(1);
   }

   sprintf(dfrom,"%s%s%s",anof,mesf,diaf);
   sprintf(duntil,"%s%s%s",anou,mesu,diau);
   return;
}


char *strlow(char *string)
{
   char *s;

   if (string)
   {
      for (s = string; *s; ++s)
         *s = tolower(*s);
   }

   return string;
}




char *strup(char *string)
{
   char *s;

   if (string)
   {
      for (s = string; *s; ++s)
         *s = toupper(*s);
   }

   return string;
}


void subs(char *str, int size, char *from, char *to)
{
   char *tmp;
   int i;
   int ss, st, sf;
   int len;
   int shift;

   tmp = strstr(str, from);
   if(tmp == NULL)
      return;

   ss = strlen(str);
   sf = strlen(from);
   st = strlen(to);
   shift=st-sf;

   if (shift>0) {
      if (ss+shift>=size){
         fprintf(stderr,"SARG: Cannot replace %s by %s in %s and fit within %d bytes\n",from,to,str,size);
         exit(1);
      }
      for (i=strlen(tmp) ; i>=sf ; i--)
         tmp[i+shift]=tmp[i];
   } else if (shift<0) {
      len=strlen(tmp);
      for (i=sf ; i<=len ; i++)
         tmp[i+shift]=tmp[i];
   }
   memcpy(tmp, to, st);
   return;
}


void removetmp(const char *outdir)
{

   FILE *fp_in;
   char warea[256];

   if(strcmp(RemoveTempFiles,"yes") != 0)
      return;

   if(debug) {
      debuga("%s: sarg-general, sarg-period",text[82]);
   }
   if (snprintf(warea,sizeof(warea),"%s/sarg-general",outdir)>=sizeof(warea)) {
      fprintf(stderr, "SARG: (removetmp) directory too long to remove: %s/sarg-period\n",outdir);
      exit(1);
   }
   if((fp_in=fopen(warea,"r"))==NULL){
      fprintf(stderr, "===SARG: (removetmp) %s: %s\n",text[45],warea);
      exit(1);
   }
   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if(strncmp(buf,"TOTAL",5) == 0)
         break;
   }
   fclose(fp_in);
   if((fp_in=fopen(warea,"w"))==NULL){
      fprintf(stderr, "SARG: (removetmp) %s: %s\n",text[45],warea);
      exit(1);
   }
   fputs(buf,fp_in);
   fclose(fp_in);
   if (snprintf(warea,sizeof(warea),"%s/sarg-period",outdir)>=sizeof(warea)) {
      fprintf(stderr, "SARG: (removetmp) directory too long to remove: %s/sarg-period\n",outdir);
      exit(1);
   }
   unlink(warea);

   return;
}

void load_excludecodes(const char *ExcludeCodes)
{

   FILE *fp_in;
   char data[80];
   int i;

   if(ExcludeCodes[0] == '\0')
      return;

   if((excludecode=(char *) malloc(1024))==NULL) {
      fprintf(stderr, "SARG: %s (1024):\n",text[59]);
      exit(1);
   }
   bzero(excludecode,1024);

   if((fp_in=fopen(ExcludeCodes,"r"))==NULL) {
     fprintf(stderr, "SARG: (util) Cannot open file: %s (exclude_codes)\n",ExcludeCodes);
     exit(1);
   }

   while(fgets(data,sizeof(data),fp_in)!=NULL) {
      for (i=strlen(data)-1 ; i>=0 && (unsigned char)data[i]<=' ' ; i--) data[i]=0;
      if (i<0) continue;
      strcat(excludecode,data);
      strcat(excludecode,";");
   }

   fclose(fp_in);
   return;

}

void free_excludecodes(void)
{
   if (excludecode) {
      free(excludecode);
      excludecode=NULL;
   }
}

int vercode(const char *code)
{
   char *cod;
   int clen;

   if (excludecode && excludecode[0]!=0) {
      clen=strlen(code);
      for (cod=excludecode ; cod ; cod=strchr(cod+1,';')) {
         if (strncmp(code,cod,clen)==0 && cod[clen]==';')
            return 1;
      }
   }
   return 0;
}

void fixnone(char *str)
{
   int i;

   for (i=strlen(str)-1 ; i>=0 && (unsigned char)str[i]<=' ' ; i--);
   if(i==3 && strncmp(str,"none",4) == 0)
      str[0]='\0';

   return;
}

void fixendofline(char *str)
{
   int i;

   for (i=strlen(str)-1 ; i>=0 && (unsigned char)str[i]<=' ' ; i--) str[i]=0;
}

#ifdef LEGACY_TESTVALIDUSERCHAR
int testvaliduserchar(const char *user)
{

   int x=0;
   int y=0;

   for (y=0; y<strlen(UserInvalidChar); y++) {
      for (x=0; x<strlen(user); x++) {
         if(user[x] == UserInvalidChar[y])
            return 1;
      }
   }
   return 0;
}
#else
int testvaliduserchar(const char *user)
{

   char * p_UserInvalidChar = UserInvalidChar ;
   const char * p_user ;

   while( *p_UserInvalidChar ) {
      p_user = user ;
      while ( *p_user ) {
         if( *p_UserInvalidChar == *p_user )
            return 1;
         p_user++ ;
      }
      p_UserInvalidChar++ ;
   }
   return 0;
}
#endif

int compar( const void *a, const void *b )
{ if( *(int *)a > *(int *)b ) return 1;
  if( *(int *)a < *(int *)b ) return -1;
  return 0;
}

int getnumlist( char *buf, numlist *list, const int len, const int maxvalue )
{
   int i, j, d, flag, r1, r2;
   char *pbuf, **bp, *strbufs[ 24 ];

   bp = strbufs;
   strtok( buf, " \t" );
   for( *bp = strtok( NULL, "," ), list->len = 0; *bp; *bp = strtok( NULL, "," ) ) {
      if( ++bp >= &strbufs[ 24 ] )
         break;
      list->len++;
   }
   if( ! list->len )
      return -1;
   d = 0;
   for( i = 0; i < list->len; i++ ) {
      if( strchr( strbufs[ i ], '-' ) != 0 ) {
         pbuf = strbufs[ i ];
         strtok( pbuf, "-" );
         pbuf = strtok( NULL, "\0" );
         r1 = atoi( strbufs[ i ] );
         if( ( r2 = atoi( pbuf ) ) >= maxvalue || r1 >= r2 )
            return -1;
         if( i + d + ( r2 - r1 ) + 1 <= len ) {
            for( j = r1; j <= r2; j++ )
               list->list[ i + d++ ] = j;
            d--;
         }
      }
      else
         if( ( list->list[ i + d ] = atoi( strbufs[ i ] ) ) >= maxvalue )
            return 1;
   }
   list->len += d;
   qsort( list->list, list->len, sizeof( int ), compar );
   do {
      flag = 0;
      for( i = 0; i < list->len - 1; i++ )
         if( list->list[ i ] == list->list[ i + 1 ] ) {
            for( j = i + 1; j < list->len; j++ )
               list->list[ j - 1 ] = list->list[ j ];
            list->len--;
            flag = 1;
            break;
         }
   } while( flag );
   return 0;
}


char *get_size(const char *path, const char *file)
{
   FILE *fp;
   char response[255];
   char cmd[255];

   if (snprintf(cmd,sizeof(cmd),"du -skh %s%s",path,file)>=sizeof(cmd)) {
      printf("SARG: Cannot get disk space because the path %s%s is too long.\n",path,file);
      exit(1);
   }
   fp = popen(cmd, "r");
   if (!fgets(response, sizeof(response), fp)) {
      fprintf(stderr,"SARG: Cannot get disk size with command %s",cmd);
      exit(1);
   }
   if (getword_multisep(val5,sizeof(val5),response,'\t')<0) {
      printf("SARG: Maybe the command %s failed.\n",cmd);
      exit(1);
   }
   pclose(fp);

   return (val5);
}

void show_info(FILE *fp_ou)
{
   char ftime[127];

   if(strcmp(ShowSargInfo,"yes") != 0) return;
   zdate(ftime, DateFormat);
   fprintf(fp_ou,"<div align=\"center\"><table><tr><td><br><br></td><td class=\"info\">%s <a href='%s'><font class=\"info\">%s-%s</font></a> %s %s</td></tr></table></div>\n",text[108],URL,PGM,VERSION,text[109],ftime);
}

void show_sarg(FILE *fp_ou, const char *ind)
{
   if(strcmp(ShowSargLogo,"yes") == 0) fprintf(fp_ou,"<div align=\"center\"><table class=\"logo\">\n<tr><th><a href=\"http://sarg.sourceforge.net\"><img src=\"%s/images/sarg.png\" title=\"SARG, Squid Analysis Report Generator. Logo by Osamu Matsuzaki\" alt=\"Sarg\"></a>&nbsp;Squid Analysis Report Generator</th></tr>\n<tr><th class=\"title\">&nbsp</th></tr>\n</table></div>\n",ind);
}

void write_logo_image(FILE *fp_ou)
{
   if(LogoImage[0]!='\0')
      fprintf(fp_ou, "<div align=\"center\"><table class=\"logo\">\n<tr><th><img src=\"%s\" width=\"%s\" height=\"%s\" alt=\"Logo\">&nbsp;%s</th></tr>\n<tr><td height=\"5\"></td></tr>\n</table>\n</div>\n",LogoImage,Width,Height,LogoText);
}

void write_html_header(FILE *fp_ou, const char * ind)
{
   fprintf(fp_ou, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   css(fp_ou);
   fprintf(fp_ou,"</head>\n<body style=\"font-family:%s;font-size:%s;background-color:%s;background-image:url(%s)\">\n",FontFace,TitleFontSize,BgColor,BgImage);
   write_logo_image(fp_ou);
   show_sarg(fp_ou, ind);
   fprintf(fp_ou,"<div align=\"center\"><table cellpadding=\"0\" cellspacing=\"0\">\n<tr><th class=\"title\">%s</th></tr>\n</table></div>\n<div align=\"center\"><table cellpadding=\"1\" cellspacing=\"2\">\n<tr><td></td><td></td></tr>\n",Title);
}

void output_html_string(FILE *fp_ou,const char *str)
{

   while (*str) {
      switch (*str) {
         case '&':
            fputs("&amp;",fp_ou);
            break;
         case '<':
            fputs("&lt;",fp_ou);
            break;
         case '>':
            fputs("&gt;",fp_ou);
            break;
         case '"':
            fputs("&quot;",fp_ou);
            break;
         case '\'':
            fputs("&#39;",fp_ou);
            break;
         default:
            fputc(*str,fp_ou);
      }
      str++;
   }
}

void baddata(void)
{
   char cmd[1024];
   int cstatus;

   printf("SARG: ------------------------------------------------------------------------------\n");
   printf("SARG: MALICIUS CODE DETECTED.\n");
   printf("SARG: I think someone is trying to execute arbitrary code in your system using sarg.\n");
   printf("SARG: please review your access.log and/or your useragent.log file.\n");
   printf("SARG: process stoped. No actions taken.\n");
   printf("SARG: ------------------------------------------------------------------------------\n");

   if (snprintf(cmd,sizeof(cmd),"rm -rf \"%s/sarg\"",tmp)>=sizeof(cmd)) {
      fprintf(stderr,"SARG: temporary directory too long: %s/sarg\n",tmp);
      exit(1);
   }
   cstatus=system(cmd);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: command: %s\n",cmd);
      exit(1);
   }
   if (snprintf(cmd,sizeof(cmd),"rm -rf \"%s\"",dirname)>=sizeof(cmd)) {
      fprintf(stderr,"SARG: directory to delete too long: %s\n",dirname);
      exit(1);
   }
   cstatus=system(cmd);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: command: %s\n",cmd);
      exit(1);
   }

   exit(1);
}


void url_module(const char *url, char *w2)
{
   int x, y;
   char w[255];

   y=0;
   for(x=strlen(url)-1; x>=0; x--) {
      if(url[x] == '/' || y>=sizeof(w)-1) break;
      w[y++]=url[x];
   }
   if (x<0) {
      w2[0]='\0';
      return;
   }

   x=0;
   for(y=y-1; y>=0; y--) {
      w2[x++]=w[y];
   }
   w2[x]='\0';
}


void write_html_trailer(FILE *fp_ou)
{
   fputs("</table></div>\n",fp_ou);
   zdate(ftime, DateFormat);
   show_info(fp_ou);
   fputs("</body>\n</html>\n",fp_ou);
}

void version(void)
{
   printf("SARG Version: %s\n",VERSION);
   exit(0);
}

char *get_param_value(const char *param,char *line)
{
   int plen;

   while (*line==' ' || *line=='\t') line++;
   plen=strlen(param);
   if (strncasecmp(line,param,plen)) return(NULL);
   if (line[plen]!=' ' && line[plen]!='\t') return(NULL);
   line+=plen;
   while (*line==' ' || *line=='\t') line++;
   return(line);
}

void read_usertab(const char *UserTabFile)
{
   FILE *fp_usr;
   long int nreg;
   char buf[MAXLEN];
   char bufy[MAXLEN];
   int z2;
   int z1;
   int i;

   if (UserTabFile[0] != '\0') {
      if(debug) {
         debuga("%s: %s",text[86],UserTabFile);
      }
      if((fp_usr=fopen(UserTabFile,"r"))==NULL) {
         fprintf(stderr, "SARG: (log) %s: %s - %s\n",text[45],UserTabFile,strerror(errno));
         exit(1);
      }
      fseek(fp_usr, 0, SEEK_END);
      nreg = ftell(fp_usr);
      if (nreg<0) {
         printf("SARG: Cannot get the size of file %s",UserTabFile);
         exit(1);
      }
      nreg += 100;
      fseek(fp_usr, 0, SEEK_SET);
      if((userfile=(char *) malloc(nreg))==NULL){
         fprintf(stderr, "SARG ERROR: %s",text[87]);
         exit(1);
      }
      strcpy(userfile,"\t");
      z2=1;
      while(fgets(buf,sizeof(buf),fp_usr)!=NULL) {
         if (buf[0]=='#') continue;
         for (i=strlen(buf)-1 ; i>=0 && (unsigned char)buf[i]<=' ' ; i--) buf[i]=0;
         if (getword_multisep(bufy,sizeof(bufy),buf,' ')<0) {
            printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",UserTabFile);
            exit(1);
         }
         if (z2+strlen(bufy)+strlen(buf)+3>=nreg) {
            printf("SARG: The list of the users is too long in your %s file.\n",UserTabFile);
            exit(1);
         }
         for(z1=0; bufy[z1]; z1++)
            userfile[z2++]=bufy[z1];
         userfile[z2++]='\n';
         for(z1=0; buf[z1]; z1++)
            userfile[z2++]=buf[z1];
         userfile[z2++]='\t';
      }
      userfile[z2]=0;
      fclose(fp_usr);
   }
}

void get_usertab_name(const char *user,char *name,int namelen)
{
   char warea[MAXLEN];
   char *str;

   namelen--;
   if(UserTabFile[0] == '\0') {
      strncpy(name,user,namelen);
      name[namelen]=0;
   } else {
      sprintf(warea,"\t%s\n",user);
      if((str=(char *) strstr(userfile,warea)) == (char *) NULL ) {
         strncpy(name,user,namelen);
         name[namelen]=0;
      } else {
         str=strchr(str+1,'\n');
         str++;
         for(z1=0; *str != '\t' && z1<namelen ; z1++) {
            name[z1]=*str++;
         }
         name[z1]=0;
      }
   }
}

int is_download_suffix(const char *url)
{
   int urllen;
   int i;
   char suffix[10];
   const char *str;
   int suflen;

   if(DownloadSuffix[0]==0) return(0);

   urllen=strlen(url)-1;
   for (i=0 ; i<sizeof(suffix)-1 && i<urllen ; i++) {
      if (url[urllen-i]=='.') {
         if (i==0) return(0); //detect a single trailing dot
         strcpy(suffix,url+urllen-i+1);
         suflen=strlen(suffix);
         for (str=DownloadSuffix ; str ; str=strchr(str,',')) {
            if (*str==',') str++;
            if(strncasecmp(str,suffix,suflen)==0 && (str[suflen]==',' || str[suflen]==0))
               return(1);
         }
         return(0);
      }
   }
   return(0);
}

