
#ifndef IIRSCRAM_ARRAY_NATURE_DEFINITION_HH
#define IIRSCRAM_ARRAY_NATURE_DEFINITION_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Sivakumar Gowrisankar             gowriss@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_ArrayNatureDefinition.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TypeDeclaration.hh"
#include "published_file.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "error_func.hh"
#include "set.hh"
#include <stdlib.h>

class IIR_NatureDeclaration;
class IIR_NatureDefinition;
class IIR_ArrayNatureDefinition;
class IIR_ArraySubnatureDefinition;
class IIR_ScalarTypeDefinition;

class IIRScram_ArrayNatureDefinition : public IIRBase_ArrayNatureDefinition {
    friend class StandardPackage;
public:

  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl(ostream &);
  void _publish_vhdl_subtype_decl(ostream &);
  void _publish_cc_lvalue();
  void _publish_cc_lvalue(published_file &);
  void _publish_cc_ams();
  void _publish_cc_type_info( published_file &);
  void _publish_cc_type_info( published_file &,
                              char *, char *);

  /** Used to identify if the object is of type Array Nature */
  IIR_Boolean _is_iir_array_type_definition() { return TRUE; }

  /** Used to check if the its an unconstrained array type */
  IIR_Boolean _is_unconstrained_array_type();

  /** Used to construct constrained and unconstrained arrays */
  static IIR_ArrayNatureDefinition *
  _construct_array_type( IIR_ScalarTypeDefinition *index_subtype,
                         IIR_NatureDefinition *, 
                         IIR_NatureDeclaration * );

  IIR_NatureDefinition *
  _construct_new_subtype( IIR_Name *,
                          IIR_ScalarTypeDefinition * );

  IIR_NatureDefinition *
  _index_constrain_array( IIR_ScalarTypeDefinition * );

  /** True if the object is of Scalar type */
  IIR_Boolean _is_element(){ return is_element(); };

  /** It is used to identify if the object if of array type */
  IIR_Boolean _is_array_type() { return TRUE; }     

  /** Gets the element subtype of a given index object */
  IIR_NatureDefinition *_get_element_subtype();        

  /** Sets the element subtype of the current index. Used to 
      form a linked list like structure to progressively refer 
      to the consecutive indexes in the array. The final index will 
      refer to the object returned by the subnature_indication  */
  void _set_element_subtype(IIR_NatureDefinition *);        

  /** Gets the index subtype of a base object */
  IIR_ScalarTypeDefinition *_get_index_subtype();

  /** Sets the index subtype of a base object */
  void _set_index_subtype( IIR_ScalarTypeDefinition * );
  IIR_NatureDefinition *_get_new_subtype();
 
  /** Gets the pointer to the final index in a multidimensional array */
  IIR_TypeDefinition *_get_final_subtype();
  IIR *_clone();
  virtual void _clone( IIR *my_clone );

  /** Gets number of indexes in an array */
  IIR_Int32 _get_num_indexes();

protected:
  IIRScram_ArrayNatureDefinition();
  virtual ~IIRScram_ArrayNatureDefinition() = 0;

private:
  static IIR_ArraySubnatureDefinition *_construct_unconstrained( IIR_ScalarTypeDefinition *, 
                                                                 IIR_NatureDefinition *, 
                                                                 IIR_NatureDeclaration * );

  static IIR_ArraySubnatureDefinition *_construct_constrained( IIR_ScalarTypeDefinition *,
                                                               IIR_NatureDefinition *,
                                                               IIR_NatureDeclaration * );
};
#endif
