
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Narayanan Thondugulam 
//          Umesh Kumar V. Rajasekaran
//          Timothy J. McBrayer 
//          Krishnan Subramani  
//          Magnus Danielson    cfmd@swipnet.se

#include "IIR_DesignatorExplicit.hh"
#include "IIR_Signature.hh"
#include "IIR_AboveAttribute.hh"
#include "set.hh"
#include "resolution_func.hh"
#include "published_file.hh"
using std::cerr;

IIRScram_DesignatorExplicit::~IIRScram_DesignatorExplicit() {}

void 
IIRScram_DesignatorExplicit::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_name()->_is_resolved() == TRUE);
  get_name()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_DesignatorExplicit::_publish_cc_entity_class( published_file &_cc_out ){
  _publish_entity_class( _cc_out.get_stream() );
}

void 
IIRScram_DesignatorExplicit::_publish_vhdl_entity_class( ostream &_vhdl_out ){
  _publish_entity_class( _vhdl_out );
}

void 
IIRScram_DesignatorExplicit::_publish_entity_class( ostream &os ) {
  IIR_Declaration *decl = NULL;
  ASSERT(get_name()->_is_resolved() == TRUE);
  ASSERT(get_name()->_is_iir_declaration() == TRUE);

  decl = (IIR_Declaration*)get_name();
  switch (decl->_get_type()) {
  case IIRScram_Declaration::VARIABLE:
  case IIRScram_Declaration::SHARED_VARIABLE:
  case IIRScram_Declaration::INTERFACE_VARIABLE:
    os << "variable";
    break;
  case IIRScram_Declaration::TYPE:
    os << "type";
    break;
  case IIRScram_Declaration::SUBTYPE:
    os << "subtype";
    break;
  case IIRScram_Declaration::SIGNAL:
  case IIRScram_Declaration::INTERFACE_SIGNAL:
    os << "signal";
    break;
  case IIRScram_Declaration::PROCEDURE:
    os << "procedure";
    break;
  case IIRScram_Declaration::FUNCTION:
    os << "function";
    break;
  case IIRScram_Declaration::S_FILE:
  case IIRScram_Declaration::INTERFACE_FILE:
    os << "file";
    break;
  case IIRScram_Declaration::ENTITY:
    os << "entity";
    break;
  case IIRScram_Declaration::CONSTANT:
  case IIRScram_Declaration::INTERFACE_CONSTANT:
    os << "constant";
    break;
  case IIRScram_Declaration::CONFIGURATION:
    os << "configuration";
    break;
  case IIRScram_Declaration::COMPONENT:
    os << "component";
    break;
  case IIRScram_Declaration::ARCHITECTURE:
    os << "architecture";
    break;
  case IIRScram_Declaration::PACKAGE_DT:
    os << "package";
    break;
  case IIRScram_Declaration::LABEL:
    os << "label";
    break;
  case IIRScram_Declaration::LITERAL:
    os << "literal";
    break;
  case IIRScram_Declaration::UNITS:
    os << "units";
    break;
  case IIRScram_Declaration::GROUP:
    os << "group";
    break;
  default:
    cerr << "Oops!  Unsopported entity class in "
	 << "IIRScram_DesignatorExplicit::_publish_cc_entity_class\n";
    abort();
  }
}

IIR *
IIRScram_DesignatorExplicit::_get_name() {
  return get_name();
}

void
IIRScram_DesignatorExplicit::_publish_cc_elaborate( published_file &_cc_out ){
  get_name()->_publish_cc_elaborate( _cc_out );
}

void
IIRScram_DesignatorExplicit::_publish_cc_lvalue( published_file &_cc_out ) {
  get_name()->_publish_cc_lvalue( _cc_out );
}

void
IIRScram_DesignatorExplicit::_publish_cc_designator( published_file &_cc_out ) {
  get_name()->_publish_cc_declarator( _cc_out );
}

void 
IIRScram_DesignatorExplicit::_add_decl_into_cgen_symbol_table() {
  ASSERT(get_name() != NULL);
  ASSERT(get_name()->_is_resolved() == TRUE);
  get_name()->_add_decl_into_cgen_symbol_table();
}

void
IIRScram_DesignatorExplicit::_get_list_of_input_signals( set<IIR> *list ){
  if( get_name() && get_name()->_is_signal() == TRUE ){
    get_name()->_get_list_of_input_signals( list );
  }
}

set<IIR_TypeDefinition> *
IIRScram_DesignatorExplicit::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  set<IIR_TypeDefinition> *retval = NULL;

  if( get_signature() == NULL ){
    retval = get_name()->_get_rval_set(constraint_function);
  }
  else{
    set<IIR_Declaration> *possible_decls;
    possible_decls = get_name()->_symbol_lookup();

    resolve_subprogram_decls( possible_decls,
			      get_signature() );

    if( possible_decls->num_elements() != 0 ){
      retval = new set<IIR_TypeDefinition>;
      IIR_Declaration *current_decl = possible_decls->get_element();
      while( current_decl != NULL ){
	retval->add( current_decl->get_subtype() );
	current_decl = possible_decls->get_next_element();
      }
    }
    
  }

  return retval;
}

set<IIR_Declaration> *
IIRScram_DesignatorExplicit::_symbol_lookup(){
  set<IIR_Declaration> *retval = NULL;

  if( get_signature() == NULL ){
    retval = get_name()->_symbol_lookup();
  }
  else{
    set<IIR_Declaration> *possible_decls;
    possible_decls = get_name()->_symbol_lookup();

    resolve_subprogram_decls( possible_decls,
			      get_signature() );

    if( possible_decls->num_elements() != 0 ){
      retval = new set<IIR_Declaration>;
      IIR_Declaration *current_decl = possible_decls->get_element();
      while( current_decl != NULL ){
	retval->add( current_decl );
	current_decl = possible_decls->get_next_element();
      }
    }
    
  }

  return retval;
}

IIR*
IIRScram_DesignatorExplicit::_clone() {
  IIR_Signature *sig = NULL;
  IIR *name = NULL;
  IIR_DesignatorExplicit *clone = new IIR_DesignatorExplicit;
  IIRScram::_clone(clone);

  name = get_name()->_clone();
  clone->set_name(name);

  if (get_signature() != NULL) {

    sig = (IIR_Signature*)((IIR *)get_signature())->_clone();
  }
  clone->set_signature(sig);

  return clone;
}

IIR *
IIRScram_DesignatorExplicit::_semantic_transform( set<IIR_TypeDefinition> *transform_set ){
  set_name( get_name()->_semantic_transform( transform_set ) );
  return this;
}

void 
IIRScram_DesignatorExplicit::_type_check( set<IIR_TypeDefinition> *check_set ){
  get_name()->_type_check( check_set );
}

IIR *
IIRScram_DesignatorExplicit::_rval_to_decl( IIR_TypeDefinition *my_type ){
  set_name( get_name()->_rval_to_decl( my_type ) );
  
  return this;
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_resolved(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_resolved();
}

ostream &
IIRScram_DesignatorExplicit::_print( ostream &os ){
  ASSERT( get_name() != NULL );
  return get_name()->_print( os );
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_locally_static(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_locally_static();
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_globally_static(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_locally_static();
}

IIR_Boolean 
IIRScram_DesignatorExplicit::_is_signal(){
  ASSERT( get_name() != NULL );
  return get_name()->_is_signal();
}

IIR_SignalKind 
IIRScram_DesignatorExplicit::_get_signal_kind(){
  ASSERT( get_name() != NULL );
  return get_name()->_get_signal_kind();
}

IIR_Boolean
IIRScram_DesignatorExplicit::_is_above_attribute_found() {
  return get_name()->_is_above_attribute_found();
}

void
IIRScram_DesignatorExplicit::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  get_name()->_build_above_attribute_set(to_build);
}

visitor_return_type *IIRScram_DesignatorExplicit::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_DesignatorExplicit(this, arg);
};
