#   Simple Backup - GTK+ GUI resources
#
#   Copyright (c)2010: Jean-Peer Lorenz <peer.loz@gmx.net>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#


CONFIGGUI_TOPWINDOW = 'sbackupConfApp'
CONFIGGUI_GLADEFILE = 'sbackup-config.glade'

RESTOREGUI_TOPWINDOW = 'restorewindow'
RESTOREGUI_GLADEFILE = 'sbackup-restore.glade'


def get_configgui_widgets():
    widget_list = [
        'sbackupConfApp',
        'menubar',
        'toolbar',
        'askSaveDialog',
        'fusehelplabel',
        'regexdialog',
        'ftypedialog',
        'dialog-vbox4',
        'vbox18',
        'ftype_st',
        'ftype_box',
        'hbox25',
        'ftype_custom',
        'ftype_custom_ex',
        'cancelbutton',
        'okbutton',
        'dialog-vbox5',
        'vbox19',
        'regex_box',
        'cancelbutton2',
        'okbutton2',
        'statusBar',
        'vbox17',
        'save',
        'save_as',
        'saveButton',
        'exit',
        'imagemenuitem6',
        'imagemenuitem7',
        'imagemenuitem8',
        'imagemenuitem9',
        'about',
        'vbox1',
        'notebook',
#
# general/main page
        'label_general_page',
        'vbox_general_page',
        'cformat',
        'splitsizeCB',
        'splitsizeSB',
        'splitsizevbox',
        'label_splitsize_custom',
#
        'vbox3',
        'scrolledwindow1',
        'includetv',
        'inc_addfile',
        'hbox4',
        'inc_adddir',
        'hbox5',
        'inc_del',
        'notebook2',
        'vbox4',
        'scrolledwindow2',
        'ex_pathstv',
        'ex_addfile1',
        'hbox6',
        'ex_adddir',
        'hbox7',
        'ex_delpath',
        'vbox5',
        'scrolledwindow3',
        'ex_ftypetv',
        'ex_addftype',
        'ex_delftype',
        'vbox6',
        'scrolledwindow4',
        'ex_regextv',
        'ex_addregex',
        'ex_delregex',
        'vbox7',
        'hbox8',
        'ex_max',
        'ex_maxsize',
        'vbox_destination_page',
        'dest1',
        'dest2',
        'label_default_target',
        'hbox9',
        'dest_localpath',
        'dest3',
        'hbox10',
        'dest_remote',
#            'dest_remotetest',
        'dest_remote_light',
        'hbox11',
        'dest_unusable',
#
#            schedule page
        'label_schedule_page',
        'vbox_schedule_page',
        'table_schedule',
        'rdbtn_no_schedule',
        'rdbtn_simple_schedule',
        'rdbtn_custom_schedule',
        'label_simple_schedule_freq',
        'label_custom_cronline',
        'txtfld_custom_cronline',
        'cmbbx_simple_schedule_freq',
        'lnkbtn_help_schedule',
        'hbox_schedule_footer',
        'hbox_schedule_infotext',
        'img_schedule_infotext',
        'label_schedule_infotext',
#
        'time_maxinc',
        'purgevbox',
        'purgecheckbox',
        'hbox16',
        'purgeradiobutton',
        'purgedays',
        'purgelabel',
        'hbox17',
        'logpurgeradiobutton',
        'purgelabel2',
        'hbox18',
        'reportvbox',
        'hbox19',
        'table2',
        'loglevelcombobox',
        'logfilechooser',
        'hbox20',
        'vbox11',
        'vbox12',
        'table3',
        'smtpport',
        'smtpserver',
        'smtpto',
        'smtpfrom',
        'hbox21',
        'testMailButton',
        'vbox13',
        'vbox14',
        'smtplogincheckbox',
        'smtplogininfo',
        'smtppassword',
        'smtplogin',
        'vbox15',
        'TLScheckbutton',
        'TLSinfos',
        'TLSradiobutton',
        'SSLradiobutton',
        'crtfilechooser',
        'keyfilechooser',
        'label_certificate',
        'label_key',
#
        'pluginscombobox',
        'ProfileManagerDialog',
        'profilesListTreeView',
        'addProfileButton',
        'removeProfileButton',
        'editProfileButton',
        'closeProfileManagerButton',
        'askNewPrfNameDialog',
        'enableNewPrfCB',
        'newPrfNameEntry',
        'followlinks',
# dialog set default settings
        'dialog_default_settings',
        'label_dialog_default_settings_content',
        'btn_set_default_settings',
        'btn_cancel_default_settings',
#
# dialog set remote destination
        'dialog_connect_remote',
        'btn_set_remote',
        'btn_cancel_remote',
        'btn_connect_remote',
        'cmb_set_remote_service',
        'entry_set_remote_server',
        'entry_set_remote_port',
        'entry_set_remote_dir',
        'entry_set_remote_user',
        'entry_set_remote_pass',
        'label_set_remote_user',
        'label_set_remote_pass',
        'checkbtn_show_password',
# dialog make backup
        'dialog_make_backup',
        'checkbtn_make_backup_full',
        'btn_make_backup',
        'btn_cancel_make_backup'
        ]
    return widget_list


def get_configgui_handlers():
    handlers = [
        'on_ftype_toggled',
        'on_ftype_st_box_changed',
        'on_ftype_custom_ex_changed',
        'on_save_activate',
        'on_save_as_activate',
        'on_exit_activate',
        'on_prfManager_activate',
        'on_menu_about_activate',
        'on_menu_help_activate',
        'on_reload_clicked',
        'on_save_clicked',
        'on_backup_clicked',
        'on_cformat_changed',
        'on_splitsizeCB_changed',
        'on_splitsizeSB_value_changed',
        'on_inc_addfile_clicked',
        'on_inc_adddir_clicked',
        'on_inc_del_clicked',
        'on_ex_addfile_clicked',
        'on_ex_adddir_clicked',
        'on_ex_delpath_clicked',
        'on_ex_addftype_clicked',
        'on_ex_delftype_clicked',
        'on_ex_addregex_clicked',
        'on_ex_delregex_clicked',
        'on_ex_max_toggled',
        'on_ex_maxsize_changed',
        'on_dest1_toggled',
        'on_dest_localpath_selection_changed',
#     connect to remote host
        'on_btn_set_remote_clicked',
        'on_cmb_set_remote_service_changed',
        'on_checkbtn_show_password_toggled',
#     scheduling
        'on_cmbbx_simple_schedule_freq_changed',
        'on_rdbtn_schedule_toggled',
        'on_txtfld_custom_cronline_changed',
#
        'on_time_maxinc_changed',
        'on_purgecheckbox_toggled',
        'on_purgeradiobutton_toggled',
        'on_purgedays_changed',
        'on_logfilechooser_selection_changed',
        'on_loglevelcombobox_changed',
        'on_smtpfrom_changed',
        'on_smtpto_changed',
        'on_smtpserver_changed',
        'on_smtpport_changed',
        'on_testMailButton_clicked',
        'on_smtplogincheckbox_toggled',
        'on_smtplogin_changed',
        'on_smtppassword_changed',
        'on_TLScheckbutton_toggled',
        'on_TLSradiobutton_toggled',
        'on_crtfilechooser_selection_changed',
        'on_keyfilechooser_selection_changed',
        'on_addProfileButton_clicked',
        'on_removeProfileButton_clicked',
        'on_editProfileButton_clicked',
        'on_closeProfileManagerButton_clicked',
        'on_includetv_key_press_event',
        'on_ex_pathstv_key_press_event',
        'on_ex_ftypetv_key_press_event',
        'on_ex_regextv_key_press_event',
        'on_followlinks_toggled',
#
        'on_menu_set_default_settings_activate',

        'on_exit_activate',
        'on_sbackupConfApp_delete_event',
        'on_sbackupConfApp_destroy'
        ]
    return handlers


def get_restoregui_widgets():
    widget_list = [
        'restorewindow',
        'defaultfolderlabel',
        'defaultradiob',
        'customradiob',
        'custominfos',
        'customentry',
        'customchooser',
        'customapply',
        'calendar',
        'snplist',
        'scrolledwindow1',
        'snplisttreeview',
        'snpdetails',
        'scrolledwindow2',
        'restoreExpander',
        'snpmanExpander',
        'filelisttreeview',
        'buttonspool',
        'restore',
        'restoreas',
        'revert',
        'revertas',
        'upgradeBox',
        'upgradeButton',
        'RebaseBox',
        'txt_current_base',
        'rebaseButton',
        'deleteBox',
        'deleteButton',
        'snphistoryFrame',
        'historytv',
        'statusbar',
        'progressbar',
        'box_management',
        'box_restorewin_content',
        'vbox_customdest'
        ]
    return widget_list


def get_restoregui_handlers():
    handlers = [
        'gtk_main_quit',
        'on_defaultradiob_toggled',
        'on_customchooser_clicked',
        'on_customapply_clicked',
        'on_calendar_month_changed',
        'on_calendar_day_selected',
        'on_snplisttreeview_cursor_changed',
        'on_filelisttreeview_row_expanded',
        'on_filelisttreeview_cursor_changed',
        'on_filelisttreeview_unselect_all',
        'on_restore_clicked',
        'on_restoreas_clicked',
        'on_revert_clicked',
        'on_revertas_clicked',
        'on_restoreExpander_activate',
        'on_snpmanExpander_activate',
        'on_upgradeButton_clicked',
        'on_rebaseButton_toggled',
        'on_deleteButton_clicked',
        'on_exportmanExpander_activate'
        ]
    return handlers

