#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <net/if.h>
#include <netinet/tcp.h>
#include <sys/mman.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <netdb.h>
#include <errno.h>
#include <dirent.h>
#include <signal.h>
#include <unistd.h>
#include <termios.h>
#define SIGNEDP(x) (((x)-1)<0)
#define SIGNED_(x) (SIGNEDP(x)?"":"un")
int main() {
    printf ("(cl:in-package #:SB-POSIX)\n");
    printf ("(cl:eval-when (:compile-toplevel)\n");
    printf ("  (cl:defparameter *integer-sizes* (cl:make-hash-table))\n");
    printf ("  (cl:setf (cl:gethash %d *integer-sizes*) 'sb-alien:char)\n", sizeof(char));
    printf ("  (cl:setf (cl:gethash %d *integer-sizes*) 'sb-alien:short)\n", sizeof(short));
    printf ("  (cl:setf (cl:gethash %d *integer-sizes*) 'sb-alien:long)\n", sizeof(long));
    printf ("  (cl:setf (cl:gethash %d *integer-sizes*) 'sb-alien:int)\n", sizeof(int));
    printf (")\n");
#ifdef AF_INET
    printf ("(cl:defconstant AF-INET %d \"IP Protocol family\")\n", AF_INET);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for AF_INET (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'AF-INET)\n");
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type UID-T (sb-alien:%ssigned %d)))\n", SIGNED_(uid_t), (8*sizeof(uid_t)));
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type GID-T (sb-alien:%ssigned %d)))\n", SIGNED_(gid_t), (8*sizeof(gid_t)));
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type PID-T (sb-alien:%ssigned %d)))\n", SIGNED_(pid_t), (8*sizeof(pid_t)));
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type INO-T (sb-alien:%ssigned %d)))\n", SIGNED_(ino_t), (8*sizeof(ino_t)));
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type NLINK-T (sb-alien:%ssigned %d)))\n", SIGNED_(nlink_t), (8*sizeof(nlink_t)));
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type TIME-T (sb-alien:%ssigned %d)))\n", SIGNED_(time_t), (8*sizeof(time_t)));
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type DEV-T (sb-alien:%ssigned %d)))\n", SIGNED_(dev_t), (8*sizeof(dev_t)));
#ifdef SIGHUP
    printf ("(cl:defconstant SIGHUP %d \"terminal line hangup.\")\n", SIGHUP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGHUP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGHUP)\n");
#ifdef SIGINT
    printf ("(cl:defconstant SIGINT %d \"interrupt program.\")\n", SIGINT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGINT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGINT)\n");
#ifdef SIGQUIT
    printf ("(cl:defconstant SIGQUIT %d \"quit program.\")\n", SIGQUIT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGQUIT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGQUIT)\n");
#ifdef SIGILL
    printf ("(cl:defconstant SIGILL %d \"illegal instruction.\")\n", SIGILL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGILL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGILL)\n");
#ifdef SIGTRAP
    printf ("(cl:defconstant SIGTRAP %d \"trace trap.\")\n", SIGTRAP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGTRAP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGTRAP)\n");
#ifdef SIGABRT
    printf ("(cl:defconstant SIGABRT %d \"abort program (formerly SIGIOT).\")\n", SIGABRT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGABRT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGABRT)\n");
#ifdef SIGEMT
    printf ("(cl:defconstant SIGEMT %d \"emulate instruction executed.\")\n", SIGEMT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGEMT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGEMT)\n");
#ifdef SIGFPE
    printf ("(cl:defconstant SIGFPE %d \"floating-point exception.\")\n", SIGFPE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGFPE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGFPE)\n");
#ifdef SIGKILL
    printf ("(cl:defconstant SIGKILL %d \"kill program.\")\n", SIGKILL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGKILL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGKILL)\n");
#ifdef SIGBUS
    printf ("(cl:defconstant SIGBUS %d \"bus error.\")\n", SIGBUS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGBUS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGBUS)\n");
#ifdef SIGSEGV
    printf ("(cl:defconstant SIGSEGV %d \"segmentation violation.\")\n", SIGSEGV);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGSEGV (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGSEGV)\n");
#ifdef SIGSYS
    printf ("(cl:defconstant SIGSYS %d \"non-existent system call invoked.\")\n", SIGSYS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGSYS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGSYS)\n");
#ifdef SIGPIPE
    printf ("(cl:defconstant SIGPIPE %d \"write on a pipe with no reader.\")\n", SIGPIPE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGPIPE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGPIPE)\n");
#ifdef SIGALRM
    printf ("(cl:defconstant SIGALRM %d \"real-time timer expired.\")\n", SIGALRM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGALRM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGALRM)\n");
#ifdef SIGTERM
    printf ("(cl:defconstant SIGTERM %d \"software termination signal.\")\n", SIGTERM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGTERM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGTERM)\n");
#ifdef SIGURG
    printf ("(cl:defconstant SIGURG %d \"urgent condition present on socket.\")\n", SIGURG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGURG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGURG)\n");
#ifdef SIGSTOP
    printf ("(cl:defconstant SIGSTOP %d \"stop (cannot be caught or ignored).\")\n", SIGSTOP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGSTOP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGSTOP)\n");
#ifdef SIGTSTP
    printf ("(cl:defconstant SIGTSTP %d \"stop signal generated from keyboard.\")\n", SIGTSTP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGTSTP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGTSTP)\n");
#ifdef SIGCONT
    printf ("(cl:defconstant SIGCONT %d \"continue after stop.\")\n", SIGCONT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGCONT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGCONT)\n");
#ifdef SIGCHLD
    printf ("(cl:defconstant SIGCHLD %d \"child status has changed.\")\n", SIGCHLD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGCHLD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGCHLD)\n");
#ifdef SIGTTIN
    printf ("(cl:defconstant SIGTTIN %d \"background read attempted from control terminal.\")\n", SIGTTIN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGTTIN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGTTIN)\n");
#ifdef SIGTTOU
    printf ("(cl:defconstant SIGTTOU %d \"background write attempted to control terminal.\")\n", SIGTTOU);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGTTOU (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGTTOU)\n");
#ifdef SIGIO
    printf ("(cl:defconstant SIGIO %d \"I/O is possible on a descriptor (see fcntl(2)).\")\n", SIGIO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGIO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGIO)\n");
#ifdef SIGXCPU
    printf ("(cl:defconstant SIGXCPU %d \"cpu time limit exceeded (see setrlimit(2)).\")\n", SIGXCPU);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGXCPU (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGXCPU)\n");
#ifdef SIGXFSZ
    printf ("(cl:defconstant SIGXFSZ %d \"file size limit exceeded (see setrlimit(2)).\")\n", SIGXFSZ);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGXFSZ (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGXFSZ)\n");
#ifdef SIGVTALRM
    printf ("(cl:defconstant SIGVTALRM %d \"virtual time alarm (see setitimer(2)).\")\n", SIGVTALRM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGVTALRM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGVTALRM)\n");
#ifdef SIGPROF
    printf ("(cl:defconstant SIGPROF %d \"profiling timer alarm (see setitimer(2)).\")\n", SIGPROF);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGPROF (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGPROF)\n");
#ifdef SIGWINCH
    printf ("(cl:defconstant SIGWINCH %d \"Window size change.\")\n", SIGWINCH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGWINCH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGWINCH)\n");
#ifdef SIGINFO
    printf ("(cl:defconstant SIGINFO %d \"status request from keyboard.\")\n", SIGINFO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGINFO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGINFO)\n");
#ifdef SIGUSR1
    printf ("(cl:defconstant SIGUSR1 %d \"User defined signal 1.\")\n", SIGUSR1);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGUSR1 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGUSR1)\n");
#ifdef SIGUSR2
    printf ("(cl:defconstant SIGUSR2 %d \"User defined signal 2.\")\n", SIGUSR2);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGUSR2 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGUSR2)\n");
#ifdef SIGRTMIN
    printf ("(cl:defconstant SIGRTMIN %d \"Smallest real-time signal number.\")\n", SIGRTMIN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGRTMIN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGRTMIN)\n");
#ifdef SIGRTMAX
    printf ("(cl:defconstant SIGRTMAX %d \"Largest real-time signal number.\")\n", SIGRTMAX);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SIGRTMAX (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SIGRTMAX)\n");
#ifdef EPERM
    printf ("(cl:defconstant EPERM %d \"NIL\")\n", EPERM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EPERM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EPERM)\n");
#ifdef ENOENT
    printf ("(cl:defconstant ENOENT %d \"NIL\")\n", ENOENT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOENT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOENT)\n");
#ifdef ESRCH
    printf ("(cl:defconstant ESRCH %d \"NIL\")\n", ESRCH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ESRCH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ESRCH)\n");
#ifdef EINTR
    printf ("(cl:defconstant EINTR %d \"NIL\")\n", EINTR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EINTR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EINTR)\n");
#ifdef EIO
    printf ("(cl:defconstant EIO %d \"NIL\")\n", EIO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EIO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EIO)\n");
#ifdef ENXIO
    printf ("(cl:defconstant ENXIO %d \"NIL\")\n", ENXIO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENXIO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENXIO)\n");
#ifdef E2BIG
    printf ("(cl:defconstant E2BIG %d \"NIL\")\n", E2BIG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for E2BIG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'E2BIG)\n");
#ifdef ENOEXEC
    printf ("(cl:defconstant ENOEXEC %d \"NIL\")\n", ENOEXEC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOEXEC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOEXEC)\n");
#ifdef EBADF
    printf ("(cl:defconstant EBADF %d \"NIL\")\n", EBADF);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBADF (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBADF)\n");
#ifdef ECHILD
    printf ("(cl:defconstant ECHILD %d \"NIL\")\n", ECHILD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECHILD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECHILD)\n");
#ifdef EAGAIN
    printf ("(cl:defconstant EAGAIN %d \"NIL\")\n", EAGAIN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EAGAIN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EAGAIN)\n");
#ifdef ENOMEM
    printf ("(cl:defconstant ENOMEM %d \"NIL\")\n", ENOMEM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOMEM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOMEM)\n");
#ifdef EACCES
    printf ("(cl:defconstant EACCES %d \"NIL\")\n", EACCES);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EACCES (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EACCES)\n");
#ifdef EFAULT
    printf ("(cl:defconstant EFAULT %d \"NIL\")\n", EFAULT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EFAULT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EFAULT)\n");
#ifdef ENOTBLK
    printf ("(cl:defconstant ENOTBLK %d \"NIL\")\n", ENOTBLK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTBLK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTBLK)\n");
#ifdef EBUSY
    printf ("(cl:defconstant EBUSY %d \"NIL\")\n", EBUSY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBUSY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBUSY)\n");
#ifdef EEXIST
    printf ("(cl:defconstant EEXIST %d \"NIL\")\n", EEXIST);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EEXIST (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EEXIST)\n");
#ifdef EXDEV
    printf ("(cl:defconstant EXDEV %d \"NIL\")\n", EXDEV);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EXDEV (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EXDEV)\n");
#ifdef ENODEV
    printf ("(cl:defconstant ENODEV %d \"NIL\")\n", ENODEV);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENODEV (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENODEV)\n");
#ifdef ENOTDIR
    printf ("(cl:defconstant ENOTDIR %d \"NIL\")\n", ENOTDIR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTDIR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTDIR)\n");
#ifdef EISDIR
    printf ("(cl:defconstant EISDIR %d \"NIL\")\n", EISDIR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EISDIR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EISDIR)\n");
#ifdef EINVAL
    printf ("(cl:defconstant EINVAL %d \"NIL\")\n", EINVAL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EINVAL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EINVAL)\n");
#ifdef ENFILE
    printf ("(cl:defconstant ENFILE %d \"NIL\")\n", ENFILE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENFILE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENFILE)\n");
#ifdef EMFILE
    printf ("(cl:defconstant EMFILE %d \"NIL\")\n", EMFILE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EMFILE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EMFILE)\n");
#ifdef ENOTTY
    printf ("(cl:defconstant ENOTTY %d \"NIL\")\n", ENOTTY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTTY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTTY)\n");
#ifdef ETXTBSY
    printf ("(cl:defconstant ETXTBSY %d \"NIL\")\n", ETXTBSY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ETXTBSY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ETXTBSY)\n");
#ifdef EFBIG
    printf ("(cl:defconstant EFBIG %d \"NIL\")\n", EFBIG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EFBIG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EFBIG)\n");
#ifdef ENOSPC
    printf ("(cl:defconstant ENOSPC %d \"NIL\")\n", ENOSPC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOSPC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOSPC)\n");
#ifdef ESPIPE
    printf ("(cl:defconstant ESPIPE %d \"NIL\")\n", ESPIPE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ESPIPE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ESPIPE)\n");
#ifdef EROFS
    printf ("(cl:defconstant EROFS %d \"NIL\")\n", EROFS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EROFS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EROFS)\n");
#ifdef EMLINK
    printf ("(cl:defconstant EMLINK %d \"NIL\")\n", EMLINK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EMLINK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EMLINK)\n");
#ifdef EPIPE
    printf ("(cl:defconstant EPIPE %d \"NIL\")\n", EPIPE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EPIPE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EPIPE)\n");
#ifdef EDOM
    printf ("(cl:defconstant EDOM %d \"NIL\")\n", EDOM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EDOM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EDOM)\n");
#ifdef ERANGE
    printf ("(cl:defconstant ERANGE %d \"NIL\")\n", ERANGE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ERANGE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ERANGE)\n");
#ifdef EDEADLK
    printf ("(cl:defconstant EDEADLK %d \"NIL\")\n", EDEADLK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EDEADLK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EDEADLK)\n");
#ifdef ENAMETOOLONG
    printf ("(cl:defconstant ENAMETOOLONG %d \"NIL\")\n", ENAMETOOLONG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENAMETOOLONG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENAMETOOLONG)\n");
#ifdef ENOLCK
    printf ("(cl:defconstant ENOLCK %d \"NIL\")\n", ENOLCK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOLCK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOLCK)\n");
#ifdef ENOSYS
    printf ("(cl:defconstant ENOSYS %d \"NIL\")\n", ENOSYS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOSYS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOSYS)\n");
#ifdef ENOTEMPTY
    printf ("(cl:defconstant ENOTEMPTY %d \"NIL\")\n", ENOTEMPTY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTEMPTY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTEMPTY)\n");
#ifdef ELOOP
    printf ("(cl:defconstant ELOOP %d \"NIL\")\n", ELOOP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ELOOP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ELOOP)\n");
#ifdef EWOULDBLOCK
    printf ("(cl:defconstant EWOULDBLOCK %d \"NIL\")\n", EWOULDBLOCK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EWOULDBLOCK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EWOULDBLOCK)\n");
#ifdef ENOMSG
    printf ("(cl:defconstant ENOMSG %d \"NIL\")\n", ENOMSG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOMSG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOMSG)\n");
#ifdef EIDRM
    printf ("(cl:defconstant EIDRM %d \"NIL\")\n", EIDRM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EIDRM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EIDRM)\n");
#ifdef ECHRNG
    printf ("(cl:defconstant ECHRNG %d \"NIL\")\n", ECHRNG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECHRNG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECHRNG)\n");
#ifdef EL2NSYNC
    printf ("(cl:defconstant EL2NSYNC %d \"NIL\")\n", EL2NSYNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EL2NSYNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EL2NSYNC)\n");
#ifdef EL3HLT
    printf ("(cl:defconstant EL3HLT %d \"NIL\")\n", EL3HLT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EL3HLT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EL3HLT)\n");
#ifdef EL3RST
    printf ("(cl:defconstant EL3RST %d \"NIL\")\n", EL3RST);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EL3RST (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EL3RST)\n");
#ifdef ELNRNG
    printf ("(cl:defconstant ELNRNG %d \"NIL\")\n", ELNRNG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ELNRNG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ELNRNG)\n");
#ifdef EUNATCH
    printf ("(cl:defconstant EUNATCH %d \"NIL\")\n", EUNATCH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EUNATCH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EUNATCH)\n");
#ifdef ENOCSI
    printf ("(cl:defconstant ENOCSI %d \"NIL\")\n", ENOCSI);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOCSI (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOCSI)\n");
#ifdef EL2HLT
    printf ("(cl:defconstant EL2HLT %d \"NIL\")\n", EL2HLT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EL2HLT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EL2HLT)\n");
#ifdef EBADE
    printf ("(cl:defconstant EBADE %d \"NIL\")\n", EBADE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBADE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBADE)\n");
#ifdef EBADR
    printf ("(cl:defconstant EBADR %d \"NIL\")\n", EBADR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBADR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBADR)\n");
#ifdef EXFULL
    printf ("(cl:defconstant EXFULL %d \"NIL\")\n", EXFULL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EXFULL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EXFULL)\n");
#ifdef ENOANO
    printf ("(cl:defconstant ENOANO %d \"NIL\")\n", ENOANO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOANO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOANO)\n");
#ifdef EBADRQC
    printf ("(cl:defconstant EBADRQC %d \"NIL\")\n", EBADRQC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBADRQC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBADRQC)\n");
#ifdef EBADSLT
    printf ("(cl:defconstant EBADSLT %d \"NIL\")\n", EBADSLT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBADSLT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBADSLT)\n");
#ifdef EDEADLOCK
    printf ("(cl:defconstant EDEADLOCK %d \"NIL\")\n", EDEADLOCK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EDEADLOCK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EDEADLOCK)\n");
#ifdef EBFONT
    printf ("(cl:defconstant EBFONT %d \"NIL\")\n", EBFONT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBFONT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBFONT)\n");
#ifdef ENOSTR
    printf ("(cl:defconstant ENOSTR %d \"NIL\")\n", ENOSTR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOSTR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOSTR)\n");
#ifdef ENODATA
    printf ("(cl:defconstant ENODATA %d \"NIL\")\n", ENODATA);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENODATA (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENODATA)\n");
#ifdef ETIME
    printf ("(cl:defconstant ETIME %d \"NIL\")\n", ETIME);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ETIME (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ETIME)\n");
#ifdef ENOSR
    printf ("(cl:defconstant ENOSR %d \"NIL\")\n", ENOSR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOSR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOSR)\n");
#ifdef ENONET
    printf ("(cl:defconstant ENONET %d \"NIL\")\n", ENONET);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENONET (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENONET)\n");
#ifdef ENOPKG
    printf ("(cl:defconstant ENOPKG %d \"NIL\")\n", ENOPKG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOPKG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOPKG)\n");
#ifdef EREMOTE
    printf ("(cl:defconstant EREMOTE %d \"NIL\")\n", EREMOTE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EREMOTE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EREMOTE)\n");
#ifdef ENOLINK
    printf ("(cl:defconstant ENOLINK %d \"NIL\")\n", ENOLINK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOLINK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOLINK)\n");
#ifdef EADV
    printf ("(cl:defconstant EADV %d \"NIL\")\n", EADV);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EADV (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EADV)\n");
#ifdef ESRMNT
    printf ("(cl:defconstant ESRMNT %d \"NIL\")\n", ESRMNT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ESRMNT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ESRMNT)\n");
#ifdef ECOMM
    printf ("(cl:defconstant ECOMM %d \"NIL\")\n", ECOMM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECOMM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECOMM)\n");
#ifdef EPROTO
    printf ("(cl:defconstant EPROTO %d \"NIL\")\n", EPROTO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EPROTO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EPROTO)\n");
#ifdef EMULTIHOP
    printf ("(cl:defconstant EMULTIHOP %d \"NIL\")\n", EMULTIHOP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EMULTIHOP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EMULTIHOP)\n");
#ifdef EDOTDOT
    printf ("(cl:defconstant EDOTDOT %d \"NIL\")\n", EDOTDOT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EDOTDOT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EDOTDOT)\n");
#ifdef EBADMSG
    printf ("(cl:defconstant EBADMSG %d \"NIL\")\n", EBADMSG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBADMSG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBADMSG)\n");
#ifdef EOVERFLOW
    printf ("(cl:defconstant EOVERFLOW %d \"NIL\")\n", EOVERFLOW);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EOVERFLOW (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EOVERFLOW)\n");
#ifdef ENOTUNIQ
    printf ("(cl:defconstant ENOTUNIQ %d \"NIL\")\n", ENOTUNIQ);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTUNIQ (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTUNIQ)\n");
#ifdef EBADFD
    printf ("(cl:defconstant EBADFD %d \"NIL\")\n", EBADFD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EBADFD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EBADFD)\n");
#ifdef EREMCHG
    printf ("(cl:defconstant EREMCHG %d \"NIL\")\n", EREMCHG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EREMCHG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EREMCHG)\n");
#ifdef ELIBACC
    printf ("(cl:defconstant ELIBACC %d \"NIL\")\n", ELIBACC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ELIBACC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ELIBACC)\n");
#ifdef ELIBBAD
    printf ("(cl:defconstant ELIBBAD %d \"NIL\")\n", ELIBBAD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ELIBBAD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ELIBBAD)\n");
#ifdef ELIBSCN
    printf ("(cl:defconstant ELIBSCN %d \"NIL\")\n", ELIBSCN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ELIBSCN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ELIBSCN)\n");
#ifdef ELIBMAX
    printf ("(cl:defconstant ELIBMAX %d \"NIL\")\n", ELIBMAX);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ELIBMAX (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ELIBMAX)\n");
#ifdef ELIBEXEC
    printf ("(cl:defconstant ELIBEXEC %d \"NIL\")\n", ELIBEXEC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ELIBEXEC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ELIBEXEC)\n");
#ifdef EILSEQ
    printf ("(cl:defconstant EILSEQ %d \"NIL\")\n", EILSEQ);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EILSEQ (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EILSEQ)\n");
#ifdef ERESTART
    printf ("(cl:defconstant ERESTART %d \"NIL\")\n", ERESTART);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ERESTART (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ERESTART)\n");
#ifdef ESTRPIPE
    printf ("(cl:defconstant ESTRPIPE %d \"NIL\")\n", ESTRPIPE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ESTRPIPE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ESTRPIPE)\n");
#ifdef EUSERS
    printf ("(cl:defconstant EUSERS %d \"NIL\")\n", EUSERS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EUSERS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EUSERS)\n");
#ifdef ENOTSOCK
    printf ("(cl:defconstant ENOTSOCK %d \"NIL\")\n", ENOTSOCK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTSOCK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTSOCK)\n");
#ifdef EDESTADDRREQ
    printf ("(cl:defconstant EDESTADDRREQ %d \"NIL\")\n", EDESTADDRREQ);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EDESTADDRREQ (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EDESTADDRREQ)\n");
#ifdef EMSGSIZE
    printf ("(cl:defconstant EMSGSIZE %d \"NIL\")\n", EMSGSIZE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EMSGSIZE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EMSGSIZE)\n");
#ifdef EPROTOTYPE
    printf ("(cl:defconstant EPROTOTYPE %d \"NIL\")\n", EPROTOTYPE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EPROTOTYPE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EPROTOTYPE)\n");
#ifdef ENOPROTOOPT
    printf ("(cl:defconstant ENOPROTOOPT %d \"NIL\")\n", ENOPROTOOPT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOPROTOOPT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOPROTOOPT)\n");
#ifdef EPROTONOSUPPORT
    printf ("(cl:defconstant EPROTONOSUPPORT %d \"NIL\")\n", EPROTONOSUPPORT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EPROTONOSUPPORT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EPROTONOSUPPORT)\n");
#ifdef ESOCKTNOSUPPORT
    printf ("(cl:defconstant ESOCKTNOSUPPORT %d \"NIL\")\n", ESOCKTNOSUPPORT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ESOCKTNOSUPPORT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ESOCKTNOSUPPORT)\n");
#ifdef EOPNOTSUPP
    printf ("(cl:defconstant EOPNOTSUPP %d \"NIL\")\n", EOPNOTSUPP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EOPNOTSUPP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EOPNOTSUPP)\n");
#ifdef EPFNOSUPPORT
    printf ("(cl:defconstant EPFNOSUPPORT %d \"NIL\")\n", EPFNOSUPPORT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EPFNOSUPPORT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EPFNOSUPPORT)\n");
#ifdef EAFNOSUPPORT
    printf ("(cl:defconstant EAFNOSUPPORT %d \"NIL\")\n", EAFNOSUPPORT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EAFNOSUPPORT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EAFNOSUPPORT)\n");
#ifdef EADDRINUSE
    printf ("(cl:defconstant EADDRINUSE %d \"NIL\")\n", EADDRINUSE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EADDRINUSE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EADDRINUSE)\n");
#ifdef EADDRNOTAVAIL
    printf ("(cl:defconstant EADDRNOTAVAIL %d \"NIL\")\n", EADDRNOTAVAIL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EADDRNOTAVAIL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EADDRNOTAVAIL)\n");
#ifdef ENETDOWN
    printf ("(cl:defconstant ENETDOWN %d \"NIL\")\n", ENETDOWN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENETDOWN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENETDOWN)\n");
#ifdef ENETUNREACH
    printf ("(cl:defconstant ENETUNREACH %d \"NIL\")\n", ENETUNREACH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENETUNREACH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENETUNREACH)\n");
#ifdef ENETRESET
    printf ("(cl:defconstant ENETRESET %d \"NIL\")\n", ENETRESET);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENETRESET (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENETRESET)\n");
#ifdef ECONNABORTED
    printf ("(cl:defconstant ECONNABORTED %d \"NIL\")\n", ECONNABORTED);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECONNABORTED (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECONNABORTED)\n");
#ifdef ECONNRESET
    printf ("(cl:defconstant ECONNRESET %d \"NIL\")\n", ECONNRESET);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECONNRESET (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECONNRESET)\n");
#ifdef ENOBUFS
    printf ("(cl:defconstant ENOBUFS %d \"NIL\")\n", ENOBUFS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOBUFS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOBUFS)\n");
#ifdef EISCONN
    printf ("(cl:defconstant EISCONN %d \"NIL\")\n", EISCONN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EISCONN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EISCONN)\n");
#ifdef ENOTCONN
    printf ("(cl:defconstant ENOTCONN %d \"NIL\")\n", ENOTCONN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTCONN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTCONN)\n");
#ifdef ESHUTDOWN
    printf ("(cl:defconstant ESHUTDOWN %d \"NIL\")\n", ESHUTDOWN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ESHUTDOWN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ESHUTDOWN)\n");
#ifdef ETOOMANYREFS
    printf ("(cl:defconstant ETOOMANYREFS %d \"NIL\")\n", ETOOMANYREFS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ETOOMANYREFS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ETOOMANYREFS)\n");
#ifdef ETIMEDOUT
    printf ("(cl:defconstant ETIMEDOUT %d \"NIL\")\n", ETIMEDOUT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ETIMEDOUT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ETIMEDOUT)\n");
#ifdef ECONNREFUSED
    printf ("(cl:defconstant ECONNREFUSED %d \"NIL\")\n", ECONNREFUSED);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECONNREFUSED (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECONNREFUSED)\n");
#ifdef EHOSTDOWN
    printf ("(cl:defconstant EHOSTDOWN %d \"NIL\")\n", EHOSTDOWN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EHOSTDOWN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EHOSTDOWN)\n");
#ifdef EHOSTUNREACH
    printf ("(cl:defconstant EHOSTUNREACH %d \"NIL\")\n", EHOSTUNREACH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EHOSTUNREACH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EHOSTUNREACH)\n");
#ifdef EALREADY
    printf ("(cl:defconstant EALREADY %d \"NIL\")\n", EALREADY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EALREADY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EALREADY)\n");
#ifdef EINPROGRESS
    printf ("(cl:defconstant EINPROGRESS %d \"NIL\")\n", EINPROGRESS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EINPROGRESS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EINPROGRESS)\n");
#ifdef ESTALE
    printf ("(cl:defconstant ESTALE %d \"NIL\")\n", ESTALE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ESTALE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ESTALE)\n");
#ifdef EUCLEAN
    printf ("(cl:defconstant EUCLEAN %d \"NIL\")\n", EUCLEAN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EUCLEAN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EUCLEAN)\n");
#ifdef ENOTNAM
    printf ("(cl:defconstant ENOTNAM %d \"NIL\")\n", ENOTNAM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOTNAM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOTNAM)\n");
#ifdef ENAVAIL
    printf ("(cl:defconstant ENAVAIL %d \"NIL\")\n", ENAVAIL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENAVAIL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENAVAIL)\n");
#ifdef EREMOTEIO
    printf ("(cl:defconstant EREMOTEIO %d \"NIL\")\n", EREMOTEIO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EREMOTEIO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EREMOTEIO)\n");
#ifdef EDQUOT
    printf ("(cl:defconstant EDQUOT %d \"NIL\")\n", EDQUOT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EDQUOT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EDQUOT)\n");
#ifdef ENOMEDIUM
    printf ("(cl:defconstant ENOMEDIUM %d \"NIL\")\n", ENOMEDIUM);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ENOMEDIUM (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ENOMEDIUM)\n");
#ifdef EMEDIUMTYPE
    printf ("(cl:defconstant EMEDIUMTYPE %d \"NIL\")\n", EMEDIUMTYPE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for EMEDIUMTYPE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'EMEDIUMTYPE)\n");
#ifdef WNOHANG
    printf ("(cl:defconstant WNOHANG %d \"NIL\")\n", WNOHANG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for WNOHANG (unknown to the C compiler).\")\n");
#endif
#ifdef WUNTRACED
    printf ("(cl:defconstant WUNTRACED %d \"NIL\")\n", WUNTRACED);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for WUNTRACED (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type MODE-T (sb-alien:%ssigned %d)))\n", SIGNED_(mode_t), (8*sizeof(mode_t)));
#ifdef S_ISUID
    printf ("(cl:defconstant S-ISUID %d \"NIL\")\n", S_ISUID);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_ISUID (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-ISUID)\n");
#ifdef S_ISGID
    printf ("(cl:defconstant S-ISGID %d \"NIL\")\n", S_ISGID);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_ISGID (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-ISGID)\n");
#ifdef S_ISVTX
    printf ("(cl:defconstant S-ISVTX %d \"NIL\")\n", S_ISVTX);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_ISVTX (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-ISVTX)\n");
#ifdef S_IRUSR
    printf ("(cl:defconstant S-IRUSR %d \"NIL\")\n", S_IRUSR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IRUSR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IRUSR)\n");
#ifdef S_IWUSR
    printf ("(cl:defconstant S-IWUSR %d \"NIL\")\n", S_IWUSR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IWUSR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IWUSR)\n");
#ifdef S_IXUSR
    printf ("(cl:defconstant S-IXUSR %d \"NIL\")\n", S_IXUSR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IXUSR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IXUSR)\n");
#ifdef S_IRUSR
    printf ("(cl:defconstant S-IREAD %d \"NIL\")\n", S_IRUSR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IRUSR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IREAD)\n");
#ifdef S_IWUSR
    printf ("(cl:defconstant S-IWRITE %d \"NIL\")\n", S_IWUSR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IWUSR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IWRITE)\n");
#ifdef S_IXUSR
    printf ("(cl:defconstant S-IEXEC %d \"NIL\")\n", S_IXUSR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IXUSR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IEXEC)\n");
#ifdef S_IRGRP
    printf ("(cl:defconstant S-IRGRP %d \"NIL\")\n", S_IRGRP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IRGRP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IRGRP)\n");
#ifdef S_IWGRP
    printf ("(cl:defconstant S-IWGRP %d \"NIL\")\n", S_IWGRP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IWGRP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IWGRP)\n");
#ifdef S_IXGRP
    printf ("(cl:defconstant S-IXGRP %d \"NIL\")\n", S_IXGRP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IXGRP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IXGRP)\n");
#ifdef S_IROTH
    printf ("(cl:defconstant S-IROTH %d \"NIL\")\n", S_IROTH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IROTH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IROTH)\n");
#ifdef S_IWOTH
    printf ("(cl:defconstant S-IWOTH %d \"NIL\")\n", S_IWOTH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IWOTH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IWOTH)\n");
#ifdef S_IXOTH
    printf ("(cl:defconstant S-IXOTH %d \"NIL\")\n", S_IXOTH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for S_IXOTH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'S-IXOTH)\n");
#ifdef R_OK
    printf ("(cl:defconstant R-OK %d \"NIL\")\n", R_OK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for R_OK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'R-OK)\n");
#ifdef W_OK
    printf ("(cl:defconstant W-OK %d \"NIL\")\n", W_OK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for W_OK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'W-OK)\n");
#ifdef X_OK
    printf ("(cl:defconstant X-OK %d \"NIL\")\n", X_OK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for X_OK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'X-OK)\n");
#ifdef F_OK
    printf ("(cl:defconstant F-OK %d \"NIL\")\n", F_OK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_OK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-OK)\n");
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type OFF-T (sb-alien:%ssigned %d)))\n", SIGNED_(off_t), (8*sizeof(off_t)));
#ifdef PROT_NONE
    printf ("(cl:defconstant PROT-NONE %d \"mmap: no protection\")\n", PROT_NONE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for PROT_NONE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'PROT-NONE)\n");
#ifdef PROT_READ
    printf ("(cl:defconstant PROT-READ %d \"mmap: read protection\")\n", PROT_READ);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for PROT_READ (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'PROT-READ)\n");
#ifdef PROT_WRITE
    printf ("(cl:defconstant PROT-WRITE %d \"mmap: write protection\")\n", PROT_WRITE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for PROT_WRITE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'PROT-WRITE)\n");
#ifdef PROT_EXEC
    printf ("(cl:defconstant PROT-EXEC %d \"mmap: execute protection\")\n", PROT_EXEC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for PROT_EXEC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'PROT-EXEC)\n");
#ifdef MAP_SHARED
    printf ("(cl:defconstant MAP-SHARED %d \"mmap: shared memory\")\n", MAP_SHARED);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for MAP_SHARED (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'MAP-SHARED)\n");
#ifdef MAP_PRIVATE
    printf ("(cl:defconstant MAP-PRIVATE %d \"mmap: private mapping\")\n", MAP_PRIVATE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for MAP_PRIVATE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'MAP-PRIVATE)\n");
#ifdef MAP_FIXED
    printf ("(cl:defconstant MAP-FIXED %d \"mmap: map at given location\")\n", MAP_FIXED);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for MAP_FIXED (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'MAP-FIXED)\n");
#ifdef MS_ASYNC
    printf ("(cl:defconstant MS-ASYNC %d \"msync: return immediately\")\n", MS_ASYNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for MS_ASYNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'MS-ASYNC)\n");
#ifdef MS_SYNC
    printf ("(cl:defconstant MS-SYNC %d \"msync: perform synchronous writes\")\n", MS_SYNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for MS_SYNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'MS-SYNC)\n");
#ifdef MS_INVALIDATE
    printf ("(cl:defconstant MS-INVALIDATE %d \"msync: invalidate all cached data\")\n", MS_INVALIDATE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for MS_INVALIDATE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'MS-INVALIDATE)\n");
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-grovel::define-c-struct DIRENT %d\n", sizeof(struct dirent));
    printf (" (NAME C-STRING \"char *\"\n");
{ struct dirent t;
    printf ("  %d\n", ((unsigned long)&(t.d_name)) - ((unsigned long)&(t)));
}
{ struct dirent t;
    printf ("  %d)\n", sizeof(t.d_name));
}
    printf ("))\n");
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-grovel::define-c-struct ALIEN-STAT %d\n", sizeof(struct stat));
    printf (" (MODE MODE-T \"mode_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_mode)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_mode));
}
    printf (" (INO INO-T \"ino_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_ino)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_ino));
}
    printf (" (DEV DEV-T \"dev_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_dev)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_dev));
}
    printf (" (NLINK NLINK-T \"nlink_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_nlink)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_nlink));
}
    printf (" (UID UID-T \"uid_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_uid)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_uid));
}
    printf (" (GID GID-T \"gid_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_gid)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_gid));
}
    printf (" (SIZE OFF-T \"off_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_size)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_size));
}
    printf (" (ATIME TIME-T \"time_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_atime)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_atime));
}
    printf (" (MTIME TIME-T \"time_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_mtime)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_mtime));
}
    printf (" (CTIME TIME-T \"time_t\"\n");
{ struct stat t;
    printf ("  %d\n", ((unsigned long)&(t.st_ctime)) - ((unsigned long)&(t)));
}
{ struct stat t;
    printf ("  %d)\n", sizeof(t.st_ctime));
}
    printf ("))\n");
#ifdef O_RDONLY
    printf ("(cl:defconstant O-RDONLY %d \"NIL\")\n", O_RDONLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_RDONLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-RDONLY)\n");
#ifdef O_WRONLY
    printf ("(cl:defconstant O-WRONLY %d \"NIL\")\n", O_WRONLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_WRONLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-WRONLY)\n");
#ifdef O_RDWR
    printf ("(cl:defconstant O-RDWR %d \"NIL\")\n", O_RDWR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_RDWR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-RDWR)\n");
#ifdef O_CREAT
    printf ("(cl:defconstant O-CREAT %d \"NIL\")\n", O_CREAT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_CREAT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-CREAT)\n");
#ifdef O_EXCL
    printf ("(cl:defconstant O-EXCL %d \"NIL\")\n", O_EXCL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_EXCL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-EXCL)\n");
#ifdef O_NOCTTY
    printf ("(cl:defconstant O-NOCTTY %d \"NIL\")\n", O_NOCTTY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_NOCTTY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-NOCTTY)\n");
#ifdef O_TRUNC
    printf ("(cl:defconstant O-TRUNC %d \"NIL\")\n", O_TRUNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_TRUNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-TRUNC)\n");
#ifdef O_APPEND
    printf ("(cl:defconstant O-APPEND %d \"NIL\")\n", O_APPEND);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_APPEND (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-APPEND)\n");
#ifdef O_NONBLOCK
    printf ("(cl:defconstant O-NONBLOCK %d \"NIL\")\n", O_NONBLOCK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_NONBLOCK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-NONBLOCK)\n");
#ifdef O_NDELAY
    printf ("(cl:defconstant O-NDELAY %d \"NIL\")\n", O_NDELAY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_NDELAY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-NDELAY)\n");
#ifdef O_SYNC
    printf ("(cl:defconstant O-SYNC %d \"NIL\")\n", O_SYNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_SYNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-SYNC)\n");
#ifdef O_NOFOLLOW
    printf ("(cl:defconstant O-NOFOLLOW %d \"NIL\")\n", O_NOFOLLOW);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_NOFOLLOW (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-NOFOLLOW)\n");
#ifdef O_DIRECTORY
    printf ("(cl:defconstant O-DIRECTORY %d \"NIL\")\n", O_DIRECTORY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_DIRECTORY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-DIRECTORY)\n");
#ifdef O_DIRECT
    printf ("(cl:defconstant O-DIRECT %d \"NIL\")\n", O_DIRECT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_DIRECT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-DIRECT)\n");
#ifdef O_ASYNC
    printf ("(cl:defconstant O-ASYNC %d \"NIL\")\n", O_ASYNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_ASYNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-ASYNC)\n");
#ifdef O_LARGEFILE
    printf ("(cl:defconstant O-LARGEFILE %d \"NIL\")\n", O_LARGEFILE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_LARGEFILE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-LARGEFILE)\n");
#ifdef O_DSYNC
    printf ("(cl:defconstant O-DSYNC %d \"NIL\")\n", O_DSYNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_DSYNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-DSYNC)\n");
#ifdef O_RSYNC
    printf ("(cl:defconstant O-RSYNC %d \"NIL\")\n", O_RSYNC);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for O_RSYNC (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'O-RSYNC)\n");
#ifdef SEEK_SET
    printf ("(cl:defconstant SEEK-SET %d \"NIL\")\n", SEEK_SET);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SEEK_SET (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SEEK-SET)\n");
#ifdef SEEK_CUR
    printf ("(cl:defconstant SEEK-CUR %d \"NIL\")\n", SEEK_CUR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SEEK_CUR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SEEK-CUR)\n");
#ifdef SEEK_END
    printf ("(cl:defconstant SEEK-END %d \"NIL\")\n", SEEK_END);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for SEEK_END (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'SEEK-END)\n");
#ifdef F_DUPFD
    printf ("(cl:defconstant F-DUPFD %d \"NIL\")\n", F_DUPFD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_DUPFD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-DUPFD)\n");
#ifdef F_GETFD
    printf ("(cl:defconstant F-GETFD %d \"NIL\")\n", F_GETFD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_GETFD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-GETFD)\n");
#ifdef F_SETFD
    printf ("(cl:defconstant F-SETFD %d \"NIL\")\n", F_SETFD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_SETFD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-SETFD)\n");
#ifdef F_GETFL
    printf ("(cl:defconstant F-GETFL %d \"NIL\")\n", F_GETFL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_GETFL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-GETFL)\n");
#ifdef F_SETFL
    printf ("(cl:defconstant F-SETFL %d \"NIL\")\n", F_SETFL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_SETFL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-SETFL)\n");
#ifdef F_GETLK
    printf ("(cl:defconstant F-GETLK %d \"NIL\")\n", F_GETLK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_GETLK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-GETLK)\n");
#ifdef F_SETLK
    printf ("(cl:defconstant F-SETLK %d \"NIL\")\n", F_SETLK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_SETLK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-SETLK)\n");
#ifdef F_SETLKW
    printf ("(cl:defconstant F-SETLKW %d \"NIL\")\n", F_SETLKW);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_SETLKW (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-SETLKW)\n");
#ifdef F_GETOWN
    printf ("(cl:defconstant F-GETOWN %d \"NIL\")\n", F_GETOWN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_GETOWN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-GETOWN)\n");
#ifdef F_SETOWN
    printf ("(cl:defconstant F-SETOWN %d \"NIL\")\n", F_SETOWN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for F_SETOWN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'F-SETOWN)\n");
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type CC-T (sb-alien:%ssigned %d)))\n", SIGNED_(cc_t), (8*sizeof(cc_t)));
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type SPEED-T (sb-alien:%ssigned %d)))\n", SIGNED_(speed_t), (8*sizeof(speed_t)));
    printf ("(cl:export 'SPEED-T)\n");
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-alien:define-alien-type TCFLAG-T (sb-alien:%ssigned %d)))\n", SIGNED_(tcflag_t), (8*sizeof(tcflag_t)));
    printf ("(cl:export 'TCFLAG-T)\n");
#ifdef NCCS
    printf ("(cl:defconstant NCCS %d \"NIL\")\n", NCCS);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for NCCS (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'NCCS)\n");
    printf ("(cl:eval-when (:compile-toplevel :load-toplevel :execute) (sb-grovel::define-c-struct ALIEN-TERMIOS %d\n", sizeof(struct termios));
    printf (" (IFLAG TCFLAG-T \"tcflag_t\"\n");
{ struct termios t;
    printf ("  %d\n", ((unsigned long)&(t.c_iflag)) - ((unsigned long)&(t)));
}
{ struct termios t;
    printf ("  %d)\n", sizeof(t.c_iflag));
}
    printf (" (OFLAG TCFLAG-T \"tcflag_t\"\n");
{ struct termios t;
    printf ("  %d\n", ((unsigned long)&(t.c_oflag)) - ((unsigned long)&(t)));
}
{ struct termios t;
    printf ("  %d)\n", sizeof(t.c_oflag));
}
    printf (" (CFLAG TCFLAG-T \"tcflag_t\"\n");
{ struct termios t;
    printf ("  %d\n", ((unsigned long)&(t.c_cflag)) - ((unsigned long)&(t)));
}
{ struct termios t;
    printf ("  %d)\n", sizeof(t.c_cflag));
}
    printf (" (LFLAG TCFLAG-T \"tcflag_t\"\n");
{ struct termios t;
    printf ("  %d\n", ((unsigned long)&(t.c_lflag)) - ((unsigned long)&(t)));
}
{ struct termios t;
    printf ("  %d)\n", sizeof(t.c_lflag));
}
    printf (" (CC (ARRAY CC-T) \"cc_t\"\n");
{ struct termios t;
    printf ("  %d\n", ((unsigned long)&(t.c_cc)) - ((unsigned long)&(t)));
}
{ struct termios t;
    printf ("  %d)\n", sizeof(t.c_cc));
}
    printf ("))\n");
#ifdef VEOF
    printf ("(cl:defconstant VEOF %d \"NIL\")\n", VEOF);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VEOF (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VEOF)\n");
#ifdef VEOL
    printf ("(cl:defconstant VEOL %d \"NIL\")\n", VEOL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VEOL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VEOL)\n");
#ifdef VERASE
    printf ("(cl:defconstant VERASE %d \"NIL\")\n", VERASE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VERASE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VERASE)\n");
#ifdef VINTR
    printf ("(cl:defconstant VINTR %d \"NIL\")\n", VINTR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VINTR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VINTR)\n");
#ifdef VKILL
    printf ("(cl:defconstant VKILL %d \"NIL\")\n", VKILL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VKILL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VKILL)\n");
#ifdef VMIN
    printf ("(cl:defconstant VMIN %d \"NIL\")\n", VMIN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VMIN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VMIN)\n");
#ifdef VQUIT
    printf ("(cl:defconstant VQUIT %d \"NIL\")\n", VQUIT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VQUIT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VQUIT)\n");
#ifdef VSTART
    printf ("(cl:defconstant VSTART %d \"NIL\")\n", VSTART);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VSTART (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VSTART)\n");
#ifdef VSTOP
    printf ("(cl:defconstant VSTOP %d \"NIL\")\n", VSTOP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VSTOP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VSTOP)\n");
#ifdef VSUSP
    printf ("(cl:defconstant VSUSP %d \"NIL\")\n", VSUSP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VSUSP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VSUSP)\n");
#ifdef VTIME
    printf ("(cl:defconstant VTIME %d \"NIL\")\n", VTIME);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VTIME (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VTIME)\n");
#ifdef BRKINT
    printf ("(cl:defconstant BRKINT %d \"NIL\")\n", BRKINT);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for BRKINT (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'BRKINT)\n");
#ifdef ICRNL
    printf ("(cl:defconstant ICRNL %d \"NIL\")\n", ICRNL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ICRNL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ICRNL)\n");
#ifdef IGNBRK
    printf ("(cl:defconstant IGNBRK %d \"NIL\")\n", IGNBRK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for IGNBRK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'IGNBRK)\n");
#ifdef IGNCR
    printf ("(cl:defconstant IGNCR %d \"NIL\")\n", IGNCR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for IGNCR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'IGNCR)\n");
#ifdef IGNPAR
    printf ("(cl:defconstant IGNPAR %d \"NIL\")\n", IGNPAR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for IGNPAR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'IGNPAR)\n");
#ifdef INLCR
    printf ("(cl:defconstant INLCR %d \"NIL\")\n", INLCR);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for INLCR (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'INLCR)\n");
#ifdef INPCK
    printf ("(cl:defconstant INPCK %d \"NIL\")\n", INPCK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for INPCK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'INPCK)\n");
#ifdef ISTRIP
    printf ("(cl:defconstant ISTRIP %d \"NIL\")\n", ISTRIP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ISTRIP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ISTRIP)\n");
#ifdef IXOFF
    printf ("(cl:defconstant IXOFF %d \"NIL\")\n", IXOFF);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for IXOFF (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'IXOFF)\n");
#ifdef IXON
    printf ("(cl:defconstant IXON %d \"NIL\")\n", IXON);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for IXON (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'IXON)\n");
#ifdef PARMRK
    printf ("(cl:defconstant PARMRK %d \"NIL\")\n", PARMRK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for PARMRK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'PARMRK)\n");
#ifdef OPOST
    printf ("(cl:defconstant OPOST %d \"NIL\")\n", OPOST);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for OPOST (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'OPOST)\n");
#ifdef OCRNL
    printf ("(cl:defconstant OCRNL %d \"NIL\")\n", OCRNL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for OCRNL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'OCRNL)\n");
#ifdef ONLRET
    printf ("(cl:defconstant ONLRET %d \"NIL\")\n", ONLRET);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ONLRET (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ONLRET)\n");
#ifdef OFILL
    printf ("(cl:defconstant OFILL %d \"NIL\")\n", OFILL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for OFILL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'OFILL)\n");
#ifdef NLDLY
    printf ("(cl:defconstant NLDLY %d \"NIL\")\n", NLDLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for NLDLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'NLDLY)\n");
#ifdef NL0
    printf ("(cl:defconstant NL0 %d \"NIL\")\n", NL0);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for NL0 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'NL0)\n");
#ifdef NL1
    printf ("(cl:defconstant NL1 %d \"NIL\")\n", NL1);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for NL1 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'NL1)\n");
#ifdef CRDLY
    printf ("(cl:defconstant CRDLY %d \"NIL\")\n", CRDLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CRDLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CRDLY)\n");
#ifdef CR0
    printf ("(cl:defconstant CR0 %d \"NIL\")\n", CR0);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CR0 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CR0)\n");
#ifdef CR1
    printf ("(cl:defconstant CR1 %d \"NIL\")\n", CR1);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CR1 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CR1)\n");
#ifdef CR2
    printf ("(cl:defconstant CR2 %d \"NIL\")\n", CR2);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CR2 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CR2)\n");
#ifdef CR3
    printf ("(cl:defconstant CR3 %d \"NIL\")\n", CR3);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CR3 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CR3)\n");
#ifdef TABDLY
    printf ("(cl:defconstant TABDLY %d \"NIL\")\n", TABDLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TABDLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TABDLY)\n");
#ifdef TAB0
    printf ("(cl:defconstant TAB0 %d \"NIL\")\n", TAB0);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TAB0 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TAB0)\n");
#ifdef TAB1
    printf ("(cl:defconstant TAB1 %d \"NIL\")\n", TAB1);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TAB1 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TAB1)\n");
#ifdef TAB2
    printf ("(cl:defconstant TAB2 %d \"NIL\")\n", TAB2);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TAB2 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TAB2)\n");
#ifdef TAB3
    printf ("(cl:defconstant TAB3 %d \"NIL\")\n", TAB3);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TAB3 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TAB3)\n");
#ifdef BSDLY
    printf ("(cl:defconstant BSDLY %d \"NIL\")\n", BSDLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for BSDLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'BSDLY)\n");
#ifdef BS0
    printf ("(cl:defconstant BS0 %d \"NIL\")\n", BS0);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for BS0 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'BS0)\n");
#ifdef BS1
    printf ("(cl:defconstant BS1 %d \"NIL\")\n", BS1);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for BS1 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'BS1)\n");
#ifdef VTDLY
    printf ("(cl:defconstant VTDLY %d \"NIL\")\n", VTDLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VTDLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VTDLY)\n");
#ifdef VT0
    printf ("(cl:defconstant VT0 %d \"NIL\")\n", VT0);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VT0 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VT0)\n");
#ifdef VT1
    printf ("(cl:defconstant VT1 %d \"NIL\")\n", VT1);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for VT1 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'VT1)\n");
#ifdef FFDLY
    printf ("(cl:defconstant FFDLY %d \"NIL\")\n", FFDLY);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for FFDLY (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'FFDLY)\n");
#ifdef FF0
    printf ("(cl:defconstant FF0 %d \"NIL\")\n", FF0);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for FF0 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'FF0)\n");
#ifdef FF1
    printf ("(cl:defconstant FF1 %d \"NIL\")\n", FF1);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for FF1 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'FF1)\n");
#ifdef B0
    printf ("(cl:defconstant B0 %d \"NIL\")\n", B0);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B0 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B0)\n");
#ifdef B50
    printf ("(cl:defconstant B50 %d \"NIL\")\n", B50);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B50 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B50)\n");
#ifdef B75
    printf ("(cl:defconstant B75 %d \"NIL\")\n", B75);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B75 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B75)\n");
#ifdef B110
    printf ("(cl:defconstant B110 %d \"NIL\")\n", B110);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B110 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B110)\n");
#ifdef B134
    printf ("(cl:defconstant B134 %d \"NIL\")\n", B134);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B134 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B134)\n");
#ifdef B150
    printf ("(cl:defconstant B150 %d \"NIL\")\n", B150);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B150 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B150)\n");
#ifdef B200
    printf ("(cl:defconstant B200 %d \"NIL\")\n", B200);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B200 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B200)\n");
#ifdef B300
    printf ("(cl:defconstant B300 %d \"NIL\")\n", B300);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B300 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B300)\n");
#ifdef B600
    printf ("(cl:defconstant B600 %d \"NIL\")\n", B600);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B600 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B600)\n");
#ifdef B1200
    printf ("(cl:defconstant B1200 %d \"NIL\")\n", B1200);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B1200 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B1200)\n");
#ifdef B1800
    printf ("(cl:defconstant B1800 %d \"NIL\")\n", B1800);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B1800 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B1800)\n");
#ifdef B2400
    printf ("(cl:defconstant B2400 %d \"NIL\")\n", B2400);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B2400 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B2400)\n");
#ifdef B4800
    printf ("(cl:defconstant B4800 %d \"NIL\")\n", B4800);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B4800 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B4800)\n");
#ifdef B9600
    printf ("(cl:defconstant B9600 %d \"NIL\")\n", B9600);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B9600 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B9600)\n");
#ifdef B19200
    printf ("(cl:defconstant B19200 %d \"NIL\")\n", B19200);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B19200 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B19200)\n");
#ifdef B38400
    printf ("(cl:defconstant B38400 %d \"NIL\")\n", B38400);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for B38400 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'B38400)\n");
#ifdef CSIZE
    printf ("(cl:defconstant CSIZE %d \"NIL\")\n", CSIZE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CSIZE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CSIZE)\n");
#ifdef CS5
    printf ("(cl:defconstant CS5 %d \"NIL\")\n", CS5);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CS5 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CS5)\n");
#ifdef CS6
    printf ("(cl:defconstant CS6 %d \"NIL\")\n", CS6);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CS6 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CS6)\n");
#ifdef CS7
    printf ("(cl:defconstant CS7 %d \"NIL\")\n", CS7);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CS7 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CS7)\n");
#ifdef CS8
    printf ("(cl:defconstant CS8 %d \"NIL\")\n", CS8);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CS8 (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CS8)\n");
#ifdef CSTOPB
    printf ("(cl:defconstant CSTOPB %d \"NIL\")\n", CSTOPB);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CSTOPB (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CSTOPB)\n");
#ifdef CREAD
    printf ("(cl:defconstant CREAD %d \"NIL\")\n", CREAD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CREAD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CREAD)\n");
#ifdef PARENB
    printf ("(cl:defconstant PARENB %d \"NIL\")\n", PARENB);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for PARENB (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'PARENB)\n");
#ifdef PARODD
    printf ("(cl:defconstant PARODD %d \"NIL\")\n", PARODD);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for PARODD (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'PARODD)\n");
#ifdef HUPCL
    printf ("(cl:defconstant HUPCL %d \"NIL\")\n", HUPCL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for HUPCL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'HUPCL)\n");
#ifdef CLOCAL
    printf ("(cl:defconstant CLOCAL %d \"NIL\")\n", CLOCAL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for CLOCAL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'CLOCAL)\n");
#ifdef ECHO
    printf ("(cl:defconstant ECHO %d \"NIL\")\n", ECHO);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECHO (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECHO)\n");
#ifdef ECHOE
    printf ("(cl:defconstant ECHOE %d \"NIL\")\n", ECHOE);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECHOE (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECHOE)\n");
#ifdef ECHOK
    printf ("(cl:defconstant ECHOK %d \"NIL\")\n", ECHOK);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECHOK (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECHOK)\n");
#ifdef ECHONL
    printf ("(cl:defconstant ECHONL %d \"NIL\")\n", ECHONL);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ECHONL (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ECHONL)\n");
#ifdef ICANON
    printf ("(cl:defconstant ICANON %d \"NIL\")\n", ICANON);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ICANON (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ICANON)\n");
#ifdef IEXTEN
    printf ("(cl:defconstant IEXTEN %d \"NIL\")\n", IEXTEN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for IEXTEN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'IEXTEN)\n");
#ifdef ISIG
    printf ("(cl:defconstant ISIG %d \"NIL\")\n", ISIG);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for ISIG (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'ISIG)\n");
#ifdef NOFLSH
    printf ("(cl:defconstant NOFLSH %d \"NIL\")\n", NOFLSH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for NOFLSH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'NOFLSH)\n");
#ifdef TOSTOP
    printf ("(cl:defconstant TOSTOP %d \"NIL\")\n", TOSTOP);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TOSTOP (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TOSTOP)\n");
#ifdef TCSANOW
    printf ("(cl:defconstant TCSANOW %d \"NIL\")\n", TCSANOW);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCSANOW (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCSANOW)\n");
#ifdef TCSADRAIN
    printf ("(cl:defconstant TCSADRAIN %d \"NIL\")\n", TCSADRAIN);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCSADRAIN (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCSADRAIN)\n");
#ifdef TCSAFLUSH
    printf ("(cl:defconstant TCSAFLUSH %d \"NIL\")\n", TCSAFLUSH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCSAFLUSH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCSAFLUSH)\n");
#ifdef TCIFLUSH
    printf ("(cl:defconstant TCIFLUSH %d \"NIL\")\n", TCIFLUSH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCIFLUSH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCIFLUSH)\n");
#ifdef TCIOFLUSH
    printf ("(cl:defconstant TCIOFLUSH %d \"NIL\")\n", TCIOFLUSH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCIOFLUSH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCIOFLUSH)\n");
#ifdef TCOFLUSH
    printf ("(cl:defconstant TCOFLUSH %d \"NIL\")\n", TCOFLUSH);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCOFLUSH (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCOFLUSH)\n");
#ifdef TCIOFF
    printf ("(cl:defconstant TCIOFF %d \"NIL\")\n", TCIOFF);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCIOFF (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCIOFF)\n");
#ifdef TCION
    printf ("(cl:defconstant TCION %d \"NIL\")\n", TCION);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCION (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCION)\n");
#ifdef TCOOFF
    printf ("(cl:defconstant TCOOFF %d \"NIL\")\n", TCOOFF);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCOOFF (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCOOFF)\n");
#ifdef TCOON
    printf ("(cl:defconstant TCOON %d \"NIL\")\n", TCOON);
#else
    printf ("(sb-int:style-warn \"Couldn't grovel for TCOON (unknown to the C compiler).\")\n");
#endif
    printf ("(cl:export 'TCOON)\n");
return 0;
}
