
#ifndef _CMPIOSBASE_COMMON_H_
#define _CMPIOSBASE_COMMON_H_

/*
 * cmpiOSBase_Common.h
 *
 * (C) Copyright IBM Corp. 2002
 *
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://www.opensource.org/licenses/cpl1.0.txt
 *
 * Author:       Heidi Neumann <heidineu@de.ibm.com>
 * Contributors:
 *
 * Interface Type : Common Manageability Programming Interface ( CMPI )
 *
 * Description:
 * This library contains common /  generic methods to write CMPI Provider.
 *
*/
/* ---------------------------------------------------------------------------*/

#include "cmpidt.h"

#ifdef __cplusplus
extern "C" {
#endif

/* ---------------------------------------------------------------------------*/

extern char * CSCreationClassName;
extern char * OSCreationClassName;

extern unsigned char CMPI_true;
extern unsigned char CMPI_false;

/* ---------------------------------------------------------------------------*/

void _check_system_key_value_pairs( const CMPIBroker * _broker,
				    const CMPIObjectPath * cop,
				    const char * creationClassName,
				    const char * className,
				    CMPIStatus * rc );


int _assoc_create_inst_1toN( const CMPIBroker * _broker,
			     const CMPIContext * ctx,
			     const CMPIResult * rslt,
			     const CMPIObjectPath * cop,
			     const char * _ClassName,
			     const char * _RefLeftClass,
			     const char * _RefRightClass,
			     const char * _RefLeft,
			     const char * _RefRight,
			     int left,
			     int inst,
			     CMPIStatus * rc);


/* - method to create CMPIInstance out of the CMPIObjectPath of an            */
/*   association instance                                                     */
CMPIInstance * _assoc_get_inst( const CMPIBroker * _broker,
				const CMPIContext * ctx,
				const CMPIObjectPath * cop,
				const char * _ClassName,
				const char * _RefLeft,
				const char * _RefRight,
				CMPIStatus * rc );


/* - method to create CMPIInstance(s) / CMPIObjectPath(s) of association      */
int _assoc_create_refs_1toN( const CMPIBroker * _broker,
			     const CMPIContext * ctx,
			     const CMPIResult * rslt,
			     const CMPIObjectPath * ref,
			     const char * _ClassName,
			     const char * _RefLeftClass,
			     const char * _RefRightClass,
			     const char * _RefLeft,
			     const char * _RefRight,
			     int inst,
			     int associators,
			     CMPIStatus * rc);


/* - method to get the name of the target class                               */
const char * _assoc_targetClass_Name( const CMPIBroker * _broker,
				      const CMPIObjectPath * ref,
				      const char * _RefLeftClass,
				      const char * _RefRightClass,
				      CMPIStatus * rc);


/* - method to get an empty CMPIObjectPath of the target class                */
CMPIObjectPath * _assoc_targetClass_OP( const CMPIBroker * _broker,
					const CMPIObjectPath * ref,
					const char * _RefLeftClass,
					const char * _RefRightClass,
					CMPIStatus * rc );


/* - method to check the input parameter resultClass, role and resultRole     */
/*   submitted to the methods of the association interface                    */
int _assoc_check_parameter_const( const CMPIBroker * _broker,
				  const CMPIObjectPath * cop,
				  const char * _RefLeft,
				  const char * _RefRight,
				  const char * _RefLeftClass,
				  const char * _RefRightClass,
				  const char * resultClass,
				  const char * role,
				  const char * resultRole,
				  CMPIStatus * rc );


/* ---------------------------------------------------------------------------*/
/*                       end of cmpiOSBase_Common.h                           */
/* ---------------------------------------------------------------------------*/

#ifdef __cplusplus
   }
#endif

/* ---------------------------------------------------------------------------*/

#endif
