/*
 * CimWww.h
 *
 * (C) Copyright IBM Corp. 2002
 * 
 * THIS FILE IS PROVIDED UNDER THE TERMS OF THE COMMON PUBLIC LICENSE
 * ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS FILE
 * CONSTITUTES RECIPIENTS ACCEPTANCE OF THE AGREEMENT.
 *
 * You can obtain a current copy of the Common Public License from
 * http://oss.software.ibm.com/developerworks/opensource/license-cpl.html
 *
 * Author:       Adrian Schuur <schuur@de.ibm.com>
 * Contributors: Viktor Mihajlovski <mihajlov@de.ibm.com>
 *               Markus Mueller <markus_mueller@de.ibm.com>
 *               Steve Shepherd <steve.shepherd@configuresoft.com>
 *               Heidi Neumann  <heidineu@de.ibm.com>
 *               David Eger <dteger@us.ibm.com>
 *
 * Description: Line command interface to DMTF conforming WBEM servers
*/


#ifndef CIMWWW_H
#define CIMWWW_H

#include "CimXml.h"

#include <WWWLib.h>
#include <WWWApp.h>
#include <WWWStream.h>
#include <WWWInit.h>

class CimomWww : public Cimom {
  private:
   HTParentAnchor *parent;
   HTAnchor       *anchor;
   HTRequest      *request;
   HTChunk        *chunk;
   void genRequest(URL &, char *, bool cls=false, bool keys=false);
   void addPayload(const string &pl);
   string getResponse();
   string errorbuf;
  public:
   CimomWww();
   ~CimomWww();
   void setClientCertificates(const char * cacert,
			      int noverify,
			      const char * clientcert,
			      const char * clientkey);
};

#endif	/* CIMWWW_H */
