/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesUtility;

public abstract class ApproximateNumeric
extends Numeric
implements ScalaObject {
    private int nativeTypeId;

    public ApproximateNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    public String sqlString() {
        Tuple2 tuple2 = new Tuple2(BoxesUtility.boxToInteger(this.precisionRadix()), BoxesUtility.boxToInteger(this.precision()));
        if (tuple2 != null) {
            String string;
            Tuple2 tuple22 = tuple2;
            if (BoxesUtility.unboxToInt(tuple22._1()) != 2) {
                if (BoxesUtility.unboxToInt(tuple22._1()) != 10) {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an approximate numeric type to be defined in a radix other than 2 or 10");
                }
                string = "FLOAT (" + tuple22._2().toString() + ")";
            } else if (BoxesUtility.unboxToInt(tuple22._2()) != 64) {
                if (BoxesUtility.unboxToInt(tuple22._2()) != 128) {
                    throw new UnsupportedFeature("SQL-99 does not support an approximate numeric type with a binary defined precision other than 16, 32 and 64 bits");
                }
                string = "DOUBLE PRECISION";
            } else {
                string = "REAL";
            }
            return string;
        }
        throw new MatchError(tuple2);
    }

    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (!(dataType instanceof ApproximateNumeric)) {
            bl = false;
        } else {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.signed() == dt.signed();
        }
        return bl;
    }

    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (!(dataType instanceof ApproximateNumeric)) {
            bl = false;
        } else {
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric dt = approximateNumeric = (ApproximateNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.signed() == dt.signed();
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

