/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.io.Serializable;
import java.math.BigInteger;
import scala.BigInt$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Tuple2;

public class BigInt
extends Number
implements ScalaObject,
Serializable {
    private BigInteger bigInteger;

    public BigInt(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    public byte[] toByteArray() {
        return this.bigInteger().toByteArray();
    }

    public String toString(int radix) {
        return this.bigInteger().toString(radix);
    }

    public String toString() {
        return this.bigInteger().toString();
    }

    public double doubleValue() {
        return this.bigInteger().doubleValue();
    }

    public float floatValue() {
        return this.bigInteger().floatValue();
    }

    public long longValue() {
        return this.bigInteger().longValue();
    }

    public int intValue() {
        return this.bigInteger().intValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    public short shortValue() {
        return (short)this.intValue();
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public boolean isProbablePrime(int certainty) {
        return this.bigInteger().isProbablePrime(certainty);
    }

    public int bitCount() {
        return this.bigInteger().bitCount();
    }

    public int bitLength() {
        return this.bigInteger().bitLength();
    }

    public int lowestSetBit() {
        return this.bigInteger().getLowestSetBit();
    }

    public BigInt flipBit(int n) {
        return new BigInt(this.bigInteger().flipBit(n));
    }

    public BigInt clearBit(int n) {
        return new BigInt(this.bigInteger().clearBit(n));
    }

    public BigInt setBit(int n) {
        return new BigInt(this.bigInteger().setBit(n));
    }

    public boolean testBit(int n) {
        return this.bigInteger().testBit(n);
    }

    public BigInt $tilde() {
        return new BigInt(this.bigInteger().not());
    }

    public int signum() {
        return this.bigInteger().signum();
    }

    public BigInt abs() {
        return new BigInt(this.bigInteger().abs());
    }

    public BigInt unary_$minus() {
        return new BigInt(this.bigInteger().negate());
    }

    public BigInt modInverse(BigInt m) {
        return new BigInt(this.bigInteger().modInverse(m.bigInteger()));
    }

    public BigInt modPow(BigInt exp, BigInt m) {
        return new BigInt(this.bigInteger().modPow(exp.bigInteger(), m.bigInteger()));
    }

    public BigInt pow(int exp) {
        return new BigInt(this.bigInteger().pow(exp));
    }

    public BigInt max(BigInt that) {
        return new BigInt(this.bigInteger().max(that.bigInteger()));
    }

    public BigInt min(BigInt that) {
        return new BigInt(this.bigInteger().min(that.bigInteger()));
    }

    public BigInt mod(BigInt that) {
        return new BigInt(this.bigInteger().mod(that.bigInteger()));
    }

    public BigInt gcd(BigInt that) {
        return new BigInt(this.bigInteger().gcd(that.bigInteger()));
    }

    public BigInt $amp$tilde(BigInt that) {
        return new BigInt(this.bigInteger().andNot(that.bigInteger()));
    }

    public BigInt $up(BigInt that) {
        return new BigInt(this.bigInteger().xor(that.bigInteger()));
    }

    public BigInt $bar(BigInt that) {
        return new BigInt(this.bigInteger().or(that.bigInteger()));
    }

    public BigInt $amp(BigInt that) {
        return new BigInt(this.bigInteger().and(that.bigInteger()));
    }

    public BigInt $greater$greater(int n) {
        return new BigInt(this.bigInteger().shiftRight(n));
    }

    public BigInt $less$less(int n) {
        return new BigInt(this.bigInteger().shiftLeft(n));
    }

    public Tuple2 $div$percent(BigInt that) {
        BigInteger[] dr = this.bigInteger().divideAndRemainder(that.bigInteger());
        return new Tuple2(new BigInt(dr[0]), new BigInt(dr[1]));
    }

    public BigInt $percent(BigInt that) {
        return new BigInt(this.bigInteger().remainder(that.bigInteger()));
    }

    public BigInt $div(BigInt that) {
        return new BigInt(this.bigInteger().divide(that.bigInteger()));
    }

    public BigInt $times(BigInt that) {
        return new BigInt(this.bigInteger().multiply(that.bigInteger()));
    }

    public BigInt $minus(BigInt that) {
        return new BigInt(this.bigInteger().subtract(that.bigInteger()));
    }

    public BigInt $plus(BigInt that) {
        return new BigInt(this.bigInteger().add(that.bigInteger()));
    }

    public boolean $greater(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger()) > 0;
    }

    public boolean $less(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger()) < 0;
    }

    public boolean $greater$eq(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger()) >= 0;
    }

    public boolean $less$eq(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger()) <= 0;
    }

    public int compare(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger());
    }

    public boolean equals(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger()) == 0;
    }

    public boolean equals(Object that) {
        Object object = that;
        boolean bl = !(object instanceof BigInt) ? (!(object instanceof Double) ? (!(object instanceof Float) ? (!(object instanceof Number) ? (!(object instanceof Character) ? false : this.equals(BigInt$.MODULE$.apply(((Character)object).charValue()))) : this.equals(BigInt$.MODULE$.apply(((Number)object).longValue()))) : this.bigInteger().floatValue() == ((Float)object).floatValue()) : this.bigInteger().doubleValue() == ((Double)object).doubleValue()) : this.equals((BigInt)object);
        return bl;
    }

    public int hashCode() {
        return this.bigInteger().hashCode();
    }

    public BigInteger bigInteger() {
        return this.bigInteger;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

