/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import scala.MatchError;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.actors.remote.Node;
import scala.actors.remote.TcpService;

public class TcpServiceWorker
extends Thread
implements ScalaObject {
    private boolean running;
    private Node connectedNode;
    private PrintWriter writer;
    private BufferedReader reader;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private OutputStream out;
    private InputStream in;
    private Socket so;
    private TcpService parent;

    public TcpServiceWorker(TcpService parent, Socket so) {
        this.parent = parent;
        this.so = so;
        this.in = so.getInputStream();
        this.out = so.getOutputStream();
        this.datain = new DataInputStream(this.in());
        this.dataout = new DataOutputStream(this.out());
        this.reader = new BufferedReader(new InputStreamReader(this.in()));
        this.writer = new PrintWriter(new OutputStreamWriter(this.out()));
        this.running = true;
    }

    public void run() {
        try {
            while (this.running()) {
                if (this.in().available() <= 0) continue;
                Object msg = this.parent.serializer().readObject(this.datain());
                this.parent.kernel().processMsg(this.connectedNode(), msg);
            }
        }
        catch (Exception exception) {
            this.parent.nodeDown(this.connectedNode());
        }
        catch (IOException iOException) {
            this.parent.nodeDown(this.connectedNode());
        }
    }

    public void halt() {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.so.close();
            this.running_$eq(false);
            return;
        }
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void transmit(byte[] data) {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.dataout().writeInt(data.length);
            this.dataout().write(data);
            this.dataout().flush();
            return;
        }
    }

    public void readNode() {
        Node node;
        Object node2 = this.parent.serializer().readObject(this.datain());
        Object object = node2;
        if (!(object instanceof Node)) {
            throw new MatchError(object);
        }
        Node n = node = (Node)object;
        this.connectedNode_$eq(n);
        this.parent.addConnection(n, this);
    }

    public void sendNode(Node n) {
        this.connectedNode_$eq(n);
        this.parent.serializer().writeObject(this.dataout(), this.parent.node());
    }

    public void connectedNode_$eq(Node x$1) {
        this.connectedNode = x$1;
    }

    public Node connectedNode() {
        return this.connectedNode;
    }

    public PrintWriter writer() {
        return this.writer;
    }

    public BufferedReader reader() {
        return this.reader;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public DataInputStream datain() {
        return this.datain;
    }

    public OutputStream out() {
        return this.out;
    }

    public InputStream in() {
        return this.in;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

