/* NSC -- new Scala compiler
 * Copyright 2005-2007 LAMP/EPFL
 * @author  Martin Odersky
 */
// $Id: Phase.scala 12005 2007-06-13 12:28:07Z michelou $

package scala.tools.nsc

import symtab.Flags

abstract class Phase(val prev: Phase) {

  type Id = Int

  val id: Id = if (prev eq null) 0 else prev.id + 1

  def newFlags: Long = 0l
  private var fmask: Long =
    if (prev eq null) Flags.InitialFlags else prev.flagMask | newFlags
  def flagMask: Long = fmask

  private var nx: Phase = this
  if (prev ne null) prev.nx = this

  def next: Phase = nx

  def name: String
  def description: String = name
  def erasedTypes: Boolean = false
  def flatClasses: Boolean = false
  def run: Unit

  override def toString() = name
}


