/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.rmi.RemoteException;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.StringBuilder;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.actors.AbstractActor;
import scala.actors.Actor$;
import scala.actors.Debug$;
import scala.actors.OutputChannel;
import scala.actors.remote.FreshNameCreator$;
import scala.actors.remote.LocalApply0;
import scala.actors.remote.Locator;
import scala.actors.remote.NamedSend;
import scala.actors.remote.NetKernel$;
import scala.actors.remote.Node;
import scala.actors.remote.Proxy;
import scala.actors.remote.RemoteApply0;
import scala.actors.remote.SendTo;
import scala.actors.remote.Service;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetKernel
implements ScalaObject {
    private final HashMap proxies;
    private final HashMap names;
    private final HashMap actors;
    private final Service service;

    public NetKernel(Service service) {
        this.service = service;
        this.actors = new HashMap();
        this.names = new HashMap();
        this.proxies = new HashMap();
    }

    private final void liftedTree1$1(Locator locator, byte[] byArray, Symbol symbol, OutputChannel outputChannel) {
        try {
            Object msg = this.service.serializer().deserialize(byArray);
            Proxy senderProxy = this.getOrCreateProxy(locator.node(), locator.name());
            senderProxy.send(new SendTo(outputChannel, msg, symbol), (OutputChannel<Object>)null);
        }
        catch (Exception exception) {
            Debug$.MODULE$.error(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(exception).toString());
        }
    }

    public void terminate() {
        this.proxies().values().foreach(new $anonfun$terminate$1(this));
        this.service.terminate();
    }

    public void processMsg(Node senderNode, Object msg) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Object object;
            block9: {
                Option option;
                block11: {
                    block7: {
                        BoxedUnit boxedUnit;
                        block10: {
                            OutputChannel outputChannel;
                            block5: {
                                Option option2;
                                block8: {
                                    block6: {
                                        object = msg;
                                        if (!(object instanceof RemoteApply0)) break block5;
                                        RemoteApply0 remoteApply0 = (RemoteApply0)object;
                                        Locator locator = remoteApply0.senderLoc();
                                        Locator locator2 = remoteApply0.receiverLoc();
                                        Locator senderLoc = locator;
                                        Locator receiverLoc = locator2;
                                        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": processing ")).append(remoteApply0).toString());
                                        option2 = this.actors().get(receiverLoc.name());
                                        if (!(option2 instanceof Some)) break block6;
                                        Proxy senderProxy = this.getOrCreateProxy(senderLoc.node(), senderLoc.name());
                                        senderProxy.send(new LocalApply0(remoteApply0.rfun(), (AbstractActor)((Some)option2).x()), (OutputChannel<Object>)null);
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block7;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option option3 = option2;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block8;
                                    Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": lost message"));
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block7;
                                }
                                throw new MatchError(option2);
                            }
                            if (!(object instanceof NamedSend)) break block9;
                            NamedSend namedSend = (NamedSend)object;
                            Locator locator = namedSend.senderLoc();
                            Locator locator3 = namedSend.receiverLoc();
                            byte[] byArray = namedSend.data();
                            Symbol symbol = namedSend.session();
                            Locator senderLoc$3 = locator;
                            Locator receiverLoc = locator3;
                            byte[] data$2 = byArray;
                            Symbol session$3 = symbol;
                            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": processing ")).append(namedSend).toString());
                            option = this.actors().get(receiverLoc.name());
                            if (!(option instanceof Some)) break block10;
                            Some some = (Some)option;
                            OutputChannel a$3 = outputChannel = (OutputChannel)some.x();
                            this.liftedTree1$1(senderLoc$3, data$2, session$3, a$3);
                            boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option4 = option;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block11;
                        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": lost message"));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            throw new MatchError(object);
        }
    }

    public void registerProxy(Node senderNode, Symbol senderName, Proxy p) {
        HashMap<Tuple2<Node, Symbol>, Proxy> hashMap = this.proxies();
        synchronized (hashMap) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = this.proxies().get(new Tuple2<Node, Symbol>(senderNode, senderName));
                        if (!(option instanceof Some)) break block5;
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    this.proxies().$plus$eq(Predef$Pair$.MODULE$.apply(new Tuple2<Node, Symbol>(senderNode, senderName), p));
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Proxy getOrCreateProxy(Node senderNode, Symbol senderName) {
        HashMap<Tuple2<Node, Symbol>, Proxy> hashMap = this.proxies();
        synchronized (hashMap) {
            Option option;
            block6: {
                Object object;
                option = this.proxies().get(new Tuple2<Node, Symbol>(senderNode, senderName));
                if (option instanceof Some) {
                    object = ((Some)option).x();
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    object = this.createProxy(senderNode, senderName);
                }
                return (Proxy)object;
            }
            throw new MatchError(option);
        }
    }

    public HashMap<Tuple2<Node, Symbol>, Proxy> proxies() {
        return this.proxies;
    }

    /*
     * WARNING - void declaration
     */
    public Proxy createProxy(Node node, Symbol sym) {
        void var3_3;
        Proxy p = new Proxy(node, sym, this);
        this.proxies().$plus$eq(Predef$Pair$.MODULE$.apply(new Tuple2<Node, Symbol>(node, sym), p));
        return var3_3;
    }

    public void remoteApply(Node node, Symbol name, OutputChannel<Object> from2, Function2<AbstractActor, Proxy, Object> rfun) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(from2));
        Locator receiverLoc = new Locator(node, name);
        this.sendToNode(receiverLoc.node(), new RemoteApply0(senderLoc, receiverLoc, rfun));
    }

    public void forward(OutputChannel<Object> from2, Node node, Symbol name, Object msg, Symbol session) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(from2));
        Locator receiverLoc = new Locator(node, name);
        this.namedSend(senderLoc, receiverLoc, msg, session);
    }

    public void send(Node node, Symbol name, Object msg, Symbol session) {
        Locator senderLoc = new Locator(this.service.node(), this.getOrCreateName(Actor$.MODULE$.self()));
        Locator receiverLoc = new Locator(node, name);
        this.namedSend(senderLoc, receiverLoc, msg, session);
    }

    public void send(Node node, Symbol name, Object msg) {
        this.send(node, name, msg, Symbol$.MODULE$.apply("nosession"));
    }

    public Symbol getOrCreateName(OutputChannel<Object> from2) {
        Option option;
        block4: {
            Symbol symbol;
            block3: {
                block2: {
                    option = this.names().get(from2);
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    Symbol freshName = FreshNameCreator$.MODULE$.newName("remotesender");
                    this.register(freshName, from2);
                    symbol = freshName;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                symbol = (Symbol)((Some)option).x();
            }
            return symbol;
        }
        throw new MatchError(option);
    }

    public void register(Symbol name, OutputChannel<Object> a) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            this.actors().$plus$eq(Predef$Pair$.MODULE$.apply(name, a));
            this.names().$plus$eq(Predef$Pair$.MODULE$.apply(a, name));
            return;
        }
    }

    private HashMap names() {
        return this.names;
    }

    private HashMap actors() {
        return this.actors;
    }

    public void namedSend(Locator senderLoc, Locator receiverLoc, Object msg, Symbol session) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.sendToNode(receiverLoc.node(), new NamedSend(senderLoc, receiverLoc, bytes, session));
    }

    public void sendToNode(Node node, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.service.send(node, bytes);
    }

    @Override
    public int $tag() throws RemoteException {
        return ScalaObject$class.$tag(this);
    }
}

