/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.http;

import com.sun.midp.io.InternalConnector;
import com.sun.midp.io.j2me.http.StreamConnectionElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.StreamConnection;

class StreamConnectionPool {
    private Vector m_connections;
    private int m_max_connections;
    private int m_cur_connections;
    private final long CONNECTION_ACTIVE_WAIT_TIME;

    public StreamConnectionPool(int number_of_connections) throws IOException {
        this.CONNECTION_ACTIVE_WAIT_TIME = 60000L;
        this.m_max_connections = number_of_connections;
        this.m_connections = new Vector(this.m_max_connections + 1);
    }

    public synchronized void dumpPool() {
        if (this.m_connections.size() == 0) {
            return;
        }
        Enumeration cons = this.m_connections.elements();
        System.out.println("============================================");
        while (cons.hasMoreElements()) {
            StreamConnectionElement scc = (StreamConnectionElement)cons.nextElement();
            System.out.println("Host [" + scc.m_host + "]");
            System.out.println("Port [" + scc.m_port + "]");
            System.out.println("URL  [" + scc.m_url + "]");
            System.out.println("Conn [" + scc.m_connection + "]");
            System.out.println("InUse[" + scc.m_in_use + "]");
            System.out.println("-----------------------------------------");
        }
        System.out.println("============================================");
    }

    public synchronized void create(String p_url, String p_host, int p_port, String p_connection) throws IOException {
        StreamConnectionElement scc = this.createStreamConnectionElement(p_url, p_host, p_port, p_connection);
        scc.setInUse(false);
        this.m_connections.addElement(scc);
    }

    public synchronized boolean remove(StreamConnectionElement scc) {
        if (scc == null) {
            return true;
        }
        boolean rc = this.m_connections.removeElement(scc);
        return rc;
    }

    public synchronized StreamConnectionElement getConnection(String p_url, String p_host, int p_port, String p_connection) throws IOException {
        StreamConnectionElement scc;
        if (this.m_connections.size() > 0) {
            Enumeration cons = this.m_connections.elements();
            Vector vector = this.m_connections;
            synchronized (vector) {
                while (cons.hasMoreElements()) {
                    scc = (StreamConnectionElement)cons.nextElement();
                    if (!p_host.equals(scc.m_host) || p_port != scc.m_port || scc.m_in_use) continue;
                    scc.setInUse(true);
                    StreamConnectionElement streamConnectionElement = scc;
                    return streamConnectionElement;
                }
            }
        }
        scc = this.createStreamConnectionElement(p_url, p_host, p_port, p_connection);
        this.m_connections.addElement(scc);
        return this.getConnection(p_url, p_host, p_port, p_connection);
    }

    private synchronized StreamConnectionElement createStreamConnectionElement(String p_url, String p_host, int p_port, String p_connection) throws IOException {
        int cur_connections = this.m_connections.size();
        long c_time = System.currentTimeMillis();
        if (cur_connections > this.m_max_connections) {
            Enumeration cons = this.m_connections.elements();
            while (cons.hasMoreElements()) {
                boolean rc;
                StreamConnectionElement scc = (StreamConnectionElement)cons.nextElement();
                if (!scc.m_in_use) {
                    rc = this.m_connections.removeElement(scc);
                    break;
                }
                if (c_time - scc.m_time <= 60000L) continue;
                rc = this.m_connections.removeElement(scc);
            }
            throw new IOException("exceeded the configured maximum number of connections");
        }
        StreamConnection sc = (StreamConnection)InternalConnector.openInternal("socket://" + p_connection, 3, false);
        DataOutputStream dos = sc.openDataOutputStream();
        DataInputStream dis = sc.openDataInputStream();
        StreamConnectionElement scc = new StreamConnectionElement(p_url, p_host, p_port, p_connection, sc, dos, dis);
        return scc;
    }

    public synchronized void returnConnection(StreamConnection returned) {
        Vector vector = this.m_connections;
        synchronized (vector) {
            Enumeration cons = this.m_connections.elements();
            while (cons.hasMoreElements()) {
                StreamConnectionElement scc = (StreamConnectionElement)cons.nextElement();
                StreamConnectionElement conn = scc;
                if (conn != returned) continue;
                scc.setInUse(false);
                break;
            }
        }
    }
}

