/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TaGLayout;

public class Form
extends Screen {
    private static final int GROW_SIZE = 4;
    private Item[] items;
    private int numOfItems;
    private int curItemIndex = -1;
    private int curItemY;
    private ItemStateListener itemStateListener;

    public Form(String title) {
        this(title, null);
    }

    public Form(String title, Item[] items) {
        super(title);
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (items == null) {
                this.items = new Item[4];
                return;
            }
            this.items = new Item[items.length > 4 ? items.length : 4];
            int i = 0;
            while (i < items.length) {
                if (items[i].getOwner() != null) {
                    throw new IllegalStateException();
                }
                ++i;
            }
            this.numOfItems = items.length;
            TaGLayout lastTagLayout = null;
            int i2 = 0;
            while (i2 < this.numOfItems) {
                items[i2].setOwner(this);
                if (items[i2].isGroupable()) {
                    if (lastTagLayout == null) {
                        lastTagLayout = new TaGLayout(Screen.CONTENT_FONT);
                    }
                    lastTagLayout.insert(null, items[i2]);
                } else {
                    lastTagLayout = null;
                }
                this.items[i2] = items[i2];
                ++i2;
            }
        }
    }

    public int append(Item item) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (item.getOwner() != null) {
                throw new IllegalStateException();
            }
            int n = this.insertImpl(this.numOfItems, item);
            return n;
        }
    }

    public int append(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.insertImpl(this.numOfItems, new StringItem(null, str));
            return n;
        }
    }

    public int append(Image img) {
        if (img == null) {
            throw new NullPointerException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.insertImpl(this.numOfItems, new ImageItem(null, img, 0, null));
            return n;
        }
    }

    public void insert(int itemNum, Item item) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (item.getOwner() != null) {
                throw new IllegalStateException();
            }
            if (itemNum < 0 || itemNum > this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            this.insertImpl(itemNum, item);
        }
    }

    public void delete(int itemNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int deletedHeight;
            if (itemNum < 0 || itemNum >= this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            Item deletedItem = this.items[itemNum];
            int n = deletedHeight = this.initLayoutDone() ? -deletedItem.getHeight() : 0;
            if (deletedItem.isGroupable()) {
                deletedHeight = ((TaGLayout)deletedItem.layouts[0]).delete(deletedItem);
            } else if (itemNum > 0 && itemNum < this.numOfItems - 1 && this.items[itemNum - 1].isGroupable() && this.items[itemNum + 1].isGroupable()) {
                TaGLayout tag = (TaGLayout)this.items[itemNum - 1].layouts[0];
                deletedHeight -= this.items[itemNum + 1].getHeight();
                int i = itemNum + 1;
                while (i < this.numOfItems) {
                    if (!this.items[i].isGrouped(this.items[itemNum + 1])) break;
                    deletedHeight += tag.insert(null, this.items[i]);
                    ++i;
                }
            }
            if (this.numOfItems > 1 && this.curItemIndex == itemNum) {
                if (this.curItemIndex > 0) {
                    this.moveCurItem(this.curItemIndex - 1);
                } else {
                    this.moveCurItem(this.curItemIndex + 1);
                }
            }
            if (this.curItemIndex >= itemNum) {
                --this.curItemIndex;
            }
            deletedItem.setOwner(null);
            --this.numOfItems;
            if (itemNum < this.numOfItems) {
                System.arraycopy(this.items, itemNum + 1, this.items, itemNum, this.numOfItems - itemNum);
            }
            this.items[this.numOfItems] = null;
            this.contentChanged(null, 0, 0, deletedHeight);
        }
    }

    public void set(int itemNum, Item item) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (item.getOwner() != null) {
                throw new IllegalStateException();
            }
            if (itemNum < 0 || itemNum >= this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            this.setImpl(itemNum, item);
        }
    }

    public Item get(int itemNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (itemNum < 0 || itemNum >= this.numOfItems) {
                throw new IndexOutOfBoundsException();
            }
            Item item = this.items[itemNum];
            return item;
        }
    }

    public void setItemStateListener(ItemStateListener iListener) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.itemStateListener = iListener;
        }
    }

    public int size() {
        return this.numOfItems;
    }

    void paintContent(Graphics g) {
        int clipY1 = g.getClipY();
        int clipY2 = clipY1 + g.getClipHeight();
        int translatedY = 0;
        Item prevItem = null;
        int i = 0;
        while (i < this.numOfItems && translatedY < clipY2) {
            if (!this.items[i].isGrouped(prevItem)) {
                int h = this.items[i].getHeight();
                if (translatedY + h >= clipY1) {
                    this.items[i].paint(g);
                }
                translatedY += h;
                g.translate(0, h);
                prevItem = this.items[i];
            }
            ++i;
        }
        if (translatedY < clipY2) {
            g.setColor(Display.ERASE_COLOR);
            g.fillRect(g.getClipX(), 0, g.getClipWidth(), clipY2 - translatedY);
        }
    }

    int layoutContent(int w, int h) {
        if (this.numOfItems == 0) {
            return 0;
        }
        int height = this.items[0].setWidth(w);
        int i = 1;
        while (i < this.numOfItems) {
            if (!this.items[i].isGrouped(this.items[i - 1])) {
                height += this.items[i].setWidth(w);
            }
            ++i;
        }
        return height;
    }

    int initHilight(int vpY, int vpH) {
        if (this.numOfItems == 0) {
            return 0;
        }
        if (this.curItemIndex != -1 && this.items[this.curItemIndex].hasFocus()) {
            this.items[this.curItemIndex].setFocus(false);
        }
        this.curItemY = 0;
        this.curItemIndex = 0;
        if (!this.items[0].takesFocus() && this.items[0].getHeight() < vpH && !this.items[0].isGrouped(this.items[this.numOfItems - 1])) {
            int i = 1;
            while (i < this.numOfItems) {
                if (!this.items[i].isGrouped(this.items[0])) {
                    this.curItemIndex = i;
                    this.curItemY = this.items[i - 1].getHeight();
                    break;
                }
                ++i;
            }
        }
        if (this.items[this.curItemIndex].takesFocus()) {
            this.items[this.curItemIndex].setFocus(true);
            this.items[this.curItemIndex].initHilight(vpY - this.curItemY, vpH);
        }
        return 0;
    }

    ItemStateListener getItemStateListener() {
        return this.itemStateListener;
    }

    private int insertImpl(int itemNum, Item item) {
        boolean forceFocus = false;
        if (this.items.length == this.numOfItems) {
            Item[] newItems = new Item[this.numOfItems + 4];
            System.arraycopy(this.items, 0, newItems, 0, itemNum);
            System.arraycopy(this.items, itemNum, newItems, itemNum + 1, this.numOfItems - itemNum);
            this.items = newItems;
        } else {
            System.arraycopy(this.items, itemNum, this.items, itemNum + 1, this.numOfItems - itemNum);
        }
        ++this.numOfItems;
        if (this.initLayoutDone()) {
            if (this.curItemIndex == -1) {
                this.curItemIndex = 0;
                forceFocus = true;
            }
            if (this.curItemIndex > itemNum) {
                ++this.curItemIndex;
            }
        }
        this.items[itemNum] = null;
        this.setImpl(itemNum, item);
        if (forceFocus && this.items[this.curItemIndex].takesFocus()) {
            this.items[this.curItemIndex].setFocus(true);
        }
        return itemNum;
    }

    private void setImpl(int itemNum, Item item) {
        int deltaHeight = 0;
        boolean itemHadFocus = false;
        Item oldItem = this.items[itemNum];
        if (oldItem != null) {
            if (this.initLayoutDone()) {
                deltaHeight = -oldItem.getHeight();
            }
            itemHadFocus = oldItem.hasFocus();
        }
        if (item.isGroupable()) {
            if (oldItem != null && oldItem.isGroupable()) {
                TaGLayout tag = (TaGLayout)oldItem.layouts[0];
                deltaHeight = tag.set(oldItem, item);
            } else if (itemNum + 1 < this.numOfItems && this.items[itemNum + 1].isGroupable()) {
                TaGLayout tag = (TaGLayout)this.items[itemNum + 1].layouts[0];
                deltaHeight = tag.insert(this.items[itemNum + 1], item);
                if (this.curItemIndex == itemNum + 1 && tag.get(item) == 0) {
                    this.curItemIndex = itemNum;
                }
            } else if (itemNum > 0 && this.items[itemNum - 1].isGroupable()) {
                TaGLayout tag = (TaGLayout)this.items[itemNum - 1].layouts[0];
                deltaHeight = tag.insert(null, item);
                if (this.curItemIndex == itemNum - 1 && tag.getSize() > 2) {
                    this.curItemIndex = itemNum;
                }
            } else {
                TaGLayout tag = new TaGLayout(Screen.CONTENT_FONT);
                tag.insert(null, item);
                if (this.initLayoutDone()) {
                    deltaHeight = tag.setWidth(Display.WIDTH);
                }
            }
        } else {
            if (oldItem != null && oldItem.isGroupable()) {
                TaGLayout tag = (TaGLayout)oldItem.layouts[0];
                deltaHeight = tag.delete(oldItem);
            }
            if (itemNum > 0 && itemNum + 1 < this.numOfItems && this.items[itemNum - 1].isGrouped(this.items[itemNum + 1])) {
                TaGLayout prevTag = (TaGLayout)this.items[itemNum - 1].layouts[0];
                TaGLayout nextTag = new TaGLayout(Screen.CONTENT_FONT);
                int i = itemNum + 1;
                while (i < this.numOfItems) {
                    if (this.items[i].layouts[0] != prevTag) break;
                    deltaHeight += prevTag.delete(this.items[i]);
                    nextTag.insert(null, this.items[i]);
                    ++i;
                }
                if (this.initLayoutDone()) {
                    deltaHeight += nextTag.setWidth(Display.WIDTH);
                }
            }
            if (this.initLayoutDone()) {
                deltaHeight += item.setWidth(Display.WIDTH);
            }
        }
        item.setOwner(this);
        item.setFocus(itemHadFocus);
        this.items[itemNum] = item;
        if (oldItem != null) {
            oldItem.setOwner(null);
        }
        this.contentChanged(this.items[itemNum], 0, 0, deltaHeight);
    }

    int getItemY(Item item) {
        if (this.numOfItems == 1) {
            return item == this.items[0] ? 0 : -1;
        }
        int i = 1;
        int y = 0;
        while (i < this.numOfItems) {
            if (!this.items[i].isGrouped(this.items[i - 1])) {
                y += this.items[i - 1].getHeight();
            }
            if (this.items[i] == item) {
                return y;
            }
            ++i;
        }
        return -1;
    }

    void keyPressed(int keyCode) {
        Item curItem = null;
        ItemStateListener isl = null;
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.numOfItems == 0) {
                return;
            }
            int gameKeyCode = Display.getGameAction(keyCode);
            if (gameKeyCode == 1 || gameKeyCode == 6) {
                super.keyPressedImpl(keyCode);
            } else if (this.curItemIndex != -1) {
                curItem = this.items[this.curItemIndex];
                if (gameKeyCode == 8 && curItem.select() || curItem.keyPressed(keyCode)) {
                    isl = this.itemStateListener;
                }
            }
        }
        if (isl != null) {
            try {
                Object gameKeyCode = Display.calloutLock;
                synchronized (gameKeyCode) {
                    isl.itemStateChanged(curItem);
                }
            }
            catch (Throwable thr) {
                Display.handleThrowable(thr);
            }
        }
    }

    static int traverse(boolean down, int top, int bottom, int height, int lineHeight, boolean traversingIn, boolean takesFocus) {
        int heightToEnd;
        if (down && bottom >= height || !down && top <= 0) {
            return traversingIn && takesFocus ? 0 : -1;
        }
        int vpHeight = bottom - top;
        int n = heightToEnd = down ? height - bottom : top;
        if (traversingIn) {
            int s = vpHeight;
            if (down && top < 0) {
                s = -top;
            } else if (!down && height < bottom) {
                s = bottom - height;
            }
            if (heightToEnd < s) {
                s = heightToEnd;
            }
            return s;
        }
        if (heightToEnd <= vpHeight) {
            return heightToEnd;
        }
        int blockIncr = vpHeight - lineHeight / 2;
        blockIncr = blockIncr < lineHeight ? lineHeight : (blockIncr -= blockIncr % lineHeight);
        return heightToEnd < blockIncr ? heightToEnd : blockIncr;
    }

    int traverse(int gameKeyCode, int top, int bottom) {
        if (gameKeyCode != 1 && gameKeyCode != 6) {
            return -1;
        }
        int dir = gameKeyCode == 1 ? -1 : 1;
        Item curItem = this.items[this.curItemIndex];
        int itemNum = this.curItemIndex;
        int y = this.curItemY;
        int i = this.curItemIndex;
        while (i >= 0 && i < this.numOfItems) {
            boolean traversingIn;
            boolean bl = traversingIn = i != this.curItemIndex;
            if (!traversingIn || !this.items[i].isGrouped(this.items[itemNum])) {
                if (traversingIn) {
                    int itemHeight = this.items[i].getHeight();
                    y = dir < 0 ? (y -= itemHeight) : (y += this.items[itemNum].getHeight());
                    itemNum = i;
                }
                int vpY1 = top - y;
                int vpY2 = bottom - y;
                boolean allowExit = dir < 0 ? i != 0 : i != this.numOfItems - 1;
                int scrollHeight = this.items[i].traverse(gameKeyCode, vpY1, vpY2, traversingIn, allowExit);
                if (scrollHeight >= 0) {
                    if (traversingIn) {
                        this.moveCurItem(i);
                        this.curItemY = y;
                    }
                    return scrollHeight;
                }
            }
            i += dir;
        }
        return -1;
    }

    private void moveCurItem(int newCurItem) {
        if (!this.initLayoutDone()) {
            return;
        }
        if (this.curItemIndex != -1 && this.items[this.curItemIndex] != null && this.items[this.curItemIndex].hasFocus()) {
            this.items[this.curItemIndex].setFocus(false);
        }
        this.curItemIndex = newCurItem;
        if (this.curItemIndex != -1 && this.items[this.curItemIndex].takesFocus()) {
            this.items[this.curItemIndex].setFocus(true);
        }
    }

    int heightChanged(int vpY, int vpH, int deltaHeight) {
        vpY = super.heightChanged(vpY, vpH, deltaHeight);
        if (this.curItemIndex != -1 && this.numOfItems > 1) {
            this.curItemY = 0;
            int i = 1;
            while (i < this.numOfItems) {
                if (!this.items[i].isGrouped(this.items[i - 1])) {
                    int h = this.items[i - 1].getHeight();
                    if (this.curItemY + h > vpY + vpH) {
                        this.moveCurItem(i);
                        return vpY;
                    }
                    this.curItemY += h;
                }
                if (this.curItemY >= vpY && this.items[i].takesFocus()) {
                    this.moveCurItem(i);
                    return vpY;
                }
                ++i;
            }
            return this.initHilight(vpY, vpH);
        }
        return vpY;
    }

    void keyTyped(char c) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.curItemIndex != -1) {
                this.items[this.curItemIndex].keyTyped(c);
            }
        }
    }

    static final void itemStateChanged(Item item, ItemStateListener isl) {
        if (isl == null || item == null) {
            return;
        }
        try {
            Object object = Display.calloutLock;
            synchronized (object) {
                isl.itemStateChanged(item);
            }
        }
        catch (Throwable thr) {
            Display.handleThrowable(thr);
        }
    }
}

