/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Layout;
import javax.microedition.lcdui.StringLayout;
import javax.microedition.lcdui.Ticker;

public abstract class Screen
extends Displayable {
    private Ticker ticker;
    private static final Timer tickerTimer;
    private TickerPainter tickerPainter;
    private Layout screenTitle;
    private boolean visible;
    private boolean tickerIsVisible;
    private boolean layoutDoneOnce;
    private static final Font TITLE_FONT;
    private static final int TITLE_HEIGHT;
    static final Font CONTENT_FONT;
    static final int CONTENT_HEIGHT;
    private int childHeight;
    boolean hasBorder;
    private int globalViewPortX;
    private int globalViewPortY;
    private int viewPortY;
    int viewPortWidth;
    int viewPortHeight;
    private static final Image TITLE_IMG;

    Screen() {
        this(null);
    }

    Screen(String title) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (title != null) {
                this.screenTitle = new StringLayout(title, TITLE_FONT);
            }
        }
    }

    public String getTitle() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            String string = this.getTitleImpl();
            return string;
        }
    }

    public void setTitle(String s) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            String oldTitle = this.getTitleImpl();
            if (oldTitle == null && s == null || oldTitle != null && s != null && oldTitle.equals(s)) {
                return;
            }
            int deltaHeight = 0;
            if (this.screenTitle != null) {
                deltaHeight = ((StringLayout)this.screenTitle).setString(s);
            } else if (s != null) {
                this.screenTitle = new StringLayout(s, TITLE_FONT);
                if (this.layoutDoneOnce) {
                    deltaHeight = this.screenTitle.setWidth(Display.WIDTH);
                }
            }
            if (!this.layoutDoneOnce) {
                return;
            }
            if (deltaHeight == 0) {
                if (this.visible) {
                    int y = 0;
                    if (this.tickerIsVisible) {
                        y = Ticker.PREFERRED_HEIGHT;
                    }
                    this.repaint(0, y, Display.WIDTH, this.screenTitle.getHeight());
                }
                return;
            }
            this.layoutChanged();
        }
    }

    public void setTicker(Ticker ticker) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.ticker == ticker) {
                return;
            }
            this.stopTicker();
            if (ticker != null) {
                ticker.reset();
            }
            Ticker oldTicker = this.ticker;
            this.ticker = ticker;
            if (this.tickerIsVisible && ticker == null || oldTicker == null) {
                this.layoutChanged();
            }
            if (ticker != null && this.tickerIsVisible) {
                this.startTicker();
            }
        }
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    abstract void paintContent(Graphics var1);

    abstract int layoutContent(int var1, int var2);

    int getMinimumContentHeight(int width, int height) {
        return this.hasBorder ? CONTENT_HEIGHT * 2 + 8 : CONTENT_HEIGHT * 2;
    }

    void layoutChanged() {
        if (this.layoutDoneOnce) {
            this.doLayout();
            if (this.visible) {
                this.repaint(0, 0, Display.WIDTH, Display.HEIGHT);
            }
        }
    }

    final void doLayout() {
        int tickerHeight = 0;
        if (this.ticker != null) {
            this.tickerIsVisible = true;
            tickerHeight = Ticker.PREFERRED_HEIGHT;
        }
        int titleHeight = 0;
        int titleBorder = 0;
        String title = this.getTitleImpl();
        if (title != null && !title.equals("")) {
            this.screenTitle.setMaxHeight(2 * TITLE_HEIGHT);
            titleHeight = this.screenTitle.setWidth(Display.WIDTH);
            titleBorder = TITLE_IMG.getHeight() + 1;
        }
        int h = tickerHeight + titleHeight + titleBorder + this.getMinimumContentHeight(Display.WIDTH, Display.HEIGHT - TITLE_HEIGHT);
        this.globalViewPortY = 0;
        if (tickerHeight > 0 && h > Display.HEIGHT) {
            h -= tickerHeight;
            this.tickerIsVisible = false;
        } else {
            this.globalViewPortY = tickerHeight;
        }
        if (titleHeight != 0 && h > Display.HEIGHT && titleHeight > TITLE_HEIGHT) {
            h = h - titleHeight + TITLE_HEIGHT;
            titleHeight = TITLE_HEIGHT;
            this.screenTitle.setMaxHeight(titleHeight);
        }
        this.globalViewPortY += titleHeight + titleBorder;
        this.viewPortWidth = Display.WIDTH;
        this.viewPortHeight = Display.HEIGHT - this.globalViewPortY;
        if (this.hasBorder) {
            this.globalViewPortX = 4;
            this.globalViewPortY += 4;
            this.viewPortWidth -= 8;
            this.viewPortHeight -= 8;
        }
        this.childHeight = this.layoutContent(this.viewPortWidth, this.viewPortHeight);
        this.viewPortY = this.initHilight(this.viewPortY, this.viewPortHeight);
        this.layoutDoneOnce = true;
    }

    void setChild(int height) {
        this.childHeight = height;
    }

    int initHilight(int vpY, int vpH) {
        return 0;
    }

    int heightChanged(int vpY, int vpH, int deltaHeight) {
        this.childHeight += deltaHeight;
        if (vpY + vpH > this.childHeight && (vpY = this.childHeight - vpH) < 0) {
            vpY = 0;
        }
        return vpY;
    }

    void contentChanged(Item item, int x, int y, int deltaHeight) {
        if (!this.initLayoutDone()) {
            return;
        }
        if (deltaHeight != 0) {
            this.viewPortY = this.heightChanged(this.viewPortY, this.viewPortHeight, deltaHeight);
        }
        if (this.isShown()) {
            this.setVerticalScroll();
            if (deltaHeight == 0 && item != null) {
                item.repaint(x, y, this.viewPortWidth, item.getHeight() - y);
                return;
            }
            this.repaintContent();
        }
    }

    void setVerticalScroll() {
        if (this.childHeight <= this.viewPortHeight) {
            super.setVerticalScroll(0, 100);
        } else {
            super.setVerticalScroll(this.viewPortY * 100 / (this.childHeight - this.viewPortHeight), this.viewPortHeight * 100 / this.childHeight);
        }
    }

    final boolean initLayoutDone() {
        return this.layoutDoneOnce;
    }

    final void repaintContent() {
        this.repaint(this.globalViewPortX, this.globalViewPortY, this.viewPortWidth, this.viewPortHeight);
    }

    final void repaintContent(int x, int y, int width, int height) {
        if (y < this.viewPortY + this.viewPortHeight && y + height > this.viewPortY) {
            this.repaint(x + this.globalViewPortX, y + this.globalViewPortY - this.viewPortY, width, height);
        }
    }

    final void paint(Graphics g) {
        int clipRectY1 = g.getClipY();
        int clipRectY2 = clipRectY1 + g.getClipHeight();
        int translatedY = 0;
        int titleTextHeight = 0;
        int titleHeight = 0;
        Object object = Display.LCDUILock;
        synchronized (object) {
            String title = this.getTitleImpl();
            if (title != null && !title.equals("") && this.screenTitle != null) {
                titleTextHeight = this.screenTitle.getHeight() + 2;
                titleHeight = titleTextHeight + TITLE_IMG.getHeight();
            }
            if (this.tickerIsVisible) {
                if (clipRectY2 > 0) {
                    if (clipRectY1 < Ticker.PREFERRED_HEIGHT) {
                        this.ticker.paintContent(g);
                    }
                }
                translatedY += Ticker.PREFERRED_HEIGHT;
                g.translate(0, Ticker.PREFERRED_HEIGHT);
            }
            if (titleHeight != 0) {
                if (clipRectY2 > translatedY && clipRectY1 < translatedY + titleHeight) {
                    g.setColor(Display.ERASE_COLOR);
                    g.fillRect(0, 0, Display.WIDTH, titleHeight);
                    this.screenTitle.paint(g, false, false);
                    int imgLoc = 0;
                    while (imgLoc < Display.WIDTH) {
                        g.drawImage(TITLE_IMG, imgLoc, titleTextHeight, 36);
                        imgLoc += 96;
                    }
                }
                translatedY += titleHeight;
                g.translate(0, titleHeight);
            }
            if (clipRectY2 > translatedY && clipRectY1 < Display.HEIGHT) {
                if (this.hasBorder) {
                    g.setColor(Display.ERASE_COLOR);
                    g.drawRect(0, 0, this.viewPortWidth + 7, this.viewPortHeight + 7);
                    g.drawRect(1, 1, this.viewPortWidth + 5, this.viewPortHeight + 5);
                    g.drawRect(3, 3, this.viewPortWidth + 1, this.viewPortHeight + 1);
                    g.setColor(0);
                    g.drawRect(2, 2, this.viewPortWidth + 3, this.viewPortHeight + 3);
                }
                g.translate(this.globalViewPortX, this.globalViewPortY - translatedY - this.viewPortY);
                g.clipRect(0, this.viewPortY, this.viewPortWidth, this.viewPortHeight);
                this.paintContent(g);
            }
        }
    }

    int traverse(int dir, int top, int bottom) {
        int blockIncr;
        if (dir == 1) {
            if (top <= 0) {
                return -1;
            }
        } else if (dir == 6) {
            if (bottom >= this.childHeight) {
                return -1;
            }
        } else {
            return -1;
        }
        if ((blockIncr = ((bottom - top + CONTENT_HEIGHT / 2) / CONTENT_HEIGHT - 1) * CONTENT_HEIGHT) < CONTENT_HEIGHT) {
            blockIncr = CONTENT_HEIGHT;
        }
        if (dir == 6 && this.childHeight - bottom < blockIncr) {
            return this.childHeight - bottom;
        }
        if (dir == 1 && top < blockIncr) {
            return top;
        }
        return blockIncr;
    }

    void keyPressed(int keyCode) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.keyPressedImpl(keyCode);
        }
    }

    void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    void pointerPressedImpl(int x, int y) {
    }

    void pointerReleasedImpl(int x, int y) {
    }

    void pointerDraggedImpl(int x, int y) {
    }

    boolean isEditScreen(Displayable d) {
        return false;
    }

    void getContentRect(int[] rect) {
        if (rect != null && rect.length >= 4) {
            rect[0] = this.globalViewPortX;
            rect[1] = this.globalViewPortY;
            rect[2] = this.viewPortWidth;
            rect[3] = this.viewPortHeight;
            if (this.hasBorder) {
                rect[0] = rect[0] - 2;
                rect[1] = rect[1] - 2;
                rect[2] = rect[2] + 4;
                rect[3] = rect[3] + 4;
            }
        }
    }

    void keyPressedImpl(int keyCode) {
        int gameKeyCode = Display.getGameAction(keyCode);
        switch (gameKeyCode) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                int scrollHeight = this.traverse(gameKeyCode, this.viewPortY, this.viewPortY + this.viewPortHeight);
                if (scrollHeight < 0) {
                    return;
                }
                if (scrollHeight > 0) {
                    if (gameKeyCode == 1 || gameKeyCode == 2) {
                        this.viewPortY -= scrollHeight;
                    } else if (gameKeyCode == 6 || gameKeyCode == 5) {
                        this.viewPortY += scrollHeight;
                    }
                }
                this.repaintContent();
                this.setVerticalScroll();
            }
        }
    }

    void keyRepeatedImpl(int keyCode) {
        this.keyPressedImpl(keyCode);
    }

    void keyReleasedImpl(int keyCode) {
    }

    void keyTypedImpl(int keyCode) {
    }

    void hideNotifyImpl(Display d) {
        super.hideNotifyImpl(d);
        if (!this.visible) {
            return;
        }
        this.visible = false;
        this.stopTicker();
    }

    void showNotifyImpl(Display d) {
        super.showNotifyImpl(d);
        if (this.visible) {
            return;
        }
        if (this.layoutDoneOnce) {
            Displayable currentCopy = d.getCurrent();
            if (currentCopy != this && currentCopy instanceof Screen && !((Screen)currentCopy).isEditScreen(this)) {
                this.viewPortY = this.initHilight(this.viewPortY, this.viewPortHeight);
            }
        } else {
            this.doLayout();
        }
        this.visible = true;
        this.startTicker();
        this.repaint(0, 0, Display.WIDTH, Display.HEIGHT);
        this.setVerticalScroll();
    }

    private void startTicker() {
        if (this.visible && this.tickerIsVisible) {
            this.tickerPainter = new TickerPainter();
            tickerTimer.schedule((TimerTask)this.tickerPainter, 0L, 250L);
        }
    }

    private void stopTicker() {
        if (this.tickerPainter != null) {
            this.tickerPainter.cancel();
            this.tickerPainter = null;
        }
    }

    private String getTitleImpl() {
        return this.screenTitle == null ? null : ((StringLayout)this.screenTitle).getString();
    }

    static {
        TITLE_FONT = Font.getFont(0, 1, 0);
        TITLE_HEIGHT = TITLE_FONT.getHeight();
        CONTENT_FONT = Font.getDefaultFont();
        CONTENT_HEIGHT = CONTENT_FONT.getHeight();
        byte[] title_data = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 96, 0, 0, 0, 2, 2, 3, 0, 0, 0, -38, -54, 49, -6, 0, 0, 0, 6, 80, 76, 84, 69, -69, -69, -69, 106, 106, 106, 15, 59, -17, 122, 0, 0, 0, 16, 73, 68, 65, 84, 120, -38, 99, 96, -64, 1, 24, 67, 113, 72, 0, 0, 8, 67, 0, 87, -24, 47, -109, 56, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        TITLE_IMG = Image.createImage(title_data, 0, title_data.length);
        tickerTimer = new Timer();
    }

    private class TickerPainter
    extends TimerTask {
        private TickerPainter() {
        }

        public final void run() {
            Object object = Display.LCDUILock;
            synchronized (object) {
                Screen.this.repaint(0, 2, Display.WIDTH, CONTENT_HEIGHT);
            }
        }
    }
}

