/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.scalatest.Reporter;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.junit.JUnit3Suite;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTestListener
implements TestListener,
ScalaObject {
    private final Set<Test> failedTestsSet;
    private final Tracker tracker;
    private final Reporter report;

    public MyTestListener(Reporter report, Tracker tracker) {
        this.report = report;
        this.tracker = tracker;
        this.failedTestsSet = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Test[0]));
    }

    public void endTest(Test testCase) {
        boolean testHadFailed = this.failedTestsSet().contains((Object)testCase);
        if (testHadFailed) {
            this.failedTestsSet().$minus$eq((Object)testCase);
        } else {
            Test test2 = testCase;
            if (test2 == null || test2.equals(null)) {
                throw new NullPointerException("testCase was null");
            }
            this.report.apply(TestSucceeded$.MODULE$.apply(this.tracker.nextOrdinal(), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString()));
        }
    }

    public void addFailure(Test testCase, AssertionFailedError assertionFailedError) {
        Test test2 = testCase;
        if (test2 == null || test2.equals(null)) {
            throw new NullPointerException("testCase was null");
        }
        AssertionFailedError assertionFailedError2 = assertionFailedError;
        if (assertionFailedError2 == null || assertionFailedError2.equals(null)) {
            throw new NullPointerException("throwable was null");
        }
        this.report.apply(TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable((Throwable)assertionFailedError, true), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Throwable>)new Some((Object)assertionFailedError)));
        this.failedTestsSet().$plus$eq((Object)testCase);
    }

    public void addError(Test testCase, Throwable throwable) {
        Test test2 = testCase;
        if (test2 == null || test2.equals(null)) {
            throw new NullPointerException("testCase was null");
        }
        Throwable throwable2 = throwable;
        if (throwable2 == null || throwable2.equals(null)) {
            throw new NullPointerException("throwable was null");
        }
        this.report.apply(TestFailed$.MODULE$.apply(this.tracker.nextOrdinal(), this.getMessageGivenThrowable(throwable, false), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString(), (Option<Throwable>)new Some((Object)throwable)));
        this.failedTestsSet().$plus$eq((Object)testCase);
    }

    public void startTest(Test testCase) {
        Test test2 = testCase;
        if (test2 == null || test2.equals(null)) {
            throw new NullPointerException("testCase was null");
        }
        this.report.apply(TestStarting$.MODULE$.apply(this.tracker.nextOrdinal(), this.getSuiteNameForTestCase(testCase), (Option<String>)new Some((Object)testCase.getClass().getName()), testCase.toString()));
    }

    public String getMessageGivenThrowable(Throwable throwable, boolean isAssertionFailedError) {
        String string = throwable.getMessage();
        return string == null || string.equals(null) ? new StringBuilder().append((Object)"A JUnit3Suite test failed with an ").append((Object)(isAssertionFailedError ? "AssertionFailedError" : "exception")).toString() : throwable.getMessage();
    }

    private String getSuiteNameForTestCase(Test testCase) {
        Test temp5;
        block5: {
            String string;
            block4: {
                block2: {
                    block3: {
                        JUnit3Suite temp6;
                        temp5 = testCase;
                        if (!(temp5 instanceof JUnit3Suite)) break block2;
                        JUnit3Suite junit3Suite = temp6 = (JUnit3Suite)temp5;
                        if (!true) break block3;
                        junit3Suite = temp6;
                        string = junit3Suite.suiteName();
                        break block4;
                    }
                    throw new MatchError(temp5.toString());
                }
                if (!true) break block5;
                string = Suite$.MODULE$.getSimpleNameOfAnObjectsClass(testCase);
            }
            return string;
        }
        throw new MatchError(temp5.toString());
    }

    private Set<Test> failedTestsSet() {
        return this.failedTestsSet;
    }
}

