/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2010-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  Copyright (c) 2003-2008                                                **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/**
 * @file  epk_mpiwrap_err.c
 *
 * @brief C interface wrappers for error handling
 */

#include <mpi.h>

#include "esd_event.h"

#include "epk_defs_mpi.h"
#include "epk_mpiwrap.h"

/**
 * @name C wrappers
 * @{
 */

#if defined(HAS_MPI_ADD_ERROR_CLASS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Add_error_class
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup err
 */
int MPI_Add_error_class(int* errorclass)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ADD_ERROR_CLASS]);

    return_val = PMPI_Add_error_class(errorclass);

    esd_exit(epk_mpi_regid[EPK__MPI_ADD_ERROR_CLASS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Add_error_class(errorclass);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ADD_ERROR_CODE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Add_error_code
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup err
 */
int MPI_Add_error_code(int  errorclass,
                       int* errorcode)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ADD_ERROR_CODE]);

    return_val = PMPI_Add_error_code(errorclass, errorcode);

    esd_exit(epk_mpi_regid[EPK__MPI_ADD_ERROR_CODE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Add_error_code(errorclass, errorcode);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ADD_ERROR_STRING) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Add_error_string
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup err
 */
int MPI_Add_error_string(int   errorcode,
                         char* string)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ADD_ERROR_STRING]);

    return_val = PMPI_Add_error_string(errorcode, string);

    esd_exit(epk_mpi_regid[EPK__MPI_ADD_ERROR_STRING]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Add_error_string(errorcode, string);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ERRHANDLER_CREATE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Errhandler_create
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup err
 */
int MPI_Errhandler_create(MPI_Handler_function* function,
                          MPI_Errhandler*       errhandler)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ERRHANDLER_CREATE]);

    return_val = PMPI_Errhandler_create(function, errhandler);

    esd_exit(epk_mpi_regid[EPK__MPI_ERRHANDLER_CREATE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Errhandler_create(function, errhandler);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ERRHANDLER_FREE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Errhandler_free
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup err
 */
int MPI_Errhandler_free(MPI_Errhandler* errhandler)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ERRHANDLER_FREE]);

    return_val = PMPI_Errhandler_free(errhandler);

    esd_exit(epk_mpi_regid[EPK__MPI_ERRHANDLER_FREE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Errhandler_free(errhandler);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ERRHANDLER_GET) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Errhandler_get
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup err
 */
int MPI_Errhandler_get(MPI_Comm        comm,
                       MPI_Errhandler* errhandler)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ERRHANDLER_GET]);

    return_val = PMPI_Errhandler_get(comm, errhandler);

    esd_exit(epk_mpi_regid[EPK__MPI_ERRHANDLER_GET]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Errhandler_get(comm, errhandler);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ERRHANDLER_SET) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Errhandler_set
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup err
 */
int MPI_Errhandler_set(MPI_Comm       comm,
                       MPI_Errhandler errhandler)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ERRHANDLER_SET]);

    return_val = PMPI_Errhandler_set(comm, errhandler);

    esd_exit(epk_mpi_regid[EPK__MPI_ERRHANDLER_SET]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Errhandler_set(comm, errhandler);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ERROR_CLASS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Error_class
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup err
 */
int MPI_Error_class(int  errorcode,
                    int* errorclass)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ERROR_CLASS]);

    return_val = PMPI_Error_class(errorcode, errorclass);

    esd_exit(epk_mpi_regid[EPK__MPI_ERROR_CLASS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Error_class(errorcode, errorclass);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ERROR_STRING) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_ERR)
/**
 * Measurement wrapper for MPI_Error_string
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup err
 */
int MPI_Error_string(int   errorcode,
                     char* string,
                     int*  resultlen)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(ERR))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ERROR_STRING]);

    return_val = PMPI_Error_string(errorcode, string, resultlen);

    esd_exit(epk_mpi_regid[EPK__MPI_ERROR_STRING]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Error_string(errorcode, string, resultlen);
  }

  return return_val;
}

#endif

/**
 * @}
 */
