/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2010-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  Copyright (c) 2003-2008                                                **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/**
 * @file  epk_mpiwrap_misc.c
 *
 * @brief C interface wrappers for miscelaneous and handler conversion
 *        functions
 */

#include <mpi.h>

#include "esd_event.h"

#include "epk_defs_mpi.h"
#include "epk_mpiwrap.h"

/**
 * @name C wrappers
 * @{
 */

#if defined(HAS_MPI_ADDRESS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Address
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup misc
 */
int MPI_Address(void*     location,
                MPI_Aint* address)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ADDRESS]);

    return_val = PMPI_Address(location, address);

    esd_exit(epk_mpi_regid[EPK__MPI_ADDRESS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Address(location, address);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_ALLOC_MEM) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Alloc_mem
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Alloc_mem(MPI_Aint size,
                  MPI_Info info,
                  void*    baseptr)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_ALLOC_MEM]);

    return_val = PMPI_Alloc_mem(size, info, baseptr);

    esd_exit(epk_mpi_regid[EPK__MPI_ALLOC_MEM]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Alloc_mem(size, info, baseptr);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_FREE_MEM) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Free_mem
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Free_mem(void* base)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_FREE_MEM]);

    return_val = PMPI_Free_mem(base);

    esd_exit(epk_mpi_regid[EPK__MPI_FREE_MEM]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Free_mem(base);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_GET_ADDRESS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Get_address
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Get_address(void*     location,
                    MPI_Aint* address)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_GET_ADDRESS]);

    return_val = PMPI_Get_address(location, address);

    esd_exit(epk_mpi_regid[EPK__MPI_GET_ADDRESS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Get_address(location, address);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_GET_VERSION) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Get_version
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.2
 * @ingroup misc
 */
int MPI_Get_version(int* version,
                    int* subversion)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_GET_VERSION]);

    return_val = PMPI_Get_version(version, subversion);

    esd_exit(epk_mpi_regid[EPK__MPI_GET_VERSION]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Get_version(version, subversion);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_C2F) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_c2f
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
MPI_Fint MPI_Info_c2f(MPI_Info info)
{
  MPI_Fint return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_C2F]);

    return_val = PMPI_Info_c2f(info);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_C2F]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_c2f(info);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_CREATE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_create
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_create(MPI_Info* info)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_CREATE]);

    return_val = PMPI_Info_create(info);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_CREATE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_create(info);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_DELETE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_delete
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_delete(MPI_Info info,
                    char*    key)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_DELETE]);

    return_val = PMPI_Info_delete(info, key);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_DELETE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_delete(info, key);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_DUP) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_dup
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_dup(MPI_Info  info,
                 MPI_Info* newinfo)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_DUP]);

    return_val = PMPI_Info_dup(info, newinfo);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_DUP]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_dup(info, newinfo);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_F2C) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_f2c
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
MPI_Info MPI_Info_f2c(MPI_Fint info)
{
  MPI_Info return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_F2C]);

    return_val = PMPI_Info_f2c(info);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_F2C]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_f2c(info);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_FREE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_free
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_free(MPI_Info* info)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_FREE]);

    return_val = PMPI_Info_free(info);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_FREE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_free(info);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_GET) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_get
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_get(MPI_Info info,
                 char*    key,
                 int      valuelen,
                 char*    value,
                 int*     flag)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_GET]);

    return_val = PMPI_Info_get(info, key, valuelen, value, flag);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_GET]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_get(info, key, valuelen, value, flag);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_GET_NKEYS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_get_nkeys
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_get_nkeys(MPI_Info info,
                       int*     nkeys)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_GET_NKEYS]);

    return_val = PMPI_Info_get_nkeys(info, nkeys);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_GET_NKEYS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_get_nkeys(info, nkeys);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_GET_NTHKEY) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_get_nthkey
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_get_nthkey(MPI_Info info,
                        int      n,
                        char*    key)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_GET_NTHKEY]);

    return_val = PMPI_Info_get_nthkey(info, n, key);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_GET_NTHKEY]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_get_nthkey(info, n, key);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_GET_VALUELEN) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_get_valuelen
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_get_valuelen(MPI_Info info,
                          char*    key,
                          int*     valuelen,
                          int*     flag)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_GET_VALUELEN]);

    return_val = PMPI_Info_get_valuelen(info, key, valuelen, flag);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_GET_VALUELEN]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_get_valuelen(info, key, valuelen, flag);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_INFO_SET) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Info_set
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Info_set(MPI_Info info,
                 char*    key,
                 char*    value)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_INFO_SET]);

    return_val = PMPI_Info_set(info, key, value);

    esd_exit(epk_mpi_regid[EPK__MPI_INFO_SET]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Info_set(info, key, value);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_OP_C2F) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Op_c2f
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
MPI_Fint MPI_Op_c2f(MPI_Op op)
{
  MPI_Fint return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_OP_C2F]);

    return_val = PMPI_Op_c2f(op);

    esd_exit(epk_mpi_regid[EPK__MPI_OP_C2F]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Op_c2f(op);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_OP_COMMUTATIVE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Op_commutative
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.2
 * @ingroup misc
 */
int MPI_Op_commutative(MPI_Op op,
                       int*   commute)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_OP_COMMUTATIVE]);

    return_val = PMPI_Op_commutative(op, commute);

    esd_exit(epk_mpi_regid[EPK__MPI_OP_COMMUTATIVE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Op_commutative(op, commute);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_OP_CREATE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Op_create
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup misc
 */
int MPI_Op_create(MPI_User_function* function,
                  int                commute,
                  MPI_Op*            op)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_OP_CREATE]);

    return_val = PMPI_Op_create(function, commute, op);

    esd_exit(epk_mpi_regid[EPK__MPI_OP_CREATE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Op_create(function, commute, op);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_OP_F2C) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Op_f2c
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
MPI_Op MPI_Op_f2c(MPI_Fint op)
{
  MPI_Op return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_OP_F2C]);

    return_val = PMPI_Op_f2c(op);

    esd_exit(epk_mpi_regid[EPK__MPI_OP_F2C]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Op_f2c(op);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_OP_FREE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Op_free
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup misc
 */
int MPI_Op_free(MPI_Op* op)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_OP_FREE]);

    return_val = PMPI_Op_free(op);

    esd_exit(epk_mpi_regid[EPK__MPI_OP_FREE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Op_free(op);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_REQUEST_C2F) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Request_c2f
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
MPI_Fint MPI_Request_c2f(MPI_Request request)
{
  MPI_Fint return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_REQUEST_C2F]);

    return_val = PMPI_Request_c2f(request);

    esd_exit(epk_mpi_regid[EPK__MPI_REQUEST_C2F]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Request_c2f(request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_REQUEST_F2C) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Request_f2c
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
MPI_Request MPI_Request_f2c(MPI_Fint request)
{
  MPI_Request return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_REQUEST_F2C]);

    return_val = PMPI_Request_f2c(request);

    esd_exit(epk_mpi_regid[EPK__MPI_REQUEST_F2C]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Request_f2c(request);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_REQUEST_GET_STATUS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Request_get_status
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Request_get_status(MPI_Request request,
                           int*        flag,
                           MPI_Status* status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_REQUEST_GET_STATUS]);

    return_val = PMPI_Request_get_status(request, flag, status);

    esd_exit(epk_mpi_regid[EPK__MPI_REQUEST_GET_STATUS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Request_get_status(request, flag, status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_STATUS_C2F) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Status_c2f
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Status_c2f(MPI_Status* c_status,
                   MPI_Fint*   f_status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_STATUS_C2F]);

    return_val = PMPI_Status_c2f(c_status, f_status);

    esd_exit(epk_mpi_regid[EPK__MPI_STATUS_C2F]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Status_c2f(c_status, f_status);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_STATUS_F2C) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Status_f2c
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup misc
 */
int MPI_Status_f2c(MPI_Fint*   f_status,
                   MPI_Status* c_status)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_STATUS_F2C]);

    return_val = PMPI_Status_f2c(f_status, c_status);

    esd_exit(epk_mpi_regid[EPK__MPI_STATUS_F2C]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Status_f2c(f_status, c_status);
  }

  return return_val;
}

#endif

/**
 * @}
 */
