/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2010-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  Copyright (c) 2003-2008                                                **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

/**
 * @file  epk_mpiwrap_type.c
 *
 * @brief C interface wrappers for datatype functions
 */

#include <mpi.h>

#include "esd_event.h"

#include "epk_defs_mpi.h"
#include "epk_mpiwrap.h"

/**
 * @name C wrappers for general functions
 * @{
 */

#if defined(HAS_MPI_PACK) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Pack
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Pack(void*        inbuf,
             int          incount,
             MPI_Datatype datatype,
             void*        outbuf,
             int          outsize,
             int*         position,
             MPI_Comm     comm)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_PACK]);

    return_val = PMPI_Pack(inbuf,
                           incount,
                           datatype,
                           outbuf,
                           outsize,
                           position,
                           comm);

    esd_exit(epk_mpi_regid[EPK__MPI_PACK]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Pack(inbuf,
                           incount,
                           datatype,
                           outbuf,
                           outsize,
                           position,
                           comm);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_PACK_EXTERNAL) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Pack_external
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Pack_external(char*        datarep,
                      void*        inbuf,
                      int          incount,
                      MPI_Datatype datatype,
                      void*        outbuf,
                      MPI_Aint     outsize,
                      MPI_Aint*    position)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_PACK_EXTERNAL]);

    return_val = PMPI_Pack_external(datarep,
                                    inbuf,
                                    incount,
                                    datatype,
                                    outbuf,
                                    outsize,
                                    position);

    esd_exit(epk_mpi_regid[EPK__MPI_PACK_EXTERNAL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Pack_external(datarep,
                                    inbuf,
                                    incount,
                                    datatype,
                                    outbuf,
                                    outsize,
                                    position);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_PACK_EXTERNAL_SIZE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Pack_external_size
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Pack_external_size(char*        datarep,
                           int          incount,
                           MPI_Datatype datatype,
                           MPI_Aint*    size)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_PACK_EXTERNAL_SIZE]);

    return_val = PMPI_Pack_external_size(datarep, incount, datatype, size);

    esd_exit(epk_mpi_regid[EPK__MPI_PACK_EXTERNAL_SIZE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Pack_external_size(datarep, incount, datatype, size);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_PACK_SIZE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Pack_size
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Pack_size(int          incount,
                  MPI_Datatype datatype,
                  MPI_Comm     comm,
                  int*         size)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_PACK_SIZE]);

    return_val = PMPI_Pack_size(incount, datatype, comm, size);

    esd_exit(epk_mpi_regid[EPK__MPI_PACK_SIZE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Pack_size(incount, datatype, comm, size);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_COMMIT) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_commit
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_commit(MPI_Datatype* datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_COMMIT]);

    return_val = PMPI_Type_commit(datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_COMMIT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_commit(datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CONTIGUOUS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_contiguous
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_contiguous(int           count,
                        MPI_Datatype  oldtype,
                        MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CONTIGUOUS]);

    return_val = PMPI_Type_contiguous(count, oldtype, newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CONTIGUOUS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_contiguous(count, oldtype, newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_DARRAY) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_darray
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_darray(int           size,
                           int           rank,
                           int           ndims,
                           int           array_of_gsizes[],
                           int           array_of_distribs[],
                           int           array_of_dargs[],
                           int           array_of_psizes[],
                           int           order,
                           MPI_Datatype  oldtype,
                           MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_DARRAY]);

    return_val = PMPI_Type_create_darray(size,
                                         rank,
                                         ndims,
                                         array_of_gsizes,
                                         array_of_distribs,
                                         array_of_dargs,
                                         array_of_psizes,
                                         order,
                                         oldtype,
                                         newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_DARRAY]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_darray(size,
                                         rank,
                                         ndims,
                                         array_of_gsizes,
                                         array_of_distribs,
                                         array_of_dargs,
                                         array_of_psizes,
                                         order,
                                         oldtype,
                                         newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_F90_COMPLEX) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_f90_complex
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_f90_complex(int           p,
                                int           r,
                                MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_F90_COMPLEX]);

    return_val = PMPI_Type_create_f90_complex(p, r, newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_F90_COMPLEX]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_f90_complex(p, r, newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_F90_INTEGER) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_f90_integer
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_f90_integer(int           r,
                                MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_F90_INTEGER]);

    return_val = PMPI_Type_create_f90_integer(r, newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_F90_INTEGER]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_f90_integer(r, newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_F90_REAL) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_f90_real
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_f90_real(int           p,
                             int           r,
                             MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_F90_REAL]);

    return_val = PMPI_Type_create_f90_real(p, r, newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_F90_REAL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_f90_real(p, r, newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_HINDEXED) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_hindexed
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_hindexed(int           count,
                             int           array_of_blocklengths[],
                             MPI_Aint      array_of_displacements[],
                             MPI_Datatype  oldtype,
                             MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_HINDEXED]);

    return_val = PMPI_Type_create_hindexed(count,
                                           array_of_blocklengths,
                                           array_of_displacements,
                                           oldtype,
                                           newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_HINDEXED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_hindexed(count,
                                           array_of_blocklengths,
                                           array_of_displacements,
                                           oldtype,
                                           newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_HVECTOR) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_hvector
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_hvector(int           count,
                            int           blocklength,
                            MPI_Aint      stride,
                            MPI_Datatype  oldtype,
                            MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_HVECTOR]);

    return_val = PMPI_Type_create_hvector(count,
                                          blocklength,
                                          stride,
                                          oldtype,
                                          newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_HVECTOR]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_hvector(count,
                                          blocklength,
                                          stride,
                                          oldtype,
                                          newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_INDEXED_BLOCK) \
  && !defined(NO_MPI_EXTRA) && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_indexed_block
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_indexed_block(int           count,
                                  int           blocklength,
                                  int           array_of_displacements[],
                                  MPI_Datatype  oldtype,
                                  MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_INDEXED_BLOCK]);

    return_val = PMPI_Type_create_indexed_block(count,
                                                blocklength,
                                                array_of_displacements,
                                                oldtype,
                                                newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_INDEXED_BLOCK]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_indexed_block(count,
                                                blocklength,
                                                array_of_displacements,
                                                oldtype,
                                                newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_RESIZED) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_resized
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_resized(MPI_Datatype  oldtype,
                            MPI_Aint      lb,
                            MPI_Aint      extent,
                            MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_RESIZED]);

    return_val = PMPI_Type_create_resized(oldtype, lb, extent, newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_RESIZED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_resized(oldtype, lb, extent, newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_STRUCT) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_struct
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_struct(int           count,
                           int           array_of_blocklengths[],
                           MPI_Aint      array_of_displacements[],
                           MPI_Datatype  array_of_types[],
                           MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_STRUCT]);

    return_val = PMPI_Type_create_struct(count,
                                         array_of_blocklengths,
                                         array_of_displacements,
                                         array_of_types,
                                         newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_STRUCT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_struct(count,
                                         array_of_blocklengths,
                                         array_of_displacements,
                                         array_of_types,
                                         newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_CREATE_SUBARRAY) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_create_subarray
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_create_subarray(int           ndims,
                             int           array_of_sizes[],
                             int           array_of_subsizes[],
                             int           array_of_starts[],
                             int           order,
                             MPI_Datatype  oldtype,
                             MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_SUBARRAY]);

    return_val = PMPI_Type_create_subarray(ndims,
                                           array_of_sizes,
                                           array_of_subsizes,
                                           array_of_starts,
                                           order,
                                           oldtype,
                                           newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_SUBARRAY]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_subarray(ndims,
                                           array_of_sizes,
                                           array_of_subsizes,
                                           array_of_starts,
                                           order,
                                           oldtype,
                                           newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_DUP) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_dup
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_dup(MPI_Datatype  type,
                 MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_DUP]);

    return_val = PMPI_Type_dup(type, newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_DUP]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_dup(type, newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_EXTENT) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_extent
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_extent(MPI_Datatype datatype,
                    MPI_Aint*    extent)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_EXTENT]);

    return_val = PMPI_Type_extent(datatype, extent);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_EXTENT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_extent(datatype, extent);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_FREE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_free
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_free(MPI_Datatype* datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_FREE]);

    return_val = PMPI_Type_free(datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_FREE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_free(datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_GET_CONTENTS) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_get_contents
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_get_contents(MPI_Datatype datatype,
                          int          max_integers,
                          int          max_addresses,
                          int          max_datatypes,
                          int          array_of_integers[],
                          MPI_Aint     array_of_addresses[],
                          MPI_Datatype array_of_datatypes[])
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_GET_CONTENTS]);

    return_val = PMPI_Type_get_contents(datatype,
                                        max_integers,
                                        max_addresses,
                                        max_datatypes,
                                        array_of_integers,
                                        array_of_addresses,
                                        array_of_datatypes);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_GET_CONTENTS]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_get_contents(datatype,
                                        max_integers,
                                        max_addresses,
                                        max_datatypes,
                                        array_of_integers,
                                        array_of_addresses,
                                        array_of_datatypes);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_GET_ENVELOPE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_get_envelope
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_get_envelope(MPI_Datatype datatype,
                          int*         num_integers,
                          int*         num_addresses,
                          int*         num_datatypes,
                          int*         combiner)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_GET_ENVELOPE]);

    return_val = PMPI_Type_get_envelope(datatype,
                                        num_integers,
                                        num_addresses,
                                        num_datatypes,
                                        combiner);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_GET_ENVELOPE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_get_envelope(datatype,
                                        num_integers,
                                        num_addresses,
                                        num_datatypes,
                                        combiner);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_GET_EXTENT) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_get_extent
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_get_extent(MPI_Datatype datatype,
                        MPI_Aint*    lb,
                        MPI_Aint*    extent)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_GET_EXTENT]);

    return_val = PMPI_Type_get_extent(datatype, lb, extent);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_GET_EXTENT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_get_extent(datatype, lb, extent);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_GET_TRUE_EXTENT) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_get_true_extent
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_get_true_extent(MPI_Datatype datatype,
                             MPI_Aint*    true_lb,
                             MPI_Aint*    true_extent)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_GET_TRUE_EXTENT]);

    return_val = PMPI_Type_get_true_extent(datatype, true_lb, true_extent);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_GET_TRUE_EXTENT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_get_true_extent(datatype, true_lb, true_extent);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_HINDEXED) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_hindexed
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_hindexed(int           count,
                      int*          array_of_blocklengths,
                      MPI_Aint*     array_of_displacements,
                      MPI_Datatype  oldtype,
                      MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_HINDEXED]);

    return_val = PMPI_Type_hindexed(count,
                                    array_of_blocklengths,
                                    array_of_displacements,
                                    oldtype,
                                    newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_HINDEXED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_hindexed(count,
                                    array_of_blocklengths,
                                    array_of_displacements,
                                    oldtype,
                                    newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_HVECTOR) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_hvector
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_hvector(int           count,
                     int           blocklength,
                     MPI_Aint      stride,
                     MPI_Datatype  oldtype,
                     MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_HVECTOR]);

    return_val = PMPI_Type_hvector(count,
                                   blocklength,
                                   stride,
                                   oldtype,
                                   newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_HVECTOR]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_hvector(count,
                                   blocklength,
                                   stride,
                                   oldtype,
                                   newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_INDEXED) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_indexed
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_indexed(int           count,
                     int*          array_of_blocklengths,
                     int*          array_of_displacements,
                     MPI_Datatype  oldtype,
                     MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_INDEXED]);

    return_val = PMPI_Type_indexed(count,
                                   array_of_blocklengths,
                                   array_of_displacements,
                                   oldtype,
                                   newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_INDEXED]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_indexed(count,
                                   array_of_blocklengths,
                                   array_of_displacements,
                                   oldtype,
                                   newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_LB) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_lb
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_lb(MPI_Datatype datatype,
                MPI_Aint*    displacement)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_LB]);

    return_val = PMPI_Type_lb(datatype, displacement);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_LB]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_lb(datatype, displacement);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_MATCH_SIZE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_match_size
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Type_match_size(int           typeclass,
                        int           size,
                        MPI_Datatype* type)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_MATCH_SIZE]);

    return_val = PMPI_Type_match_size(typeclass, size, type);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_MATCH_SIZE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_match_size(typeclass, size, type);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_SIZE) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_size
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_size(MPI_Datatype datatype,
                  int*         size)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_SIZE]);

    return_val = PMPI_Type_size(datatype, size);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_SIZE]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_size(datatype, size);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_STRUCT) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_struct
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_struct(int           count,
                    int*          array_of_blocklengths,
                    MPI_Aint*     array_of_displacements,
                    MPI_Datatype* array_of_types,
                    MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_STRUCT]);

    return_val = PMPI_Type_struct(count,
                                  array_of_blocklengths,
                                  array_of_displacements,
                                  array_of_types,
                                  newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_STRUCT]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_struct(count,
                                  array_of_blocklengths,
                                  array_of_displacements,
                                  array_of_types,
                                  newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_UB) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_ub
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_ub(MPI_Datatype datatype,
                MPI_Aint*    displacement)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_UB]);

    return_val = PMPI_Type_ub(datatype, displacement);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_UB]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_ub(datatype, displacement);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_VECTOR) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Type_vector
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Type_vector(int           count,
                    int           blocklength,
                    int           stride,
                    MPI_Datatype  oldtype,
                    MPI_Datatype* newtype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_VECTOR]);

    return_val = PMPI_Type_vector(count,
                                  blocklength,
                                  stride,
                                  oldtype,
                                  newtype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_VECTOR]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_vector(count,
                                  blocklength,
                                  stride,
                                  oldtype,
                                  newtype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_UNPACK) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Unpack
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 1.0
 * @ingroup type
 */
int MPI_Unpack(void*        inbuf,
               int          insize,
               int*         position,
               void*        outbuf,
               int          outcount,
               MPI_Datatype datatype,
               MPI_Comm     comm)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_UNPACK]);

    return_val = PMPI_Unpack(inbuf,
                             insize,
                             position,
                             outbuf,
                             outcount,
                             datatype,
                             comm);

    esd_exit(epk_mpi_regid[EPK__MPI_UNPACK]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Unpack(inbuf,
                             insize,
                             position,
                             outbuf,
                             outcount,
                             datatype,
                             comm);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_UNPACK_EXTERNAL) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE)
/**
 * Measurement wrapper for MPI_Unpack_external
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type
 */
int MPI_Unpack_external(char*        datarep,
                        void*        inbuf,
                        MPI_Aint     insize,
                        MPI_Aint*    position,
                        void*        outbuf,
                        int          outcount,
                        MPI_Datatype datatype)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_UNPACK_EXTERNAL]);

    return_val = PMPI_Unpack_external(datarep,
                                      inbuf,
                                      insize,
                                      position,
                                      outbuf,
                                      outcount,
                                      datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_UNPACK_EXTERNAL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Unpack_external(datarep,
                                      inbuf,
                                      insize,
                                      position,
                                      outbuf,
                                      outcount,
                                      datatype);
  }

  return return_val;
}

#endif

/**
 * @}
 * @name C wrappers for external interface functions
 * @{
 */

#if defined(HAS_MPI_TYPE_CREATE_KEYVAL) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Type_create_keyval
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_ext
 */
int MPI_Type_create_keyval(
  MPI_Type_copy_attr_function* type_copy_attr_fn,
  MPI_Type_delete_attr_function*
  type_delete_attr_fn,
  int*                         type_keyval,
  void*                        extra_state)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_EXT))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_CREATE_KEYVAL]);

    return_val = PMPI_Type_create_keyval(type_copy_attr_fn,
                                         type_delete_attr_fn,
                                         type_keyval,
                                         extra_state);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_CREATE_KEYVAL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_create_keyval(type_copy_attr_fn,
                                         type_delete_attr_fn,
                                         type_keyval,
                                         extra_state);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_DELETE_ATTR) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Type_delete_attr
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_ext
 */
int MPI_Type_delete_attr(MPI_Datatype type,
                         int          type_keyval)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_EXT))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_DELETE_ATTR]);

    return_val = PMPI_Type_delete_attr(type, type_keyval);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_DELETE_ATTR]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_delete_attr(type, type_keyval);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_FREE_KEYVAL) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Type_free_keyval
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_ext
 */
int MPI_Type_free_keyval(int* type_keyval)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_EXT))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_FREE_KEYVAL]);

    return_val = PMPI_Type_free_keyval(type_keyval);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_FREE_KEYVAL]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_free_keyval(type_keyval);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_GET_ATTR) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Type_get_attr
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_ext
 */
int MPI_Type_get_attr(MPI_Datatype type,
                      int          type_keyval,
                      void*        attribute_val,
                      int*         flag)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_EXT))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_GET_ATTR]);

    return_val = PMPI_Type_get_attr(type, type_keyval, attribute_val, flag);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_GET_ATTR]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_get_attr(type, type_keyval, attribute_val, flag);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_GET_NAME) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Type_get_name
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_ext
 */
int MPI_Type_get_name(MPI_Datatype type,
                      char*        type_name,
                      int*         resultlen)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_EXT))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_GET_NAME]);

    return_val = PMPI_Type_get_name(type, type_name, resultlen);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_GET_NAME]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_get_name(type, type_name, resultlen);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_SET_ATTR) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Type_set_attr
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_ext
 */
int MPI_Type_set_attr(MPI_Datatype type,
                      int          type_keyval,
                      void*        attribute_val)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_EXT))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_SET_ATTR]);

    return_val = PMPI_Type_set_attr(type, type_keyval, attribute_val);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_SET_ATTR]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_set_attr(type, type_keyval, attribute_val);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_SET_NAME) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_EXT)
/**
 * Measurement wrapper for MPI_Type_set_name
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_ext
 */
int MPI_Type_set_name(MPI_Datatype type,
                      char*        type_name)
{
  int return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_EXT))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_SET_NAME]);

    return_val = PMPI_Type_set_name(type, type_name);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_SET_NAME]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_set_name(type, type_name);
  }

  return return_val;
}

#endif

/**
 * @}
 * @name C wrappers for handle conversion functions
 * @{
 */

#if defined(HAS_MPI_TYPE_C2F) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Type_c2f
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_misc
 */
MPI_Fint MPI_Type_c2f(MPI_Datatype datatype)
{
  MPI_Fint return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_C2F]);

    return_val = PMPI_Type_c2f(datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_C2F]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_c2f(datatype);
  }

  return return_val;
}

#endif
#if defined(HAS_MPI_TYPE_F2C) && !defined(NO_MPI_EXTRA) \
  && !defined(NO_MPI_TYPE) && !defined(NO_MPI_MISC)
/**
 * Measurement wrapper for MPI_Type_f2c
 * @note Auto-generated by wrapgen from template: std.w
 * @note C interface
 * @note Introduced with MPI 2.0
 * @ingroup type_misc
 */
MPI_Datatype MPI_Type_f2c(MPI_Fint datatype)
{
  MPI_Datatype return_val;

  if (IS_EVENT_GEN_ON_FOR(TYPE_MISC))
  {
    EVENT_GEN_OFF();
    esd_enter(epk_mpi_regid[EPK__MPI_TYPE_F2C]);

    return_val = PMPI_Type_f2c(datatype);

    esd_exit(epk_mpi_regid[EPK__MPI_TYPE_F2C]);
    EVENT_GEN_ON();
  }
  else
  {
    return_val = PMPI_Type_f2c(datatype);
  }

  return return_val;
}

#endif

/**
 * @}
 */
