/*
 *                            COPYRIGHT
 *
 *  cschem - modular/flexible schematics editor - ngspice to high level sim glue
 *  Copyright (C) 2023 Tibor 'Igor2' Palinkas
 *
 *  (Supported by NLnet NGI0 Entrust in 2023)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/sch-rnd
 *    contact lead developer: http://www.repo.hu/projects/sch-rnd/contact.html
 *    mailing list: http://www.repo.hu/projects/sch-rnd/contact.html
 */

#include <stdio.h>
#include <stdlib.h>
#include <libfungw/fungw.h>
#include <libcschem/config.h>
#include <libcschem/abstract.h>
#include <libcschem/engine.h>
#include <libcschem/actions_csch.h>
#include <libcschem/attrib.h>
#include <libcschem/libcschem.h>
#include <libcschem/util_compile.h>
#include <librnd/core/actions.h>
#include <librnd/core/compat_misc.h>
#include <librnd/core/rnd_printf.h>
#include <librnd/core/plugins.h>
#include <librnd/core/misc_util.h>

#if 0
typedef struct {
} sim_ngspice_ctx_t; /* per view data */
#endif

static const char sim_ngspice_cookie[] = "sim_ngspice";
static gds_t stmp = {0};


/*** hooks ***/

static int on_load(fgw_obj_t *obj, const char *filename, const char *opts)
{
/*	fgw_func_reg(obj, "compile_component1", sim_ngspice_compile_comp1);*/

	/* initialize view-local cache */
	obj->script_data = /*calloc(sizeof(sim_ngspice_ctx_t), 1)*/ NULL;

	return 0;
}

static int on_unload(fgw_obj_t *obj)
{
/*	sim_ngspice_ctx_t *ctx = obj->script_data;
	free(ctx);*/
	return 0;
}


static const fgw_eng_t fgw_sim_ngspice_eng = {
	"sim_ngspice",
	csch_c_call_script,
	NULL,
	on_load,
	on_unload
};

int pplg_check_ver_sim_ngspice(int ver_needed) { return 0; }

void pplg_uninit_sim_ngspice(void)
{
	gds_uninit(&stmp);
}

int pplg_init_sim_ngspice(void)
{
	RND_API_CHK_VER;
	fgw_eng_reg(&fgw_sim_ngspice_eng);

	return 0;
}

