#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2005 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
SchoolBell libraries

- schoolbell.relationships is a library for expressing many-to-many
  relationships in Zope 3
- schoolbell.calendar is a calendaring library for Zope 3
- schoolbell.app is a calendaring server and web application for Zope 3
"""

VERSION = "1.2.4"

from zope.i18n import MessageFactory
SchoolBellMessage = MessageFactory("schoolbell")

# XXX - unquote_uri copied and pasted from schooltool.common when porting
# patches from the trunk to prevent a schooltool dependency on schoolbell.
# A schoolbell.common module was not added as this would break the build.
import urllib
def unquote_uri(uri):
    r"""Unquote a URI.

       >>> unquote_uri('/terms/%C5%BEiema')
       u'/terms/\u017eiema'

       >>> unquote_uri(u'/terms/%C5%BEiema')
       u'/terms/\u017eiema'

    """
    return urllib.unquote(str(uri)).decode('UTF-8')

