#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2005 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from zope.catalog.interfaces import ICatalog
from zope.component import getUtility
from zope.security.proxy import removeSecurityProxy

from zc.catalog.catalogindex import ValueIndex
from zc.catalog.extentcatalog import Catalog
from zc.catalog.extentcatalog import FilterExtent

from schooltool.table.catalog import ConvertingIndex
from schooltool.table.catalog import FilterImplementing
from schooltool.utility.utility import UtilitySetUp

import interfaces


INTERVENTION_CATALOG_KEY = 'schooltool.intervention'


def catalogFactory():
    return Catalog(FilterExtent(FilterImplementing(
        interfaces.IInterventionMarker)))


def catalogSetUp(catalog):
    catalog['first_name'] = ConvertingIndex(converter=getStudentFirstName)
    catalog['last_name'] = ConvertingIndex(converter=getStudentLastName)
    catalog['persons_responsible'] = ConvertingIndex(
        converter=interfaces.IInterventionPersonsResponsible)
    catalog['created'] = ValueIndex('created')
    catalog['schoolYearId'] = ConvertingIndex(converter=getSchoolYearId)
    catalog['intervention_type'] = ConvertingIndex(
        converter=interfaces.IInterventionType)


catalogSetUpSubscriber = UtilitySetUp(
    catalogFactory, ICatalog, INTERVENTION_CATALOG_KEY, setUp=catalogSetUp)


def getInterventionCatalog(container):
    return getUtility(ICatalog, INTERVENTION_CATALOG_KEY)


def getStudentFirstName(obj):
    return obj.student.first_name


def getStudentLastName(obj):
    return obj.student.last_name


def getMessagePersonsResponsible(obj):
    return obj.recipients


def getGoalPersonsResponsible(obj):
    # XXX not using removeSecurityProxy caused ZODB to crash
    # Cannot pickle <type 'zope.security._proxy._Proxy'> objects
    return removeSecurityProxy(obj.persons_responsible)


def getMessageType(obj):
    return 'message'


def getGoalType(obj):
    return 'goal'


def getSchoolYearId(obj):
    sy = interfaces.IInterventionSchoolYear(obj)
    return sy.__name__


def messageGetter(obj):
    value = obj.body
    if len(value) > 50:
        value = value[:47] + '...'
    return value


def goalGetter(obj):
    value = obj.presenting_concerns
    if len(value) > 50:
        value = value[:47] + '...'
    return value

