# coding=UTF8
#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2009 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Unit tests for schooltool.intervention.generations.evolve3
"""

import unittest
import doctest

from zope.app.testing import setup
from zope.component.hooks import setSite
from zope.interface import implements
from zope.site.folder import Folder

from schooltool.app.interfaces import ISchoolToolApplication
from schooltool.generations.tests import ContextStub
from schooltool.intervention.generations.evolve3 import evolve


class AppStub(Folder):
    implements(ISchoolToolApplication)


def doctest_evolve3():
    """Evolution to generation 3.

    First, we'll set up the app object:

        >>> context = ContextStub()
        >>> context.root_folder['app'] = app = AppStub()
        >>> manager = setup.createSiteManager(app)

    We'll set up our test with data that will be effected by running the
    evolve script:

        >>> persons = app[u'persons'] = {'student1': ''}
        >>> root = app[u'schooltool.interventions'] = {}
        >>> year = root['2009'] = {}
        >>> student1 = year['student1'] = {}
        >>> student2 = year['student2'] = {}

    Finally, we'll run the evolve script, testing the effected values before and
    after:

        >>> sorted(year.keys())
        ['student1', 'student2']

        >>> evolve(context)

        >>> sorted(year.keys())
        ['student1']

    What if the intervention container doesn't exist yet in the
    application:

        >>> context = ContextStub()
        >>> context.root_folder['app'] = app = AppStub()
        >>> manager = setup.createSiteManager(app)
        >>> evolve(context)

    """


def setUp(test):
    setup.placefulSetUp()
    setSite()

def tearDown(test):
    setup.placefulTearDown()
    setSite()


def test_suite():
    return unittest.TestSuite([
        doctest.DocTestSuite(setUp=setUp, tearDown=tearDown,
                             optionflags=doctest.ELLIPSIS
                             | doctest.NORMALIZE_WHITESPACE
                             | doctest.REPORT_NDIFF
                             | doctest.REPORT_ONLY_FIRST_FAILURE),
        ])

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')

