/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_edit_dialog.h"
#include "sg_dataset.h"

static GtkWidget *exp_entry;
static SGdataset *the_dataset;

SGdataset * 
sg_edit_function_update()
{
  gchar *text;

  text = gtk_entry_get_text(GTK_ENTRY(exp_entry));
  if(!text || strlen(text) == 0){
    return NULL;
  }
 
  if(the_dataset){
     sg_dataset_set_exp(the_dataset, text);
  } else {
     the_dataset = sg_dataset_new_function(text);

     the_dataset->real_data->line.line_style = GTK_PLOT_LINE_SOLID;
     the_dataset->real_data->symbol.symbol_type = GTK_PLOT_SYMBOL_NONE;
  }

  return the_dataset;
}


GtkWidget *
sg_edit_function_dialog (SGdataset *dataset)
{
  GtkWidget *frame;
  GtkWidget *main_box;
  GtkWidget *table;
  GtkWidget *label;
  gchar text[100];
  SGdataset *real_data;

  the_dataset = dataset;
  real_data = SG_DATASET(gtk_plot_data_get_link(the_dataset->real_data));

  /* Create widgets */
  main_box = gtk_vbox_new (FALSE,5);
  gtk_container_set_border_width(GTK_CONTAINER(main_box), 10);

  frame = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_box_pack_start (GTK_BOX (main_box), frame, FALSE, FALSE, 0);

  table = gtk_table_new(2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  gtk_container_add(GTK_CONTAINER(frame), table);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);

  if(real_data){
    sprintf(text, "%s = ",GTK_PLOT_DATA(real_data->real_data)->name);
  } else {
    sprintf(text, "");
  }

  label = gtk_label_new(text),
  gtk_misc_set_alignment(GTK_MISC(label), 0., .5);
  gtk_table_attach_defaults(GTK_TABLE(table), 
                            label,
                            0, 1, 1, 2);

  exp_entry = gtk_entry_new();   
  if(dataset && dataset->exp)
      gtk_entry_set_text(GTK_ENTRY(exp_entry), dataset->exp);
  gtk_table_attach_defaults(GTK_TABLE(table), exp_entry, 1, 4, 1, 2);

  return main_box;
}
