/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PROJECT_H__
#define __SG_PROJECT_H__

#include "sg_worksheet.h"
#include "sg_plot.h"
#include "sg_dataset.h"


extern gint num_worksheets;
extern gint num_plots;
extern gint num_functions;
extern gint num_expressions;
extern gint last_worksheet;
extern gint last_matrix;
extern gint last_plot;
extern gint last_dataset;
extern gint last_function;
extern gint last_expression;

extern gint arrange_rows;
extern gint arrange_cols;
extern gdouble arrange_vgap;
extern gdouble arrange_hgap;
extern gdouble arrange_top;
extern gdouble arrange_bottom;
extern gdouble arrange_left;
extern gdouble arrange_right;

extern GList *worksheets;
extern GList *plots;
extern GList *functions;
extern GList *datasets;
extern GList *expressions;


void	sg_project_new				(void);
void	sg_project_init				(void);
void	sg_project_set_title			(void);
void	sg_project_changed			(gboolean changed);
SGworksheet 	*sg_project_new_worksheet	(void);
SGworksheet 	*sg_project_new_matrix		(void);
SGplot 		*sg_project_new_plot		(void);
SGplot 		*sg_project_new_plot_with_layer	(SGlayerType type);
gboolean sg_project_remove_worksheet		(SGworksheet *worksheet);
gboolean sg_project_remove_plot			(SGplot *plot);
gboolean sg_project_remove_dataset		(SGdataset *dataset,
						 gboolean force);
gint 	sg_project_rename_worksheet		(SGworksheet *worksheet,
						 gchar *name);
gint 	sg_project_rename_plot			(SGplot *plot,
						 gchar *name);
SGdataset *sg_project_new_dataset		(SGdataStyle style);
SGdataset *sg_project_new_function		(gchar *exp);
SGdataset *sg_project_new_expression		(SGdataStyle style,
						 gchar *exp[9]);

void 	sg_project_close			(void);
void	sg_project_open_plot			(GtkWidget *widget,
                     				 GtkIconListItem *item,
						 GdkEvent *event,
                     				 gpointer data);
void	sg_project_open_worksheet		(GtkWidget *widget,
                     				 GtkIconListItem *item, 
						 GdkEvent *event,
                     				 gpointer data);
SGworksheet *sg_project_get_worksheet		(gchar *name);
SGplot 	*sg_project_get_plot			(gchar *name);
void 	sg_project_refresh_datasets		();
SGdataset *sg_project_dataset_get_by_id		(gint id);
SGdataset *sg_project_function_get_by_id	(gint id);
SGdataset *sg_project_expression_get_by_id	(gint id);

#endif /* __SG_PROJECT_H__ */
