/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_WORKSHEET_FILE_H__
#define __SG_WORKSHEET_FILE_H__

#include <gtkextra/gtkextra.h>
#include "sg_worksheet.h"

typedef struct _SGworksheetfile SGworksheetfile;

struct _SGworksheetfile
{
  gchar *filename;

  SGworksheet *worksheet;
  GtkSheetRange range;

  gchar *titlecolor;
  gchar *cellcolor;

  FILE *file;

  void (*write_header) (SGworksheetfile *file);
  void (*write_footer) (SGworksheetfile *file);

  void (*write_row_title) (SGworksheetfile *file, gint row); 
  void (*write_col_title) (SGworksheetfile *file, gint col); 

  void (*new_row) (SGworksheetfile *file, gint row);
  void (*new_column) (SGworksheetfile *file, gint col);
  void (*write_cell) (SGworksheetfile *file, gint row, gint col); 

};

SGworksheetfile* sg_worksheet_file_new		(SGworksheet *worksheet, 
						 gchar *filename);
void    	sg_worksheet_file_export	(SGworksheetfile *file, 
						 GtkSheetRange *range);
void    	sg_worksheet_file_destroy	(SGworksheetfile *file);

#endif /* __SG_WORKSHEET_FILE_H__ */
