/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_real_escape_string(char * fname)
{
  int * sql_pointer_in = NULL;
  int * de = NULL;
  MYSQL * mysql_ptr_in = NULL;
  char * cen = NULL, * cde = NULL;
  unsigned long res_long;
  void * ptr_in = NULL;
  SciErr _SciErr;

  CheckRhs(2,2);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &ptr_in);
  mysql_ptr_in = (MYSQL *)ptr_in;

  if (mysql_ptr_in==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &de);
  getAllocatedSingleString(pvApiCtx, de, &cde);

  cen = (char *)MALLOC((2*strlen(cde)+1)*sizeof(char));

  res_long = mysql_real_escape_string(mysql_ptr_in, cen, cde, strlen(cde));

  createSingleString(pvApiCtx, Rhs+1, cen);

  LhsVar(1) = Rhs + 1;

  FREE(cen);
  freeAllocatedSingleString(cde);

  return 0;
}
