/*
 * -------------------------------------------------------------------------
 * coiflet.c -- Coiflet wavelets coefficients.
 * SWT - Scilab wavelet toolbox
 * Copyright (C) 2005-2006  Roger Liu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * -------------------------------------------------------------------------
 */

#include "swt_common.h"
#include "dwt.h"

/*********************************************
 * Local Variable (Filter Coefficent)
 ********************************************/

static const double coif1[6] = { -0.051429728471,
				 0.238929728471,
				 0.602859456942,
				 0.272140543058,
				 -0.051429772847,
				 -0.011070271529
};

static const double coif2[12] = { 0.011587596739,
				 -0.029320137980,
				 -0.047639590310,
				 0.273021046535,
				 0.574682393857,
				 0.294867193696,
				 -0.054085607092,
				 -0.042026480461,
				 0.016744410163,
				 0.003967883613,
				 -0.001289203356,
				 -0.000509505399
};

static const double coif3[18] = { -0.002682418671,
				  0.005503126709,
				  0.016583560479,
				  -0.046507764479,
				  -0.043220763560,
				  0.286503335274,
				  0.561285256870,
				  0.302983571773,
				  -0.050770140755,
				  -0.058196250762,
				  0.024434094321,
				  0.011229240962,
				  -0.006369601011,
				  -0.001820458916,
				  0.000790205101,
				  0.000329665174,
				  -0.000050192775,
				  -0.000024465734
};

static const double coif4[24] = { 0.000630961046,
				  -0.001152224582,
				  -0.005194524026,
				  0.011362459244,
				  0.018867235378,
				  -0.057464234429,
				  -0.039652648517,
				  0.293667390895,
				  0.553126452562,
				  0.307157326198,
				  -0.047112738865,
				  -0.068038127051,
				  0.027813640513,
				  0.017735837438,
				  -0.010756318517,
				  -0.004001012886,
				  0.002652665946,
				  0.000895594529,
				  -0.000416500571,
				  -0.000183829769,
				  0.000044080354,
				  0.000022082857,
				  -0.000002304942,
				  -0.000001262175
};

static const double coif5[30] = { -0.0001499638,
				  0.0002535612,
				  0.0015402457,
				  -0.0029411108,
				  -0.0071637819,
				  0.0165520664,
				  0.0199178043,
				  -0.0649972628,
				  -0.0368000736,
				  0.2980923235,
				  0.5475054294,
				  0.3097068490,
				  -0.0438660508,
				  -0.0746522389,
				  0.0291958795,
				  0.0231107770,
				  -0.0139736879,
				  -0.0064800900,
				  0.0047830014,
				  0.0017206547,
				  -0.0011758222,
				  -0.0004512270,
				  0.0002137298,
				  0.0000993776,
				  -0.0000292321,
				  -0.0000150720,
				  0.0000026408,
				  0.0000014593,
				  -0.0000001184,
				  -0.0000000673
};

/*********************************************
 * Global Function
 ********************************************/

void
coiflets_analysis_initialize (int member, swt_wavelet *pWaveStruct)
{
  int    count;
  double *pFilterCoef;

  pWaveStruct->length = 6 * member;

  switch (member)
    {
    case 1:
      pFilterCoef = coif1;
      break;
    case 2:
      pFilterCoef = coif2;
      break;
    case 3:
      pFilterCoef = coif3;
      break;
    case 4:
      pFilterCoef = coif4;
      break;
    case 5:
      pFilterCoef = coif5;
      break;
    default:
      printf("db%d is not available!\n",member);
      exit(0);
    }

  wrev(pFilterCoef, pWaveStruct->length, 
       LowDecomFilCoef, pWaveStruct->length);
  qmf_wrev(pFilterCoef, pWaveStruct->length,
	   HiDecomFilCoef, pWaveStruct->length);
  for (count = 0; count < pWaveStruct->length; count++)
    LowDecomFilCoef[count] *= sqrt(2.0);
  for (count = 0; count < pWaveStruct->length; count++)
    HiDecomFilCoef[count] *= sqrt(2.0);
  pWaveStruct->pLowPass = LowDecomFilCoef;
  pWaveStruct->pHiPass = HiDecomFilCoef;

  return;
}


void
coiflets_synthesis_initialize (int member, swt_wavelet *pWaveStruct)
{
  int    count;
  double *pFilterCoef;

  pWaveStruct->length = 6 * member;

  switch (member)
    {
    case 1:
      pFilterCoef = coif1;
      break;
    case 2:
      pFilterCoef = coif2;
      break;
    case 3:
      pFilterCoef = coif3;
      break;
    case 4:
      pFilterCoef = coif4;
      break;
    case 5:
      pFilterCoef = coif5;
      break;
    default:
      printf("db%d is not available!\n",member);
      exit(0);
    }

  verbatim_copy(pFilterCoef, pWaveStruct->length,
		LowReconFilCoef, pWaveStruct->length);
  qmf_even(pFilterCoef, pWaveStruct->length,
      HiReconFilCoef, pWaveStruct->length );
  for (count = 0; count < pWaveStruct->length; count++)
    LowReconFilCoef[count] *= sqrt(2.0);
  for (count = 0; count < pWaveStruct->length; count++)
    HiReconFilCoef[count] *= sqrt(2.0);
  pWaveStruct->pLowPass = LowReconFilCoef;
  pWaveStruct->pHiPass = HiReconFilCoef;

  return;
}
